/*
 * Decompiled with CFR 0.152.
 */
package zone.rong.loliasm.client.screenshot;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import net.minecraftforge.client.event.ScreenshotEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import zone.rong.loliasm.LoliLogger;

public class ScreenshotListener {
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onScreenshot(ScreenshotEvent event) {
        if (!event.isCanceled() && event.getScreenshotFile() != null) {
            LoliLogger.instance.info("Copied screenshot {} to clipboard!", (Object)event.getScreenshotFile().getName());
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new TransferableImage(event.getImage()), null);
        }
    }

    private static class TransferableImage
    implements Transferable {
        final Image i;

        TransferableImage(Image i) {
            this.i = i;
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
            if (flavor.equals(DataFlavor.imageFlavor) && this.i != null) {
                return this.i;
            }
            throw new UnsupportedFlavorException(flavor);
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            DataFlavor[] flavors = new DataFlavor[]{DataFlavor.imageFlavor};
            return flavors;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return flavor.equals(DataFlavor.imageFlavor);
        }
    }
}

