/*
 * Decompiled with CFR 0.152.
 */
package zone.rong.loliasm.common.singletonevents.mixins.blocks;

import java.lang.ref.WeakReference;
import java.util.EnumSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import zone.rong.loliasm.common.singletonevents.IRefreshEvent;

@Mixin(value={BlockEvent.NeighborNotifyEvent.class})
public class NeighborNotifyEventMixin
extends BlockEvent
implements IRefreshEvent {
    @Shadow
    @Final
    @Mutable
    private EnumSet<EnumFacing> notifiedSides;
    @Shadow
    @Final
    @Mutable
    private boolean forceRedstoneUpdate;
    @Unique
    private EventPriority loliPriority;
    @Unique
    private WeakReference<World> loliWorldRef;
    @Unique
    private BlockPos loliPos;
    @Unique
    private IBlockState loliState;

    NeighborNotifyEventMixin(World world, BlockPos pos, IBlockState state) {
        super(world, pos, state);
        throw new AssertionError();
    }

    public World getWorld() {
        return (World)this.loliWorldRef.get();
    }

    public BlockPos getPos() {
        return this.loliPos;
    }

    public IBlockState getState() {
        return this.loliState;
    }

    @Override
    public void beforeNeighborNotify(World world, BlockPos pos, IBlockState state, EnumSet<EnumFacing> notifiedSides, boolean forceRedstoneUpdate) {
        this.loliWorldRef = new WeakReference<World>(world);
        this.loliPos = pos;
        this.loliState = state;
        this.notifiedSides = notifiedSides;
        this.forceRedstoneUpdate = forceRedstoneUpdate;
    }

    @Nullable
    public EventPriority getPhase() {
        return this.loliPriority;
    }

    public void setPhase(@Nonnull EventPriority next) {
        this.loliPriority = next;
    }
}

