/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.colony.buildings;

import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.IBuildingContainer;
import com.minecolonies.api.colony.buildings.IBuildingWorker;
import com.minecolonies.api.colony.buildings.ICitizenAssignable;
import com.minecolonies.api.colony.buildings.ISchematicProvider;
import com.minecolonies.api.colony.buildings.views.MobEntryView;
import com.minecolonies.api.colony.guardtype.GuardType;
import com.minecolonies.api.entity.ai.citizen.guards.GuardTask;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import org.jetbrains.annotations.Nullable;

public interface IGuardBuilding
extends ISchematicProvider,
ICitizenAssignable,
IBuildingContainer,
IBuilding,
IBuildingWorker {
    public static final int PATROL_DISTANCE = 40;

    public static boolean checkIfGuardShouldTakeDamage(AbstractEntityCitizen citizen, EntityPlayer player) {
        IBuildingWorker buildingWorker = citizen.getCitizenColonyHandler().getWorkBuilding();
        return !(buildingWorker instanceof IGuardBuilding) || ((IGuardBuilding)buildingWorker).getTask() != GuardTask.FOLLOW || !player.equals((Object)((IGuardBuilding)buildingWorker).getFollowPlayer());
    }

    public GuardTask getTask();

    public void setTask(GuardTask var1);

    public EntityPlayer getFollowPlayer();

    @Nullable
    public BlockPos getNextPatrolTarget(BlockPos var1);

    public int getDefenceBonus();

    public int getOffenceBonus();

    public int getPatrolDistance();

    public GuardType getGuardType();

    public void setGuardType(GuardType var1);

    public List<BlockPos> getPatrolTargets();

    public boolean shallRetrieveOnLowHealth();

    public void setRetrieveOnLowHealth(boolean var1);

    public boolean shallPatrolManually();

    public void setPatrolManually(boolean var1);

    public boolean shallAssignManually();

    public void setAssignManually(boolean var1);

    public boolean isTightGrouping();

    public void setTightGrouping(boolean var1);

    public BlockPos getGuardPos();

    public void setGuardPos(BlockPos var1);

    public Map<Class<? extends Entity>, MobEntryView> getMobsToAttack();

    public void setMobsToAttack(List<MobEntryView> var1);

    public BlockPos getPlayerToFollow();

    public void setPlayerToFollow(EntityPlayer var1);

    public void addPatrolTargets(BlockPos var1);

    public void resetPatrolTargets();

    public int getBonusVision();

    public void calculateMobs();
}

