/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.colony.guardtype;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.buildings.IBuildingWorker;
import com.minecolonies.api.colony.jobs.IJob;
import java.util.function.Function;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class GuardType
extends IForgeRegistryEntry.Impl<GuardType> {
    private final Function<ICitizenData, IJob> guardJobProducer;
    private final String jobTranslationKey;
    private final String buttonTranslationKey;
    private final IBuildingWorker.Skill primarySkill;
    private final IBuildingWorker.Skill secondarySkill;
    private final String workerSoundName;

    public GuardType(Function<ICitizenData, IJob> guardJobProducer, String jobTranslationKey, String buttonTranslationKey, IBuildingWorker.Skill primarySkill, IBuildingWorker.Skill secondarySkill, String workerSoundName) {
        this.guardJobProducer = guardJobProducer;
        this.jobTranslationKey = jobTranslationKey;
        this.buttonTranslationKey = buttonTranslationKey;
        this.primarySkill = primarySkill;
        this.secondarySkill = secondarySkill;
        this.workerSoundName = workerSoundName;
    }

    public Function<ICitizenData, IJob> getGuardJobProducer() {
        return this.guardJobProducer;
    }

    public String getJobTranslationKey() {
        return this.jobTranslationKey;
    }

    public String getButtonTranslationKey() {
        return this.buttonTranslationKey;
    }

    public IBuildingWorker.Skill getPrimarySkill() {
        return this.primarySkill;
    }

    public IBuildingWorker.Skill getSecondarySkill() {
        return this.secondarySkill;
    }

    public String getWorkerSoundName() {
        return this.workerSoundName;
    }

    public static class Builder {
        private Function<ICitizenData, IJob> guardJobProducer;
        private String jobTranslationKey;
        private String buttonTranslationKey;
        private IBuildingWorker.Skill primarySkill;
        private IBuildingWorker.Skill secondarySkill;
        private String workerSoundName;
        private ResourceLocation registryName;

        public Builder setGuardJobProducer(Function<ICitizenData, IJob> guardJobProducer) {
            this.guardJobProducer = guardJobProducer;
            return this;
        }

        public Builder setJobTranslationKey(String jobTranslationKey) {
            this.jobTranslationKey = jobTranslationKey;
            return this;
        }

        public Builder setButtonTranslationKey(String buttonTranslationKey) {
            this.buttonTranslationKey = buttonTranslationKey;
            return this;
        }

        public Builder setPrimarySkill(IBuildingWorker.Skill primarySkill) {
            this.primarySkill = primarySkill;
            return this;
        }

        public Builder setSecondarySkill(IBuildingWorker.Skill secondarySkill) {
            this.secondarySkill = secondarySkill;
            return this;
        }

        public Builder setWorkerSoundName(String workerSoundName) {
            this.workerSoundName = workerSoundName;
            return this;
        }

        public Builder setRegistryName(ResourceLocation registryName) {
            this.registryName = registryName;
            return this;
        }

        public GuardType createGuardType() {
            return (GuardType)new GuardType(this.guardJobProducer, this.jobTranslationKey, this.buttonTranslationKey, this.primarySkill, this.secondarySkill, this.workerSoundName).setRegistryName(this.registryName);
        }
    }
}

