/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.colony.interactionhandling;

import com.google.common.collect.ImmutableList;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.interactionhandling.ChatPriority;
import com.minecolonies.api.colony.interactionhandling.CustomITextComponentSerializer;
import com.minecolonies.api.colony.interactionhandling.IChatPriority;
import com.minecolonies.api.colony.interactionhandling.IInteractionResponseHandler;
import com.minecolonies.api.util.Tuple;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractInteractionResponseHandler
implements IInteractionResponseHandler {
    private ITextComponent inquiry;
    private Map<ITextComponent, ITextComponent> responses = new HashMap<ITextComponent, ITextComponent>();
    private boolean primary;
    private IChatPriority priority;

    @SafeVarargs
    public AbstractInteractionResponseHandler(@NotNull ITextComponent inquiry, boolean primary, IChatPriority priority, Tuple<ITextComponent, ITextComponent> ... responseTuples) {
        this.inquiry = inquiry;
        this.primary = primary;
        this.priority = priority;
        for (Tuple<ITextComponent, ITextComponent> element : responseTuples) {
            this.responses.put(element.getFirst(), element.getSecond());
        }
    }

    public AbstractInteractionResponseHandler() {
    }

    @Override
    public ITextComponent getInquiry() {
        return this.inquiry;
    }

    @Override
    @Nullable
    public ITextComponent getResponseResult(ITextComponent response) {
        return this.responses.getOrDefault(response, null);
    }

    @Override
    public List<ITextComponent> getPossibleResponses() {
        return ImmutableList.copyOf(this.responses.keySet());
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("inquiry", CustomITextComponentSerializer.componentToJson(this.inquiry));
        NBTTagList list = new NBTTagList();
        for (Map.Entry<ITextComponent, ITextComponent> element : this.responses.entrySet()) {
            NBTTagCompound elementTag = new NBTTagCompound();
            elementTag.func_74778_a("response", CustomITextComponentSerializer.componentToJson(element.getKey()));
            elementTag.func_74778_a("nextinquiry", CustomITextComponentSerializer.componentToJson(element.getValue()));
            list.func_74742_a((NBTBase)elementTag);
        }
        tag.func_74782_a("responses", (NBTBase)list);
        tag.func_74757_a("primary", this.isPrimary());
        tag.func_74768_a("priority", this.priority.getPriority());
        tag.func_74778_a("handlertype", this.getType());
        return tag;
    }

    public void deserializeNBT(@NotNull NBTTagCompound compoundNBT) {
        this.inquiry = CustomITextComponentSerializer.fromJsonLenient(compoundNBT.func_74779_i("inquiry"));
        NBTTagList list = compoundNBT.func_150295_c("responses", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound nbt = list.func_150305_b(i);
            this.responses.put(CustomITextComponentSerializer.fromJsonLenient(nbt.func_74779_i("response")), CustomITextComponentSerializer.fromJsonLenient(nbt.func_74779_i("nextinquiry")));
        }
        this.primary = compoundNBT.func_74767_n("primary");
        this.priority = ChatPriority.values()[compoundNBT.func_74762_e("priority")];
    }

    @Override
    public boolean isPrimary() {
        return this.primary;
    }

    @Override
    public IChatPriority getPriority() {
        return this.priority;
    }

    @Override
    public boolean isVisible(World world) {
        return true;
    }

    @Override
    public boolean isValid(ICitizenData colony) {
        return true;
    }
}

