/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.colony.interactionhandling;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.TypeAdapterFactory;
import com.minecolonies.api.colony.interactionhandling.TranslationTextComponent;
import java.lang.reflect.Type;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.util.EnumTypeAdapterFactory;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentKeybind;
import net.minecraft.util.text.TextComponentScore;
import net.minecraft.util.text.TextComponentSelector;
import net.minecraft.util.text.TextComponentString;

public class CustomITextComponentSerializer
implements JsonDeserializer<ITextComponent>,
JsonSerializer<ITextComponent> {
    public static final CustomITextComponentSerializer SERIALIZER = new CustomITextComponentSerializer();
    private final Gson gson;

    private CustomITextComponentSerializer() {
        GsonBuilder gsonbuilder = new GsonBuilder();
        gsonbuilder.registerTypeHierarchyAdapter(ITextComponent.class, (Object)this);
        gsonbuilder.registerTypeHierarchyAdapter(Style.class, (Object)new Style.Serializer());
        gsonbuilder.registerTypeAdapterFactory((TypeAdapterFactory)new EnumTypeAdapterFactory());
        this.gson = gsonbuilder.create();
    }

    public ITextComponent deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
        Object itextcomponent;
        if (json.isJsonPrimitive()) {
            return new TextComponentString(json.getAsString());
        }
        if (!json.isJsonObject()) {
            if (json.isJsonArray()) {
                JsonArray jsonArray = json.getAsJsonArray();
                ITextComponent textComponent = null;
                for (JsonElement jsonelement : jsonArray) {
                    ITextComponent subComponent = this.deserialize(jsonelement, jsonelement.getClass(), context);
                    if (textComponent == null) {
                        textComponent = subComponent;
                        continue;
                    }
                    textComponent.func_150257_a(subComponent);
                }
                return textComponent;
            }
            throw new JsonParseException("Don't know how to turn " + json + " into a Component");
        }
        JsonObject jsonobject = json.getAsJsonObject();
        if (jsonobject.has("text")) {
            itextcomponent = new TextComponentString(jsonobject.get("text").getAsString());
        } else if (jsonobject.has("translate")) {
            String s = jsonobject.get("translate").getAsString();
            if (jsonobject.has("with")) {
                JsonArray jsonarray = jsonobject.getAsJsonArray("with");
                Object[] args = new Object[jsonarray.size()];
                for (int i = 0; i < args.length; ++i) {
                    TextComponentString textcomponentstring;
                    args[i] = this.deserialize(jsonarray.get(i), type, context);
                    if (!(args[i] instanceof TextComponentString) || !(textcomponentstring = (TextComponentString)args[i]).func_150256_b().func_150229_g() || !textcomponentstring.func_150253_a().isEmpty()) continue;
                    args[i] = textcomponentstring.func_150265_g();
                }
                itextcomponent = new TranslationTextComponent(s, args);
            } else {
                itextcomponent = new TranslationTextComponent(s, new Object[0]);
            }
        } else if (jsonobject.has("score")) {
            JsonObject jsonObj = jsonobject.getAsJsonObject("score");
            if (!jsonObj.has("name") || !jsonObj.has("objective")) {
                throw new JsonParseException("A score component needs a least a name and an objective");
            }
            itextcomponent = new TextComponentScore(JsonUtils.func_151200_h((JsonObject)jsonObj, (String)"name"), JsonUtils.func_151200_h((JsonObject)jsonObj, (String)"objective"));
            if (jsonObj.has("value")) {
                ((TextComponentScore)itextcomponent).func_179997_b(JsonUtils.func_151200_h((JsonObject)jsonObj, (String)"value"));
            }
        } else if (jsonobject.has("selector")) {
            itextcomponent = new TextComponentSelector(JsonUtils.func_151200_h((JsonObject)jsonobject, (String)"selector"));
        } else {
            if (!jsonobject.has("keybind")) {
                throw new JsonParseException("Don't know how to turn " + json + " into a Component");
            }
            itextcomponent = new TextComponentKeybind(JsonUtils.func_151200_h((JsonObject)jsonobject, (String)"keybind"));
        }
        if (jsonobject.has("extra")) {
            JsonArray jsonArray = jsonobject.getAsJsonArray("extra");
            if (jsonArray.size() <= 0) {
                throw new JsonParseException("Unexpected empty array of components");
            }
            for (int j = 0; j < jsonArray.size(); ++j) {
                itextcomponent.func_150257_a(this.deserialize(jsonArray.get(j), type, context));
            }
        }
        itextcomponent.func_150255_a((Style)context.deserialize(json, Style.class));
        return itextcomponent;
    }

    private void serializeChatStyle(Style style, JsonObject object, JsonSerializationContext ctx) {
        JsonElement jsonelement = ctx.serialize((Object)style);
        if (jsonelement.isJsonObject()) {
            JsonObject jsonobject = (JsonObject)jsonelement;
            for (Map.Entry stringJsonElementEntry : jsonobject.entrySet()) {
                object.add((String)stringJsonElementEntry.getKey(), (JsonElement)stringJsonElementEntry.getValue());
            }
        }
    }

    public JsonElement serialize(ITextComponent component, Type type, JsonSerializationContext context) {
        JsonObject jsonobject = new JsonObject();
        if (!component.func_150256_b().func_150229_g()) {
            this.serializeChatStyle(component.func_150256_b(), jsonobject, context);
        }
        if (!component.func_150253_a().isEmpty()) {
            JsonArray jsonarray = new JsonArray();
            for (ITextComponent itextcomponent : component.func_150253_a()) {
                jsonarray.add(this.serialize(itextcomponent, (Type)itextcomponent.getClass(), context));
            }
            jsonobject.add("extra", (JsonElement)jsonarray);
        }
        if (component instanceof TextComponentString) {
            jsonobject.addProperty("text", ((TextComponentString)component).func_150265_g());
        } else if (component instanceof TranslationTextComponent) {
            TranslationTextComponent TranslationTextComponent2 = (TranslationTextComponent)component;
            jsonobject.addProperty("translate", TranslationTextComponent2.func_150268_i());
            TranslationTextComponent2.func_150271_j();
            if (TranslationTextComponent2.func_150271_j().length > 0) {
                Object[] formatArgs;
                JsonArray jsonElements = new JsonArray();
                for (Object arg : formatArgs = TranslationTextComponent2.func_150271_j()) {
                    if (arg instanceof ITextComponent) {
                        jsonElements.add(this.serialize((ITextComponent)arg, (Type)arg.getClass(), context));
                        continue;
                    }
                    jsonElements.add((JsonElement)new JsonPrimitive(String.valueOf(arg)));
                }
                jsonobject.add("with", (JsonElement)jsonElements);
            }
        } else if (component instanceof TextComponentScore) {
            TextComponentScore textcomponentscore = (TextComponentScore)component;
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("name", textcomponentscore.func_179995_g());
            jsonObject.addProperty("objective", textcomponentscore.func_179994_h());
            jsonObject.addProperty("value", textcomponentscore.func_150261_e());
            jsonobject.add("score", (JsonElement)jsonObject);
        } else if (component instanceof TextComponentSelector) {
            TextComponentSelector textcomponentselector = (TextComponentSelector)component;
            jsonobject.addProperty("selector", textcomponentselector.func_179992_g());
        } else {
            if (!(component instanceof TextComponentKeybind)) {
                throw new IllegalArgumentException("Don't know how to serialize " + component + " as a Component");
            }
            TextComponentKeybind textcomponentkeybind = (TextComponentKeybind)component;
            jsonobject.addProperty("keybind", textcomponentkeybind.func_193633_h());
        }
        return jsonobject;
    }

    public static String componentToJson(ITextComponent component) {
        return CustomITextComponentSerializer.SERIALIZER.gson.toJson((Object)component);
    }

    @Nullable
    public static ITextComponent jsonToComponent(String json) {
        return (ITextComponent)JsonUtils.func_188176_a((Gson)CustomITextComponentSerializer.SERIALIZER.gson, (String)json, ITextComponent.class, (boolean)false);
    }

    @Nullable
    public static ITextComponent fromJsonLenient(String json) {
        return (ITextComponent)JsonUtils.func_188176_a((Gson)CustomITextComponentSerializer.SERIALIZER.gson, (String)json, ITextComponent.class, (boolean)true);
    }
}

