/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.colony.requestsystem.resolver;

import com.google.common.collect.Lists;
import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.requestsystem.manager.IRequestManager;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.requestable.IRequestable;
import com.minecolonies.api.colony.requestsystem.requester.IRequester;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import java.util.List;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IRequestResolver<R extends IRequestable>
extends IRequester {
    public TypeToken<? extends R> getRequestType();

    public boolean canResolveRequest(@NotNull IRequestManager var1, IRequest<? extends R> var2);

    @Nullable
    public List<IToken<?>> attemptResolveRequest(@NotNull IRequestManager var1, @NotNull IRequest<? extends R> var2);

    @Nullable
    public void resolveRequest(@NotNull IRequestManager var1, @NotNull IRequest<? extends R> var2);

    default public void onRequestAssigned(@NotNull IRequestManager manager, @NotNull IRequest<? extends R> request, boolean simulation) {
    }

    public void onAssignedRequestBeingCancelled(@NotNull IRequestManager var1, @NotNull IRequest<? extends R> var2);

    public void onAssignedRequestCancelled(@NotNull IRequestManager var1, @NotNull IRequest<? extends R> var2);

    default public void onColonyUpdate(@NotNull IRequestManager manager, @NotNull Predicate<IRequest> shouldTriggerReassign) {
    }

    @Nullable
    default public List<IRequest<?>> getFollowupRequestForCompletion(@NotNull IRequestManager manager, @NotNull IRequest<? extends R> completedRequest) {
        return Lists.newArrayList();
    }

    public int getPriority();
}

