/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.blocks;

import com.minecolonies.api.blocks.huts.AbstractBlockMinecoloniesDefault;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.creativetab.ModCreativeTabs;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.tileentities.TileEntityScarecrow;
import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;

public class BlockScarecrow
extends AbstractBlockMinecoloniesDefault<BlockScarecrow> {
    public BlockScarecrow() {
        super(Material.field_151575_d);
        this.initBlock();
    }

    private void initBlock() {
        this.setRegistryName("minecolonies".toLowerCase() + ":" + "blockHutField");
        this.func_149663_c("minecolonies".toLowerCase(Locale.ENGLISH) + "." + "blockHutField");
        this.func_149647_a(ModCreativeTabs.MINECOLONIES);
        this.func_149752_b(10.0f);
        this.func_149711_c(10.0f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
    }

    @NotNull
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.INVISIBLE;
    }

    public int func_176201_c(@NotNull IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_176205_b(IBlockAccess worldIn, BlockPos pos) {
        return false;
    }

    @NotNull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return new AxisAlignedBB((double)0.1f, 0.0, (double)0.1f, (double)0.9f, 2.5, (double)0.9f);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    @NotNull
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.SOLID;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        IColony colony;
        if (!worldIn.field_72995_K && (colony = IColonyManager.getInstance().getColonyByPosFromWorld(worldIn, pos)) != null) {
            playerIn.openGui((Object)MineColonies.instance, 0, worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            return true;
        }
        return false;
    }

    @NotNull
    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        EnumFacing enumFacing = placer == null ? EnumFacing.NORTH : EnumFacing.func_176733_a((double)placer.field_70177_z);
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumFacing);
    }

    public void func_180633_a(@NotNull World worldIn, @NotNull BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntityScarecrow scareCrow;
        IColony colony;
        if (worldIn.field_72995_K) {
            return;
        }
        if (placer instanceof EntityPlayer && (colony = IColonyManager.getInstance().getColonyByPosFromWorld(worldIn, pos)) != null && (scareCrow = (TileEntityScarecrow)worldIn.func_175625_s(pos)) != null) {
            colony.getBuildingManager().addNewField(scareCrow, pos, worldIn);
        }
    }

    public void func_180652_a(World worldIn, BlockPos pos, Explosion explosionIn) {
        BlockScarecrow.notifyColonyAboutDestruction(worldIn, pos);
        super.func_180652_a(worldIn, pos, explosionIn);
    }

    public void func_176208_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player) {
        BlockScarecrow.notifyColonyAboutDestruction(worldIn, pos);
        super.func_176208_a(worldIn, pos, state, player);
    }

    public void func_176206_d(World worldIn, BlockPos pos, IBlockState state) {
        BlockScarecrow.notifyColonyAboutDestruction(worldIn, pos);
        super.func_176206_d(worldIn, pos, state);
    }

    private static void notifyColonyAboutDestruction(World worldIn, BlockPos pos) {
        IColony colony = IColonyManager.getInstance().getColonyByPosFromWorld(worldIn, pos);
        if (colony != null) {
            colony.getBuildingManager().removeField(pos);
        }
    }

    @NotNull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @NotNull
    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityScarecrow();
    }
}

