/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui;

import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.LanguageHandler;
import com.minecolonies.blockout.Pane;
import com.minecolonies.blockout.controls.Button;
import com.minecolonies.blockout.controls.ButtonImage;
import com.minecolonies.blockout.controls.ItemIcon;
import com.minecolonies.blockout.controls.Label;
import com.minecolonies.blockout.views.ScrollingList;
import com.minecolonies.coremod.client.gui.AbstractWindowBuilding;
import com.minecolonies.coremod.client.gui.WindowsBarracksSpies;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingBarracks;
import java.util.List;
import net.minecraft.init.Items;
import net.minecraft.util.math.BlockPos;
import org.jetbrains.annotations.NotNull;

public class WindowBarracksBuilding
extends AbstractWindowBuilding<BuildingBarracks.View> {
    private static final String LIST_POSITIONS = "positions";
    private static final String LABEL_POS = "pos";
    private static final String LABEL_CURRENNT = "current";
    private static final String HOME_BUILDING_RESOURCE_SUFFIX = ":gui/windowHutBarracks.xml";
    private static final String SPIES_BUTTON = "hireSpies";
    private static final String SPIES_BUTTON_ICON = "hireSpiesIcon";
    private static final int BUILDING_LEVEL_FOR_LIST = 3;
    private static final long QUITE_CLOSE = 50L;
    private static final long QUITE_FAR = 100L;
    private final ScrollingList positionsList;
    private final IColonyView view;

    public WindowBarracksBuilding(BuildingBarracks.View building) {
        super(building, "minecolonies:gui/windowHutBarracks.xml");
        this.view = building.getColony();
        this.positionsList = this.findPaneOfTypeByID(LIST_POSITIONS, ScrollingList.class);
        this.findPaneOfTypeByID(SPIES_BUTTON_ICON, ItemIcon.class).setItem(Items.field_151043_k.func_190903_i());
        this.registerButton(SPIES_BUTTON, this::hireSpiesClicked);
        if (building.getBuildingLevel() < 3) {
            this.findPaneOfTypeByID(SPIES_BUTTON, ButtonImage.class).setVisible(false);
            this.findPaneOfTypeByID(SPIES_BUTTON_ICON, ItemIcon.class).setVisible(false);
        }
    }

    @Override
    @NotNull
    public String getBuildingName() {
        return "com.minecolonies.coremod.gui.workerHuts.buildBarracks";
    }

    private void hireSpiesClicked(Button button) {
        WindowsBarracksSpies window = new WindowsBarracksSpies(this.building, ((BuildingBarracks.View)this.building).getID());
        window.open();
    }

    @Override
    public void onOpened() {
        super.onOpened();
        if (((BuildingBarracks.View)this.building).getBuildingLevel() >= 3) {
            final List<BlockPos> spawnPoints = this.view.getLastSpawnPoints();
            if (spawnPoints.size() == 0) {
                return;
            }
            if (this.view.isRaiding()) {
                this.findPaneOfTypeByID(LABEL_CURRENNT, Label.class).setLabelText(this.mountDistanceString(spawnPoints.get(spawnPoints.size() - 1)));
            }
            this.positionsList.setDataProvider(new ScrollingList.DataProvider(){

                @Override
                public int getElementCount() {
                    return spawnPoints.size() - (WindowBarracksBuilding.this.view.isRaiding() ? 1 : 0);
                }

                @Override
                public void updateElement(int index, @NotNull Pane rowPane) {
                    BlockPos pos = (BlockPos)spawnPoints.get(index);
                    if (!WindowBarracksBuilding.this.view.isRaiding() || index != spawnPoints.size() - 1) {
                        rowPane.findPaneOfTypeByID(WindowBarracksBuilding.LABEL_POS, Label.class).setLabelText(index + 1 + ": " + WindowBarracksBuilding.this.mountDistanceString(pos));
                    }
                }
            });
        }
    }

    private String mountDistanceString(BlockPos pos) {
        long distance = BlockPosUtil.getDistance2D(pos, ((BuildingBarracks.View)this.building).getPosition());
        String distanceDesc = distance < 50L ? LanguageHandler.format("com.minecolonies.coremod.max.schematic.quiteclose", new Object[0]) : (distance < 100L ? LanguageHandler.format("com.minecolonies.coremod.max.schematic.quitefar", new Object[0]) : LanguageHandler.format("com.minecolonies.coremod.max.schematic.reallyfar", new Object[0]));
        String directionDest = BlockPosUtil.calcDirection(((BuildingBarracks.View)this.building).getPosition(), pos);
        return distanceDesc + " " + directionDest;
    }
}

