/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui;

import com.minecolonies.api.colony.buildings.views.MobEntryView;
import com.minecolonies.api.colony.guardtype.GuardType;
import com.minecolonies.api.colony.guardtype.registry.IGuardTypeRegistry;
import com.minecolonies.api.entity.ai.citizen.guards.GuardTask;
import com.minecolonies.api.util.LanguageHandler;
import com.minecolonies.api.util.constant.WindowConstants;
import com.minecolonies.blockout.Pane;
import com.minecolonies.blockout.controls.Button;
import com.minecolonies.blockout.controls.Label;
import com.minecolonies.blockout.views.ScrollingList;
import com.minecolonies.blockout.views.SwitchView;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.client.gui.AbstractWindowWorkerBuilding;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingGuards;
import com.minecolonies.coremod.colony.buildings.views.AbstractBuildingView;
import com.minecolonies.coremod.network.messages.GuardRecalculateMessage;
import com.minecolonies.coremod.network.messages.GuardScepterMessage;
import com.minecolonies.coremod.network.messages.GuardTaskMessage;
import com.minecolonies.coremod.network.messages.MobEntryChangeMessage;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;

public class WindowHutGuardTower
extends AbstractWindowWorkerBuilding<AbstractBuildingGuards.View> {
    private final Button buttonTaskPatrol;
    private final Button buttonTaskFollow;
    private final Button buttonTaskGuard;
    private final Button buttonSetTarget;
    private ScrollingList listOfPoints;
    private boolean assignManually = false;
    private boolean retrieveOnLowHealth = false;
    private boolean patrolManually = false;
    private boolean tightGrouping = true;
    private GuardTask task = GuardTask.GUARD;
    private GuardType job = null;
    private List<BlockPos> patrolTargets = new ArrayList<BlockPos>();
    private List<MobEntryView> mobsToAttack = new ArrayList<MobEntryView>();

    public WindowHutGuardTower(AbstractBuildingGuards.View building) {
        super(building, "minecolonies:gui/windowHutGuardTower.xml");
        this.registerButton("job", this::switchJob);
        this.registerButton("assign", this::switchAssignmentMode);
        this.registerButton("patrol", this::switchPatrolMode);
        this.registerButton("retrieve", this::switchRetrievalMode);
        this.registerButton("setTarget", this::setTarget);
        this.registerButton("recalculate", this::recalculate);
        this.registerButton("getTool", this::getTool);
        this.registerButton("patrolling", this::switchTask);
        this.registerButton("following", this::switchTask);
        this.registerButton("guarding", this::switchTask);
        this.registerButton("switch", this::switchAttackMode);
        this.registerButton("prioUp", this::updatePriority);
        this.registerButton("prioDown", this::updatePriority);
        this.buttonTaskPatrol = this.findPaneOfTypeByID("patrolling", Button.class);
        this.buttonTaskFollow = this.findPaneOfTypeByID("following", Button.class);
        this.buttonTaskGuard = this.findPaneOfTypeByID("guarding", Button.class);
        this.buttonSetTarget = this.findPaneOfTypeByID("setTarget", Button.class);
    }

    private void getTool() {
        this.givePlayerScepter(((AbstractBuildingGuards.View)this.building).getTask());
    }

    @Override
    public void onOpened() {
        super.onOpened();
        this.pullInfoFromHut();
        this.listOfPoints = this.findPaneOfTypeByID("positions", ScrollingList.class);
        if (this.task.equals((Object)GuardTask.PATROL)) {
            this.listOfPoints.setDataProvider(new ScrollingList.DataProvider(){

                @Override
                public int getElementCount() {
                    return WindowHutGuardTower.this.patrolTargets.size();
                }

                @Override
                public void updateElement(int index, @NotNull Pane rowPane) {
                    BlockPos pos = (BlockPos)WindowHutGuardTower.this.patrolTargets.get(index);
                    rowPane.findPaneOfTypeByID("position", Label.class).setLabelText(pos.func_177958_n() + " " + pos.func_177956_o() + " " + pos.func_177952_p());
                }
            });
        } else if (this.task.equals((Object)GuardTask.GUARD)) {
            this.listOfPoints.setDataProvider(new ScrollingList.DataProvider(){

                @Override
                public int getElementCount() {
                    return 1;
                }

                @Override
                public void updateElement(int index, @NotNull Pane rowPane) {
                    BlockPos pos = ((AbstractBuildingGuards.View)WindowHutGuardTower.this.building).getGuardPos();
                    rowPane.findPaneOfTypeByID("position", Label.class).setLabelText(pos.func_177958_n() + " " + pos.func_177956_o() + " " + pos.func_177952_p());
                }
            });
        }
        ScrollingList mobsList = this.findPaneOfTypeByID("mobs", ScrollingList.class);
        mobsList.setDataProvider(new ScrollingList.DataProvider(){

            @Override
            public int getElementCount() {
                return WindowHutGuardTower.this.mobsToAttack.size();
            }

            @Override
            public void updateElement(int index, Pane rowPane) {
                String name = ((MobEntryView)WindowHutGuardTower.this.mobsToAttack.get(index)).getName();
                rowPane.findPaneOfTypeByID("name", Label.class).setLabelText(name);
                Button switchButton = rowPane.findPaneOfTypeByID("switch", Button.class);
                if (((MobEntryView)WindowHutGuardTower.this.mobsToAttack.get(index)).shouldAttack()) {
                    switchButton.setLabel(WindowConstants.GUI_SWITCH_ON);
                } else {
                    switchButton.setLabel(WindowConstants.GUI_SWITCH_OFF);
                }
            }
        });
    }

    @Override
    public void onButtonClicked(@NotNull Button button) {
        super.onButtonClicked(button);
        this.handleButtons();
    }

    @Override
    public void onUpdate() {
        Pane currentPane;
        super.onUpdate();
        this.pullInfoFromHut();
        if (!this.task.equals((Object)GuardTask.PATROL)) {
            this.listOfPoints.hide();
        }
        if ((currentPane = this.findPaneOfTypeByID("pages", SwitchView.class).getCurrentView()) != null) {
            String currentPage = currentPane.getID();
            if (currentPage.equals("levelActions")) {
                this.pullInfoFromHut();
                this.window.findPaneOfTypeByID("positions", ScrollingList.class).refreshElementPanes();
            } else if (currentPage.equals("mobActions")) {
                this.pullInfoFromHut();
                this.sortMobsToAttack();
                this.window.findPaneOfTypeByID("mobs", ScrollingList.class).refreshElementPanes();
            }
        }
    }

    @Override
    @NotNull
    public String getBuildingName() {
        return "com.minecolonies.coremod.gui.workerHuts.GuardTower";
    }

    private void sortMobsToAttack() {
        this.mobsToAttack.sort(Comparator.comparing(MobEntryView::getPriority, Comparator.reverseOrder()));
    }

    private void handleButtons() {
        Button buttonJob = this.findPaneOfTypeByID("job", Button.class);
        if (this.job != null) {
            buttonJob.setLabel(LanguageHandler.format(this.job.getButtonTranslationKey(), new Object[0]));
        }
        buttonJob.setEnabled(this.assignManually);
        this.findPaneOfTypeByID("assign", Button.class).setLabel(this.assignManually ? WindowConstants.GUI_SWITCH_MANUAL : WindowConstants.GUI_SWITCH_AUTO);
        this.findPaneOfTypeByID("patrol", Button.class).setLabel(this.patrolManually ? WindowConstants.GUI_SWITCH_MANUAL : WindowConstants.GUI_SWITCH_AUTO);
        this.findPaneOfTypeByID("retrieve", Button.class).setLabel(this.retrieveOnLowHealth ? WindowConstants.GUI_SWITCH_ON : WindowConstants.GUI_SWITCH_OFF);
        if (this.task.equals((Object)GuardTask.PATROL)) {
            this.buttonSetTarget.setEnabled(this.patrolManually);
            if (this.patrolManually) {
                this.buttonSetTarget.setLabel(LanguageHandler.format("com.minecolonies.coremod.gui.workerHuts.targetPatrol", new Object[0]));
            } else {
                this.buttonSetTarget.setLabel("");
            }
            this.buttonTaskPatrol.setEnabled(false);
        } else if (this.task.equals((Object)GuardTask.FOLLOW)) {
            this.buttonTaskFollow.setEnabled(false);
            if (this.tightGrouping) {
                this.buttonSetTarget.setLabel(LanguageHandler.format("com.minecolonies.coremod.gui.workerHuts.followTight", new Object[0]));
            } else {
                this.buttonSetTarget.setLabel(LanguageHandler.format("com.minecolonies.coremod.gui.workerHuts.followLoose", new Object[0]));
            }
        } else if (this.task.equals((Object)GuardTask.GUARD)) {
            this.buttonSetTarget.setLabel(LanguageHandler.format("com.minecolonies.coremod.gui.workerHuts.targetGuard", new Object[0]));
            this.buttonTaskGuard.setEnabled(false);
        }
    }

    private void switchJob() {
        if (((AbstractBuildingGuards.View)this.building).getGuardType() == null) {
            ArrayList guardTypes = new ArrayList(IGuardTypeRegistry.getInstance().getValuesCollection());
            this.job = (GuardType)((Object)guardTypes.get(new Random().nextInt(guardTypes.size())));
        } else {
            ArrayList possibleGuardTypes;
            GuardType guardType = ((AbstractBuildingGuards.View)this.building).getGuardType();
            int currentGuardTypeIndex = (possibleGuardTypes = new ArrayList(IGuardTypeRegistry.getInstance().getValuesCollection())).indexOf((Object)guardType);
            GuardType nextGuardType = (GuardType)((Object)possibleGuardTypes.get(currentGuardTypeIndex == possibleGuardTypes.size() - 1 ? 0 : currentGuardTypeIndex + 1));
            ((AbstractBuildingGuards.View)this.building).setGuardType(nextGuardType);
        }
        this.pullInfoFromHut();
        this.sendChangesToServer();
    }

    private void switchAttackMode(@NotNull Button button) {
        Label idLabel = (Label)button.getParent().getChildren().get(WindowConstants.GUI_LIST_ELEMENT_NAME_POS);
        if (idLabel != null) {
            for (MobEntryView entry : this.mobsToAttack) {
                if (!entry.getName().equals(idLabel.getLabelText())) continue;
                entry.setShouldAttack(!entry.shouldAttack());
            }
            MineColonies.getNetwork().sendToServer((IMessage)new MobEntryChangeMessage((AbstractBuildingGuards.View)this.building, this.mobsToAttack));
            this.window.findPaneOfTypeByID("mobs", ScrollingList.class).refreshElementPanes();
        }
    }

    private void updatePriority(@NotNull Button button) {
        Label idLabel = (Label)button.getParent().getChildren().get(WindowConstants.GUI_LIST_ELEMENT_NAME_POS);
        String buttonLabel = button.getID();
        for (MobEntryView mobEntry : this.mobsToAttack) {
            if (!mobEntry.getName().equals(idLabel.getLabelText())) continue;
            if (buttonLabel.equals("prioUp") && mobEntry.getPriority() < this.mobsToAttack.size()) {
                for (MobEntryView mobEntryView : this.mobsToAttack) {
                    if (mobEntryView.getPriority() != mobEntry.getPriority() + 1) continue;
                    mobEntry.setPriority(mobEntry.getPriority() + 1);
                    mobEntryView.setPriority(mobEntryView.getPriority() - 1);
                    break;
                }
                this.sortMobsToAttack();
                MineColonies.getNetwork().sendToServer((IMessage)new MobEntryChangeMessage((AbstractBuildingGuards.View)this.building, this.mobsToAttack));
                this.window.findPaneOfTypeByID("mobs", ScrollingList.class).refreshElementPanes();
                return;
            }
            if (!buttonLabel.equals("prioDown") || mobEntry.getPriority() <= 1) continue;
            for (MobEntryView mobEntryView : this.mobsToAttack) {
                if (mobEntryView.getPriority() != mobEntry.getPriority() - 1) continue;
                mobEntry.setPriority(mobEntry.getPriority() - 1);
                mobEntryView.setPriority(mobEntryView.getPriority() + 1);
                break;
            }
            this.sortMobsToAttack();
            MineColonies.getNetwork().sendToServer((IMessage)new MobEntryChangeMessage((AbstractBuildingGuards.View)this.building, this.mobsToAttack));
            this.window.findPaneOfTypeByID("mobs", ScrollingList.class).refreshElementPanes();
            return;
        }
    }

    private void pullInfoFromHut() {
        this.assignManually = ((AbstractBuildingGuards.View)this.building).isAssignManually();
        this.patrolManually = ((AbstractBuildingGuards.View)this.building).isPatrolManually();
        this.retrieveOnLowHealth = ((AbstractBuildingGuards.View)this.building).isRetrieveOnLowHealth();
        this.tightGrouping = ((AbstractBuildingGuards.View)this.building).isTightGrouping();
        this.task = ((AbstractBuildingGuards.View)this.building).getTask();
        this.job = ((AbstractBuildingGuards.View)this.building).getGuardType();
        this.patrolTargets = ((AbstractBuildingGuards.View)this.building).getPatrolTargets();
        this.mobsToAttack = ((AbstractBuildingGuards.View)this.building).getMobsToAttack();
    }

    private void switchTask(Button button) {
        if (button.getID().contains("patrolling")) {
            ((AbstractBuildingGuards.View)this.building).setTask(GuardTask.PATROL);
            this.buttonTaskPatrol.setEnabled(false);
            this.buttonTaskFollow.setEnabled(true);
            this.buttonTaskGuard.setEnabled(true);
            this.buttonSetTarget.show();
        } else if (button.getID().contains("following")) {
            ((AbstractBuildingGuards.View)this.building).setTask(GuardTask.FOLLOW);
            this.buttonTaskPatrol.setEnabled(true);
            this.buttonTaskFollow.setEnabled(false);
            this.buttonTaskGuard.setEnabled(true);
            this.buttonSetTarget.setEnabled(true);
            this.buttonSetTarget.show();
        } else {
            ((AbstractBuildingGuards.View)this.building).setTask(GuardTask.GUARD);
            this.buttonTaskPatrol.setEnabled(true);
            this.buttonTaskFollow.setEnabled(true);
            this.buttonTaskGuard.setEnabled(false);
            this.buttonSetTarget.show();
        }
        this.pullInfoFromHut();
        this.sendChangesToServer();
    }

    private void setTarget() {
        EntityPlayerSP player = this.mc.field_71439_g;
        int emptySlot = player.field_71071_by.func_70447_i();
        this.pullInfoFromHut();
        if (emptySlot == -1) {
            LanguageHandler.sendPlayerMessage((EntityPlayer)player, "com.minecolonies.coremod.gui.workerHuts.noSpace", new Object[0]);
        }
        if (this.patrolManually && this.task.equals((Object)GuardTask.PATROL)) {
            this.givePlayerScepter(GuardTask.PATROL);
            LanguageHandler.sendPlayerMessage((EntityPlayer)player, "com.minecolonies.coremod.job.guard.tool.taskPatrol", new Object[0]);
        } else {
            if (this.task.equals((Object)GuardTask.FOLLOW)) {
                this.tightGrouping = !this.tightGrouping;
                ((AbstractBuildingGuards.View)this.building).setTightGrouping(this.tightGrouping);
                this.pullInfoFromHut();
                this.sendChangesToServer();
                return;
            }
            if (this.task.equals((Object)GuardTask.GUARD)) {
                this.givePlayerScepter(GuardTask.GUARD);
                LanguageHandler.sendPlayerMessage((EntityPlayer)player, "com.minecolonies.coremod.job.guard.tool.taskGuard", new Object[0]);
            }
        }
        this.window.close();
    }

    private void recalculate() {
        MineColonies.getNetwork().sendToServer((IMessage)new GuardRecalculateMessage(((AbstractBuildingGuards.View)this.building).getColony().getID(), (AbstractBuildingView)this.building));
        this.pullInfoFromHut();
    }

    private void givePlayerScepter(GuardTask localTask) {
        MineColonies.getNetwork().sendToServer((IMessage)new GuardScepterMessage(localTask.ordinal(), ((AbstractBuildingGuards.View)this.building).getID(), ((AbstractBuildingGuards.View)this.building).getColony().getID()));
    }

    private void switchRetrievalMode() {
        ((AbstractBuildingGuards.View)this.building).setRetrieveOnLowHealth(!((AbstractBuildingGuards.View)this.building).isRetrieveOnLowHealth());
        this.pullInfoFromHut();
        this.sendChangesToServer();
        this.findPaneOfTypeByID("retrieve", Button.class).setLabel(this.retrieveOnLowHealth ? WindowConstants.GUI_SWITCH_ON : WindowConstants.GUI_SWITCH_OFF);
    }

    private void switchPatrolMode() {
        ((AbstractBuildingGuards.View)this.building).setPatrolManually(!((AbstractBuildingGuards.View)this.building).isPatrolManually());
        this.pullInfoFromHut();
        this.sendChangesToServer();
    }

    private void switchAssignmentMode() {
        ((AbstractBuildingGuards.View)this.building).setAssignManually(!((AbstractBuildingGuards.View)this.building).isAssignManually());
        this.pullInfoFromHut();
        this.sendChangesToServer();
    }

    private void sendChangesToServer() {
        ResourceLocation resourceName = ((AbstractBuildingGuards.View)this.building).getGuardType() == null ? new ResourceLocation("") : ((AbstractBuildingGuards.View)this.building).getGuardType().getRegistryName();
        MineColonies.getNetwork().sendToServer((IMessage)new GuardTaskMessage((AbstractBuildingGuards.View)this.building, resourceName, this.assignManually, this.patrolManually, this.retrieveOnLowHealth, this.task.ordinal(), this.tightGrouping));
    }
}

