/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui;

import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.util.LanguageHandler;
import com.minecolonies.blockout.controls.Button;
import com.minecolonies.blockout.views.View;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.client.gui.AbstractHutFilterableLists;
import com.minecolonies.coremod.client.gui.ViewFilterableList;
import com.minecolonies.coremod.colony.buildings.views.AbstractFilterableListsView;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingLumberjack;
import com.minecolonies.coremod.network.messages.LumberjackReplantSaplingToggleMessage;
import com.minecolonies.coremod.network.messages.LumberjackRestrictionToggleMessage;
import com.minecolonies.coremod.network.messages.LumberjackScepterMessage;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Tuple;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;

public class WindowHutLumberjack
extends AbstractHutFilterableLists {
    private static final String BUTTON_TOGGLE_REPLANT = "saplingReplant";
    private static final String BUTTON_GIVE_TOOL = "giveTool";
    private static final String BUTTON_TOGGLE_RESTRICTION = "toggleRestriction";
    private static final String PAGE_ITEMS_VIEW = "saplings";
    private static final String RESOURCE_STRING = ":gui/windowhutlumberjack.xml";
    private final BuildingLumberjack.View ownBuilding;

    public WindowHutLumberjack(BuildingLumberjack.View building) {
        super(building, "minecolonies:gui/windowhutlumberjack.xml", new Tuple[0]);
        ViewFilterableList window = new ViewFilterableList(this.findPaneOfTypeByID(PAGE_ITEMS_VIEW, View.class), this, building, LanguageHandler.format("com.minecolonies.coremod.gui.workerHuts.saplingList", new Object[0]), PAGE_ITEMS_VIEW, true);
        this.views.put(PAGE_ITEMS_VIEW, window);
        this.ownBuilding = building;
        this.registerButton(BUTTON_TOGGLE_REPLANT, this::switchReplant);
        this.registerButton(BUTTON_TOGGLE_RESTRICTION, this::toggleRestriction);
        this.registerButton(BUTTON_GIVE_TOOL, this::giveTool);
        this.setupReplantButton(this.findPaneOfTypeByID(BUTTON_TOGGLE_REPLANT, Button.class));
        this.setupRestrictionButton(this.findPaneOfTypeByID(BUTTON_TOGGLE_RESTRICTION, Button.class));
        this.setupGiveToolButton(this.findPaneOfTypeByID(BUTTON_GIVE_TOOL, Button.class));
    }

    private void giveTool() {
        this.givePlayerScepter();
    }

    private void givePlayerScepter() {
        MineColonies.getNetwork().sendToServer((IMessage)new LumberjackScepterMessage(((AbstractFilterableListsView)this.building).getID(), ((AbstractFilterableListsView)this.building).getColony().getID()));
    }

    @Override
    public List<? extends ItemStorage> getBlockList(Predicate<ItemStack> filterPredicate, String id) {
        return IColonyManager.getInstance().getCompatibilityManager().getCopyOfSaplings().stream().filter(storage -> filterPredicate.test(storage.getItemStack())).collect(Collectors.toList());
    }

    private void setupReplantButton(Button button) {
        if (this.ownBuilding.shouldReplant) {
            button.setLabel(LanguageHandler.format("com.minecolonies.coremod.gui.workerHuts.toggleReplantSaplingsOn", new Object[0]));
        } else {
            button.setLabel(LanguageHandler.format("com.minecolonies.coremod.gui.workerHuts.toggleReplantSaplingsOff", new Object[0]));
        }
    }

    private void setupGiveToolButton(Button button) {
        button.setLabel(LanguageHandler.format("Give tool", new Object[0]));
    }

    private void setupRestrictionButton(Button button) {
        button.setLabel(LanguageHandler.format(this.ownBuilding.shouldRestrict ? "com.minecolonies.coremod.gui.workerHuts.togglerestrictionon" : "com.minecolonies.coremod.gui.workerHuts.togglerestrictionoff", new Object[0]));
    }

    private void switchReplant(Button replant) {
        this.ownBuilding.shouldReplant = !this.ownBuilding.shouldReplant;
        this.setupReplantButton(replant);
        MineColonies.getNetwork().sendToServer((IMessage)new LumberjackReplantSaplingToggleMessage(this.ownBuilding, this.ownBuilding.shouldReplant));
    }

    private void toggleRestriction(Button restriction) {
        this.ownBuilding.shouldRestrict = !this.ownBuilding.shouldRestrict;
        this.setupRestrictionButton(restriction);
        MineColonies.getNetwork().sendToServer((IMessage)new LumberjackRestrictionToggleMessage(this.ownBuilding, this.ownBuilding.shouldRestrict));
    }

    @Override
    @NotNull
    public String getBuildingName() {
        return "com.minecolonies.coremod.job.Lumberjack";
    }
}

