/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui;

import com.ldtteam.structures.blueprints.v1.Blueprint;
import com.ldtteam.structures.helpers.Settings;
import com.ldtteam.structures.helpers.Structure;
import com.ldtteam.structures.lib.BlueprintUtils;
import com.ldtteam.structurize.Structurize;
import com.ldtteam.structurize.client.gui.WindowBuildTool;
import com.ldtteam.structurize.management.StructureName;
import com.ldtteam.structurize.management.Structures;
import com.ldtteam.structurize.network.messages.LSStructureDisplayerMessage;
import com.ldtteam.structurize.network.messages.SchematicRequestMessage;
import com.ldtteam.structurize.util.PlacementSettings;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.util.BlockUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.client.gui.AbstractWindowSkeleton;
import com.minecolonies.coremod.network.messages.BuildingMoveMessage;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WindowMoveBuilding
extends AbstractWindowSkeleton {
    private static final int POSSIBLE_ROTATIONS = 4;
    private static final int ROTATE_RIGHT = 1;
    private static final int ROTATE_180 = 2;
    private static final int ROTATE_LEFT = 3;
    @NotNull
    private final BlockPos pos;
    private final String schematicName;
    private final IBuildingView building;

    public WindowMoveBuilding(@Nullable BlockPos pos, IBuildingView building, String schematicName) {
        super("minecolonies:gui/windowmovebuilding.xml");
        this.building = building;
        this.schematicName = schematicName;
        this.pos = pos;
        this.init();
    }

    private void init() {
        this.registerButton("confirm", this::confirmClicked);
        this.registerButton("cancel", this::cancelClicked);
        this.registerButton("left", this::moveLeftClicked);
        this.registerButton("mirror", WindowMoveBuilding::mirror);
        this.registerButton("right", this::moveRightClicked);
        this.registerButton("down", this::moveBackClicked);
        this.registerButton("up", this::moveForwardClicked);
        this.registerButton("plus", WindowMoveBuilding::moveUpClicked);
        this.registerButton("minus", WindowMoveBuilding::moveDownClicked);
        this.registerButton("rotateRight", this::rotateRightClicked);
        this.registerButton("rotateLeft", this::rotateLeftClicked);
    }

    private static void mirror() {
        Settings.instance.mirror();
    }

    @Override
    public void onOpened() {
        if (Settings.instance.getActiveStructure() == null) {
            Settings.instance.setRotation(this.building.getRotation());
            if (this.building.isMirrored()) {
                Settings.instance.mirror();
            }
            Settings.instance.setPosition(this.pos);
            PlacementSettings settings = new PlacementSettings(Settings.instance.getMirror(), BlockUtils.getRotation(Settings.instance.getRotation()));
            StructureName structureName = new StructureName("schematics", this.schematicName, this.building.getSchematicName() + this.building.getBuildingLevel());
            Structure structure = new Structure((World)Minecraft.func_71410_x().field_71441_e, structureName.toString(), settings);
            String md5 = Structures.getMD5((String)structureName.toString());
            if (structure.isBluePrintMissing() || !structure.isCorrectMD5(md5)) {
                if (structure.isBluePrintMissing()) {
                    Log.getLogger().info("Template structure " + structureName + " missing");
                } else {
                    Log.getLogger().info("structure " + structureName + " md5 error");
                }
                Log.getLogger().info("Request To Server for structure " + structureName);
                if (FMLCommonHandler.instance().getMinecraftServerInstance() == null) {
                    Structurize.getNetwork().sendToServer((IMessage)new SchematicRequestMessage(structureName.toString()));
                    return;
                }
                Log.getLogger().error("WindowMinecoloniesBuildTool: Need to download schematic on a standalone client/server. This should never happen");
            }
            Settings.instance.setStructureName(structureName.toString());
            Settings.instance.setActiveSchematic(structure);
        }
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (IColonyManager.getInstance().isSchematicDownloaded()) {
            IColonyManager.getInstance().setSchematicDownloaded(false);
        }
    }

    private static void moveUpClicked() {
        Settings.instance.moveTo(new BlockPos(0, 1, 0));
    }

    private static void moveDownClicked() {
        Settings.instance.moveTo(new BlockPos(0, -1, 0));
    }

    private void moveLeftClicked() {
        Settings.instance.moveTo(new BlockPos(0, 0, 0).func_177972_a(this.mc.field_71439_g.func_174811_aO().func_176735_f()));
    }

    private void moveRightClicked() {
        Settings.instance.moveTo(new BlockPos(0, 0, 0).func_177972_a(this.mc.field_71439_g.func_174811_aO().func_176746_e()));
    }

    private void moveForwardClicked() {
        Settings.instance.moveTo(new BlockPos(0, 0, 0).func_177972_a(this.mc.field_71439_g.func_174811_aO()));
    }

    private void moveBackClicked() {
        Settings.instance.moveTo(new BlockPos(0, 0, 0).func_177972_a(this.mc.field_71439_g.func_174811_aO().func_176734_d()));
    }

    private void rotateRightClicked() {
        WindowMoveBuilding.updateRotation((Settings.instance.getRotation() + 1) % 4);
    }

    private void rotateLeftClicked() {
        WindowMoveBuilding.updateRotation((Settings.instance.getRotation() + 3) % 4);
    }

    private void confirmClicked() {
        if (Settings.instance.getStructureName() == null) {
            return;
        }
        StructureName structureName = new StructureName(Settings.instance.getStructureName());
        if (structureName.getPrefix().equals("scans") && FMLCommonHandler.instance().getMinecraftServerInstance() == null) {
            WindowBuildTool.requestScannedSchematic((StructureName)structureName);
        } else {
            BlockPos offset = BlueprintUtils.getPrimaryBlockOffset((Blueprint)Settings.instance.getActiveStructure().getBluePrint());
            IBlockState state = Settings.instance.getActiveStructure().getBlockState(offset);
            MineColonies.getNetwork().sendToServer((IMessage)new BuildingMoveMessage(structureName.toString(), structureName.toString(), Settings.instance.getPosition(), Settings.instance.getRotation(), Settings.instance.getMirror(), this.building, state));
        }
        if (!GuiScreen.func_146272_n()) {
            this.cancelClicked();
        }
    }

    private void cancelClicked() {
        this.building.openGui(false);
        Settings.instance.reset();
        Structurize.getNetwork().sendToServer((IMessage)new LSStructureDisplayerMessage(Unpooled.buffer(), false));
        this.close();
    }

    private static void updateRotation(int rotation) {
        PlacementSettings settings = new PlacementSettings();
        switch (rotation) {
            case 1: {
                settings.setRotation(Rotation.CLOCKWISE_90);
                break;
            }
            case 2: {
                settings.setRotation(Rotation.CLOCKWISE_180);
                break;
            }
            case 3: {
                settings.setRotation(Rotation.COUNTERCLOCKWISE_90);
                break;
            }
            default: {
                settings.setRotation(Rotation.NONE);
            }
        }
        Settings.instance.setRotation(rotation);
        settings.setMirror(Settings.instance.getMirror());
        if (Settings.instance.getActiveStructure() != null) {
            Settings.instance.getActiveStructure().setPlacementSettings(settings);
        }
    }

    @Override
    public void onClosed() {
        if (Settings.instance.getActiveStructure() != null) {
            ByteBuf buffer = Unpooled.buffer();
            Settings.instance.toBytes(buffer);
            Structurize.getNetwork().sendToServer((IMessage)new LSStructureDisplayerMessage(buffer, true));
        }
    }
}

