/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui;

import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.blockout.controls.Button;
import com.minecolonies.blockout.controls.ButtonHandler;
import com.minecolonies.blockout.controls.ButtonImage;
import com.minecolonies.blockout.controls.ItemIcon;
import com.minecolonies.blockout.views.Window;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.network.messages.BuyCitizenMessage;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;

public class WindowTownHallHireCitizen
extends Window
implements ButtonHandler {
    private static final String BUTTON_DONE = "done";
    private static final String BUTTON_DIAMOND = "hirebottomright";
    private static final String BUTTON_EMERALD = "hirebottomleft";
    private static final String BUTTON_BOOKS = "hiretopright";
    private static final String BUTTON_HAY_BALE = "hiretopleft";
    private static final String BUTTON_DIAMOND_ICON = "hirebottomrighticon";
    private static final String BUTTON_EMERALD_ICON = "hirebottomlefticon";
    private static final String BUTTON_BOOKS_ICON = "hiretoprighticon";
    private static final String BUTTON_HAY_BALE_ICON = "hiretoplefticon";
    private static final String TOWNHALL_NAME_RESOURCE_SUFFIX = ":gui/townhall/windowtownhallhirecitizen.xml";
    private final IColonyView colony;

    public WindowTownHallHireCitizen(IColonyView c) {
        super("minecolonies:gui/townhall/windowtownhallhirecitizen.xml");
        this.colony = c;
    }

    @Override
    public void onOpened() {
        InvWrapper playerInv = new InvWrapper((IInventory)Minecraft.func_71410_x().field_71439_g.field_71071_by);
        int buyCitizenCost = this.colony.getBoughtCitizenCost() + 1;
        this.findPaneOfTypeByID(BUTTON_HAY_BALE_ICON, ItemIcon.class).setItem(Item.func_150898_a((Block)Blocks.field_150407_cf).func_190903_i());
        this.findPaneOfTypeByID(BUTTON_HAY_BALE, ButtonImage.class).setLabel(buyCitizenCost + "x");
        if (InventoryUtils.getItemCountInItemHandler((IItemHandler)playerInv, Item.func_150898_a((Block)Blocks.field_150407_cf), 0) < buyCitizenCost) {
            this.findPaneOfTypeByID(BUTTON_HAY_BALE, ButtonImage.class).disable();
        }
        this.findPaneOfTypeByID(BUTTON_BOOKS_ICON, ItemIcon.class).setItem(Items.field_151122_aG.func_190903_i());
        this.findPaneOfTypeByID(BUTTON_BOOKS, ButtonImage.class).setLabel(buyCitizenCost + "x");
        if (InventoryUtils.getItemCountInItemHandler((IItemHandler)playerInv, Items.field_151122_aG, 0) < buyCitizenCost) {
            this.findPaneOfTypeByID(BUTTON_BOOKS, ButtonImage.class).disable();
        }
        this.findPaneOfTypeByID(BUTTON_EMERALD_ICON, ItemIcon.class).setItem(Items.field_151166_bC.func_190903_i());
        this.findPaneOfTypeByID(BUTTON_EMERALD, ButtonImage.class).setLabel(buyCitizenCost + "x");
        if (InventoryUtils.getItemCountInItemHandler((IItemHandler)playerInv, Items.field_151166_bC, 0) < buyCitizenCost) {
            this.findPaneOfTypeByID(BUTTON_EMERALD, ButtonImage.class).disable();
        }
        this.findPaneOfTypeByID(BUTTON_DIAMOND_ICON, ItemIcon.class).setItem(Items.field_151045_i.func_190903_i());
        this.findPaneOfTypeByID(BUTTON_DIAMOND, ButtonImage.class).setLabel(buyCitizenCost + "x");
        if (InventoryUtils.getItemCountInItemHandler((IItemHandler)playerInv, Items.field_151045_i, 0) < buyCitizenCost) {
            this.findPaneOfTypeByID(BUTTON_DIAMOND, ButtonImage.class).disable();
        }
        if (this.colony.getCitizens().size() >= this.colony.getCitizenCountLimit()) {
            this.findPaneOfTypeByID(BUTTON_HAY_BALE, ButtonImage.class).disable();
            this.findPaneOfTypeByID(BUTTON_BOOKS, ButtonImage.class).disable();
            this.findPaneOfTypeByID(BUTTON_EMERALD, ButtonImage.class).disable();
            this.findPaneOfTypeByID(BUTTON_DIAMOND, ButtonImage.class).disable();
        }
    }

    @Override
    public void onButtonClicked(@NotNull Button button) {
        this.findPaneOfTypeByID(BUTTON_HAY_BALE, ButtonImage.class).disable();
        this.findPaneOfTypeByID(BUTTON_BOOKS, ButtonImage.class).disable();
        this.findPaneOfTypeByID(BUTTON_EMERALD, ButtonImage.class).disable();
        this.findPaneOfTypeByID(BUTTON_DIAMOND, ButtonImage.class).disable();
        switch (button.getID()) {
            case "done": {
                if (this.colony.getTownHall() == null) break;
                this.colony.getTownHall().openGui(false);
                break;
            }
            case "hiretopleft": {
                MineColonies.getNetwork().sendToServer((IMessage)new BuyCitizenMessage(BuyCitizenMessage.BuyCitizenType.HAY_BALE, this.colony.getID(), this.colony.getDimension()));
                break;
            }
            case "hiretopright": {
                MineColonies.getNetwork().sendToServer((IMessage)new BuyCitizenMessage(BuyCitizenMessage.BuyCitizenType.BOOK, this.colony.getID(), this.colony.getDimension()));
                break;
            }
            case "hirebottomleft": {
                MineColonies.getNetwork().sendToServer((IMessage)new BuyCitizenMessage(BuyCitizenMessage.BuyCitizenType.EMERALD, this.colony.getID(), this.colony.getDimension()));
                break;
            }
            case "hirebottomright": {
                MineColonies.getNetwork().sendToServer((IMessage)new BuyCitizenMessage(BuyCitizenMessage.BuyCitizenType.DIAMOND, this.colony.getID(), this.colony.getDimension()));
            }
        }
    }
}

