/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.ICitizenDataManager;
import com.minecolonies.api.colony.ICitizenDataView;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.colony.CitizenData;
import com.minecolonies.coremod.colony.CitizenDataView;
import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTTagCompound;
import org.jetbrains.annotations.NotNull;

public class CitizenDataManager
implements ICitizenDataManager {
    @Override
    public ICitizenData createFromNBT(@NotNull NBTTagCompound compound, IColony colony) {
        int id = compound.func_74762_e("id");
        CitizenData citizen = new CitizenData(id, colony);
        citizen.deserializeNBT(compound);
        return citizen;
    }

    @Override
    public ICitizenDataView createFromNetworkData(int id, @NotNull ByteBuf networkBuffer, IColonyView colonyView) {
        ICitizenDataView citizenDataView = colonyView.getCitizen(id) == null ? new CitizenDataView(id) : colonyView.getCitizen(id);
        try {
            citizenDataView.deserialize(networkBuffer);
        }
        catch (RuntimeException ex) {
            Log.getLogger().error(String.format("A CitizenData.View for #%d has thrown an exception during loading, its state cannot be restored. Report this to the mod author", citizenDataView.getId()), (Throwable)ex);
            citizenDataView = null;
        }
        return citizenDataView;
    }
}

