/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony;

import com.minecolonies.api.MinecoloniesAPIProxy;
import com.minecolonies.api.colony.ICitizenDataView;
import com.minecolonies.api.colony.interactionhandling.ChatPriority;
import com.minecolonies.api.colony.interactionhandling.IInteractionResponseHandler;
import com.minecolonies.api.inventory.InventoryCitizen;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.coremod.colony.interactionhandling.ServerCitizenInteractionResponseHandler;
import io.netty.buffer.ByteBuf;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CitizenDataView
implements ICitizenDataView {
    private static final String TAG_HELD_ITEM_SLOT = "HeldItemSlot";
    private final int id;
    private int entityId;
    private String name;
    private boolean female;
    private boolean paused;
    private boolean isChild;
    private int colonyId;
    private int level;
    private double experience;
    private double health;
    private double maxHealth;
    private int strength;
    private int endurance;
    private int charisma;
    private int intelligence;
    private int dexterity;
    private double saturation;
    private double happiness;
    private double foodModifier;
    private double damageModifier;
    private double houseModifier;
    private double jobModifier;
    private double fieldsModifier;
    private double toolsModifiers;
    private BlockPos position;
    private String job;
    @Nullable
    private BlockPos homeBuilding;
    @Nullable
    private BlockPos workBuilding;
    private InventoryCitizen inventory;
    private final Map<ITextComponent, IInteractionResponseHandler> citizenChatOptions = new HashMap<ITextComponent, IInteractionResponseHandler>();
    private boolean hasPrimaryBlockingInteractions;
    private boolean hasAnyPrimaryInteraction;
    private List<IInteractionResponseHandler> primaryInteractions;

    protected CitizenDataView(int id) {
        this.id = id;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public int getEntityId() {
        return this.entityId;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isFemale() {
        return this.female;
    }

    @Override
    public boolean isPaused() {
        return this.paused;
    }

    @Override
    public boolean isChild() {
        return this.isChild;
    }

    @Override
    public void setPaused(boolean p) {
        this.paused = p;
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    public double getExperience() {
        return this.experience;
    }

    @Override
    public String getJob() {
        return this.job;
    }

    @Override
    @Nullable
    public BlockPos getHomeBuilding() {
        return this.homeBuilding;
    }

    @Override
    @Nullable
    public BlockPos getWorkBuilding() {
        return this.workBuilding;
    }

    @Override
    @Nullable
    public void setWorkBuilding(BlockPos bp) {
        this.workBuilding = bp;
    }

    @Override
    public int getColonyId() {
        return this.colonyId;
    }

    @Override
    public int getStrength() {
        return this.strength;
    }

    @Override
    public int getEndurance() {
        return this.endurance;
    }

    @Override
    public int getCharisma() {
        return this.charisma;
    }

    @Override
    public double getHappiness() {
        return this.happiness;
    }

    @Override
    public double getSaturation() {
        return this.saturation;
    }

    @Override
    public int getIntelligence() {
        return this.intelligence;
    }

    @Override
    public int getDexterity() {
        return this.dexterity;
    }

    @Override
    public double getHealth() {
        return this.health;
    }

    @Override
    public double getMaxHealth() {
        return this.maxHealth;
    }

    @Override
    public BlockPos getPosition() {
        return this.position;
    }

    @Override
    public void deserialize(@NotNull ByteBuf buf) {
        this.name = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.female = buf.readBoolean();
        this.entityId = buf.readInt();
        this.paused = buf.readBoolean();
        this.isChild = buf.readBoolean();
        this.homeBuilding = buf.readBoolean() ? BlockPosUtil.readFromByteBuf(buf) : null;
        this.workBuilding = buf.readBoolean() ? BlockPosUtil.readFromByteBuf(buf) : null;
        this.level = buf.readInt();
        this.experience = buf.readDouble();
        this.health = buf.readFloat();
        this.maxHealth = buf.readFloat();
        this.strength = buf.readInt();
        this.endurance = buf.readInt();
        this.charisma = buf.readInt();
        this.intelligence = buf.readInt();
        this.dexterity = buf.readInt();
        this.saturation = buf.readDouble();
        this.happiness = buf.readDouble();
        this.foodModifier = buf.readDouble();
        this.damageModifier = buf.readDouble();
        this.houseModifier = buf.readDouble();
        this.jobModifier = buf.readDouble();
        this.fieldsModifier = buf.readDouble();
        this.toolsModifiers = buf.readDouble();
        this.job = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.colonyId = buf.readInt();
        NBTTagCompound compound = ByteBufUtils.readTag((ByteBuf)buf);
        this.inventory = new InventoryCitizen(this.name, true);
        NBTTagList nbttaglist = compound.func_150295_c("inventory", 10);
        this.inventory.readFromNBT(nbttaglist);
        this.inventory.setHeldItem(EnumHand.MAIN_HAND, compound.func_74762_e(TAG_HELD_ITEM_SLOT));
        this.inventory.setHeldItem(EnumHand.OFF_HAND, compound.func_74762_e("OffhandHeldItemSlot"));
        this.position = BlockPosUtil.readFromByteBuf(buf);
        this.citizenChatOptions.clear();
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            NBTTagCompound compoundNBT = ByteBufUtils.readTag((ByteBuf)buf);
            ServerCitizenInteractionResponseHandler handler = (ServerCitizenInteractionResponseHandler)MinecoloniesAPIProxy.getInstance().getInteractionResponseHandlerDataManager().createFrom(this, compoundNBT);
            this.citizenChatOptions.put(handler.getInquiry(), handler);
        }
        this.primaryInteractions = this.citizenChatOptions.values().stream().filter(IInteractionResponseHandler::isPrimary).sorted(Comparator.comparingInt(e -> e.getPriority().getPriority())).collect(Collectors.toList());
        if (!this.primaryInteractions.isEmpty()) {
            this.hasAnyPrimaryInteraction = true;
            this.hasPrimaryBlockingInteractions = this.primaryInteractions.get(0).getPriority().getPriority() >= ChatPriority.IMPORTANT.ordinal();
        } else {
            this.hasAnyPrimaryInteraction = false;
            this.hasPrimaryBlockingInteractions = false;
        }
    }

    @Override
    public InventoryCitizen getInventory() {
        return this.inventory;
    }

    @Override
    public double getFoodModifier() {
        return this.foodModifier;
    }

    @Override
    public double getDamageModifier() {
        return this.damageModifier;
    }

    @Override
    public double getHouseModifier() {
        return this.houseModifier;
    }

    @Override
    public double getJobModifier() {
        return this.jobModifier;
    }

    @Override
    public double getFieldsModifier() {
        return this.fieldsModifier;
    }

    @Override
    public double getToolsModifiers() {
        return this.toolsModifiers;
    }

    @Override
    public List<IInteractionResponseHandler> getOrderedInteractions() {
        return this.primaryInteractions;
    }

    @Override
    @Nullable
    public IInteractionResponseHandler getSpecificInteraction(@NotNull ITextComponent component) {
        return this.citizenChatOptions.getOrDefault(component, null);
    }

    @Override
    public boolean hasBlockingInteractions() {
        return this.hasPrimaryBlockingInteractions;
    }

    @Override
    public boolean hasPendingInteractions() {
        return this.hasAnyPrimaryInteraction;
    }
}

