/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony;

import com.google.common.collect.ArrayListMultimap;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.NBTUtils;
import com.minecolonies.coremod.colony.Colony;
import com.minecolonies.coremod.colony.ColonyList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import org.jetbrains.annotations.NotNull;

public interface IColonyManagerCapability {
    public IColony createColony(@NotNull World var1, @NotNull BlockPos var2);

    public void deleteColony(int var1);

    @Nullable
    public IColony getColony(int var1);

    public List<IColony> getColonies();

    public void addColony(IColony var1);

    public int getTopID();

    public static class Storage
    implements Capability.IStorage<IColonyManagerCapability> {
        public NBTBase writeNBT(@NotNull Capability<IColonyManagerCapability> capability, @NotNull IColonyManagerCapability instance, @Nullable EnumFacing side) {
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74782_a("colonies", (NBTBase)instance.getColonies().stream().map(IColony::getColonyTag).filter(Objects::nonNull).collect(NBTUtils.toNBTTagList()));
            return compound;
        }

        public void readNBT(@NotNull Capability<IColonyManagerCapability> capability, @NotNull IColonyManagerCapability instance, @Nullable EnumFacing side, @NotNull NBTBase nbt) {
            if (nbt instanceof NBTTagCompound) {
                NBTTagCompound compound = (NBTTagCompound)nbt;
                ArrayListMultimap tempColonies = ArrayListMultimap.create();
                for (NBTBase tag : compound.func_150295_c("colonies", 10)) {
                    Colony colony = Colony.loadColony((NBTTagCompound)tag, null);
                    if (colony == null) continue;
                    tempColonies.put((Object)colony.getCenter(), (Object)colony);
                    instance.addColony(colony);
                }
                for (BlockPos pos : tempColonies.keySet()) {
                    if (tempColonies.get((Object)pos).size() <= 1) continue;
                    Log.getLogger().warn("Detected duplicate colonies which are at the same position:");
                    for (IColony colony : tempColonies.get((Object)pos)) {
                        Log.getLogger().warn("ID: " + colony.getID() + " name:" + colony.getName() + " citizens:" + colony.getCitizenManager().getCitizens().size() + " building count:" + colony.getBuildingManager().getBuildings().size());
                    }
                    Log.getLogger().warn("Check and remove all except one of the duplicated colonies above!");
                }
            }
        }
    }

    public static class Impl
    implements IColonyManagerCapability {
        @NotNull
        private final ColonyList<IColony> colonies = new ColonyList();

        @Override
        public IColony createColony(@NotNull World w, @NotNull BlockPos pos) {
            return this.colonies.create(w, pos);
        }

        @Override
        public void deleteColony(int id) {
            this.colonies.remove(id);
        }

        @Override
        public IColony getColony(int id) {
            return this.colonies.get(id);
        }

        @Override
        public List<IColony> getColonies() {
            return this.colonies.getCopyAsList();
        }

        @Override
        public void addColony(IColony colony) {
            this.colonies.add(colony);
        }

        @Override
        public int getTopID() {
            return this.colonies.getTopID();
        }
    }
}

