/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.IBuildingWorker;
import com.minecolonies.api.colony.buildings.IGuardBuilding;
import com.minecolonies.api.colony.buildings.views.MobEntryView;
import com.minecolonies.api.colony.guardtype.GuardType;
import com.minecolonies.api.colony.guardtype.registry.IGuardTypeDataManager;
import com.minecolonies.api.colony.guardtype.registry.IGuardTypeRegistry;
import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.api.configuration.Configurations;
import com.minecolonies.api.entity.ai.citizen.guards.GuardTask;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.constant.Constants;
import com.minecolonies.api.util.constant.ToolType;
import com.minecolonies.blockout.Log;
import com.minecolonies.blockout.views.Window;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.achievements.ModAchievements;
import com.minecolonies.coremod.client.gui.WindowHutGuardTower;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.network.messages.GuardMobAttackListMessage;
import com.minecolonies.coremod.util.AttributeModifierUtils;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractBuildingGuards
extends AbstractBuildingWorker
implements IGuardBuilding {
    private static final String NBT_TASK = "TASK";
    private static final String NBT_JOB = "guardType";
    private static final String NBT_ASSIGN = "assign";
    private static final String NBT_RETRIEVE = "retrieve";
    private static final String NBT_PATROL = "patrol";
    private static final String NBT_TIGHT_GROUPING = "tightGrouping";
    private static final String NBT_PATROL_TARGETS = "patrol targets";
    private static final String NBT_TARGET = "target";
    private static final String NBT_GUARD = "guard";
    private static final String NBT_MOBS = "mobs";
    private static final String NBT_MOB_VIEW = "mobview";
    private static final int BONUS_HEALTH_PER_LEVEL = 2;
    private static final int VISION_RANGE_PER_LEVEL = 5;
    private boolean assignManually = false;
    private boolean retrieveOnLowHealth = true;
    private static final int ACHIEVEMENT_LEVEL = 1;
    private boolean patrolManually = false;
    private GuardTask task = GuardTask.GUARD;
    private BlockPos guardPos = this.getID();
    private GuardType job = null;
    private List<BlockPos> patrolTargets = new ArrayList<BlockPos>();
    private Map<Class<? extends Entity>, MobEntryView> mobsToAttack = new HashMap<Class<? extends Entity>, MobEntryView>();
    private EntityPlayer followPlayer;
    private boolean tightGrouping;

    public AbstractBuildingGuards(@NotNull IColony c, BlockPos l) {
        super(c, l);
        this.keepX.put(itemStack -> ItemStackUtils.hasToolLevel(itemStack, ToolType.BOW, 0, this.getMaxToolLevel()), new Tuple((Object)1, (Object)true));
        this.keepX.put(itemStack -> ItemStackUtils.isEmpty(itemStack) == false && ItemStackUtils.doesItemServeAsWeapon(itemStack), new Tuple((Object)1, (Object)true));
        this.keepX.put(itemStack -> ItemStackUtils.isEmpty(itemStack) == false && itemStack.func_77973_b() instanceof ItemArmor && ((ItemArmor)itemStack.func_77973_b()).field_77881_a == EntityEquipmentSlot.CHEST, new Tuple((Object)1, (Object)true));
        this.keepX.put(itemStack -> ItemStackUtils.isEmpty(itemStack) == false && itemStack.func_77973_b() instanceof ItemArmor && ((ItemArmor)itemStack.func_77973_b()).field_77881_a == EntityEquipmentSlot.HEAD, new Tuple((Object)1, (Object)true));
        this.keepX.put(itemStack -> ItemStackUtils.isEmpty(itemStack) == false && itemStack.func_77973_b() instanceof ItemArmor && ((ItemArmor)itemStack.func_77973_b()).field_77881_a == EntityEquipmentSlot.LEGS, new Tuple((Object)1, (Object)true));
        this.keepX.put(itemStack -> ItemStackUtils.isEmpty(itemStack) == false && itemStack.func_77973_b() instanceof ItemArmor && ((ItemArmor)itemStack.func_77973_b()).field_77881_a == EntityEquipmentSlot.FEET, new Tuple((Object)1, (Object)true));
    }

    @Override
    public void onUpgradeComplete(int newLevel) {
        this.getGuardType();
        if (this.getAssignedEntities() != null) {
            for (Optional<AbstractEntityCitizen> optCitizen : this.getAssignedEntities()) {
                if (!optCitizen.isPresent()) continue;
                AttributeModifier healthModBuildingHP = new AttributeModifier("MinecoloniesGuardBuildingHP", (double)this.getBonusHealth(), 0);
                AttributeModifierUtils.addHealthModifier((EntityLivingBase)optCitizen.get(), healthModBuildingHP);
            }
        }
        super.onUpgradeComplete(newLevel);
        if (newLevel == 1) {
            this.getColony().getStatsManager().triggerAchievement(ModAchievements.achievementBuildingGuard);
        }
        if (newLevel >= this.getMaxBuildingLevel()) {
            this.getColony().getStatsManager().triggerAchievement(ModAchievements.achievementUpgradeGuardMax);
        }
    }

    @Override
    public boolean assignCitizen(ICitizenData citizen) {
        if (super.assignCitizen(citizen) && citizen != null) {
            IBuilding building;
            Optional<AbstractEntityCitizen> optCitizen = citizen.getCitizenEntity();
            if (optCitizen.isPresent()) {
                AbstractEntityCitizen citizenEntity = optCitizen.get();
                AttributeModifier healthModBuildingHP = new AttributeModifier("MinecoloniesGuardBuildingHP", (double)this.getBonusHealth(), 0);
                AttributeModifierUtils.addHealthModifier((EntityLivingBase)citizenEntity, healthModBuildingHP);
                AttributeModifier healthModConfig = new AttributeModifier("MinecoloniesGuardConfigHP", Configurations.gameplay.guardHealthMult - 1.0, 1);
                AttributeModifierUtils.addHealthModifier((EntityLivingBase)citizenEntity, healthModConfig);
            }
            if ((building = citizen.getHomeBuilding()) != null && !building.getID().equals((Object)this.getID())) {
                building.removeCitizen(citizen);
            }
            citizen.setHomeBuilding(this);
            return true;
        }
        return false;
    }

    @Override
    public void deserializeNBT(NBTTagCompound compound) {
        super.deserializeNBT(compound);
        this.task = GuardTask.values()[compound.func_74762_e(NBT_TASK)];
        ResourceLocation jobName = new ResourceLocation(compound.func_74779_i(NBT_JOB));
        this.job = IGuardTypeDataManager.getInstance().getFrom(jobName);
        this.assignManually = compound.func_74767_n(NBT_ASSIGN);
        this.retrieveOnLowHealth = compound.func_74767_n(NBT_RETRIEVE);
        this.patrolManually = compound.func_74767_n(NBT_PATROL);
        this.tightGrouping = compound.func_74764_b(NBT_TIGHT_GROUPING) ? compound.func_74767_n(NBT_TIGHT_GROUPING) : true;
        NBTTagList wayPointTagList = compound.func_150295_c(NBT_PATROL_TARGETS, 10);
        for (int i = 0; i < wayPointTagList.func_74745_c(); ++i) {
            NBTTagCompound blockAtPos = wayPointTagList.func_150305_b(i);
            BlockPos pos = BlockPosUtil.readFromNBT(blockAtPos, NBT_TARGET);
            this.patrolTargets.add(pos);
        }
        NBTTagList mobsTagList = compound.func_150295_c(NBT_MOBS, 10);
        for (int i = 0; i < mobsTagList.func_74745_c(); ++i) {
            NBTTagCompound mobCompound = mobsTagList.func_150305_b(i);
            MobEntryView mobEntry = MobEntryView.readFromNBT(mobCompound, NBT_MOB_VIEW);
            if (mobEntry.getEntityEntry() == null) continue;
            this.mobsToAttack.put(mobEntry.getEntityEntry().getEntityClass(), mobEntry);
        }
        this.guardPos = NBTUtil.func_186861_c((NBTTagCompound)compound.func_74775_l(NBT_GUARD));
    }

    @Override
    public NBTTagCompound serializeNBT() {
        NBTTagCompound compound = super.serializeNBT();
        compound.func_74768_a(NBT_TASK, this.task.ordinal());
        compound.func_74778_a(NBT_JOB, this.job == null ? "" : this.job.getRegistryName().toString());
        compound.func_74757_a(NBT_ASSIGN, this.assignManually);
        compound.func_74757_a(NBT_RETRIEVE, this.retrieveOnLowHealth);
        compound.func_74757_a(NBT_PATROL, this.patrolManually);
        compound.func_74757_a(NBT_TIGHT_GROUPING, this.tightGrouping);
        NBTTagList wayPointTagList = new NBTTagList();
        for (BlockPos pos : this.patrolTargets) {
            NBTTagCompound wayPointCompound = new NBTTagCompound();
            BlockPosUtil.writeToNBT(wayPointCompound, NBT_TARGET, pos);
            wayPointTagList.func_74742_a((NBTBase)wayPointCompound);
        }
        compound.func_74782_a(NBT_PATROL_TARGETS, (NBTBase)wayPointTagList);
        NBTTagList mobsTagList = new NBTTagList();
        for (MobEntryView entry : this.mobsToAttack.values()) {
            NBTTagCompound mobCompound = new NBTTagCompound();
            MobEntryView.writeToNBT(mobCompound, NBT_MOB_VIEW, entry);
            mobsTagList.func_74742_a((NBTBase)mobCompound);
        }
        compound.func_74782_a(NBT_MOBS, (NBTBase)mobsTagList);
        compound.func_74782_a(NBT_GUARD, (NBTBase)NBTUtil.func_186859_a((BlockPos)this.guardPos));
        return compound;
    }

    @Override
    public void removeCitizen(ICitizenData citizen) {
        Optional<AbstractEntityCitizen> optCitizen;
        if (citizen != null && (optCitizen = citizen.getCitizenEntity()).isPresent()) {
            AttributeModifierUtils.removeAllHealthModifiers((EntityLivingBase)optCitizen.get());
            optCitizen.get().func_184201_a(EntityEquipmentSlot.CHEST, ItemStackUtils.EMPTY);
            optCitizen.get().func_184201_a(EntityEquipmentSlot.FEET, ItemStackUtils.EMPTY);
            optCitizen.get().func_184201_a(EntityEquipmentSlot.HEAD, ItemStackUtils.EMPTY);
            optCitizen.get().func_184201_a(EntityEquipmentSlot.LEGS, ItemStackUtils.EMPTY);
            optCitizen.get().func_184201_a(EntityEquipmentSlot.MAINHAND, ItemStackUtils.EMPTY);
            optCitizen.get().func_184201_a(EntityEquipmentSlot.OFFHAND, ItemStackUtils.EMPTY);
        }
        super.removeCitizen(citizen);
    }

    @Override
    public void serializeToView(@NotNull ByteBuf buf) {
        super.serializeToView(buf);
        buf.writeBoolean(this.assignManually);
        buf.writeBoolean(this.retrieveOnLowHealth);
        buf.writeBoolean(this.patrolManually);
        buf.writeBoolean(this.tightGrouping);
        buf.writeInt(this.task.ordinal());
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)(this.job == null ? "" : this.job.getRegistryName().toString()));
        buf.writeInt(this.patrolTargets.size());
        for (BlockPos pos : this.patrolTargets) {
            BlockPosUtil.writeToByteBuf(buf, pos);
        }
        if (this.mobsToAttack.isEmpty()) {
            this.calculateMobs();
        }
        buf.writeInt(this.mobsToAttack.size());
        for (MobEntryView entry : this.mobsToAttack.values()) {
            MobEntryView.writeToByteBuf(buf, entry);
        }
        BlockPosUtil.writeToByteBuf(buf, this.guardPos);
        buf.writeInt(this.getAssignedCitizen().size());
        for (ICitizenData citizen : this.getAssignedCitizen()) {
            buf.writeInt(citizen.getId());
        }
    }

    @Override
    public GuardTask getTask() {
        return this.task;
    }

    @Override
    public void setTask(GuardTask task) {
        this.task = task;
        this.markDirty();
    }

    @Override
    public EntityPlayer getFollowPlayer() {
        return this.followPlayer;
    }

    @Override
    @Nullable
    public BlockPos getNextPatrolTarget(BlockPos currentPatrolTarget) {
        if (!this.patrolManually) {
            if (currentPatrolTarget == null) {
                return this.getPosition();
            }
            BlockPos pos = BlockPosUtil.getRandomPosition(this.getColony().getWorld(), currentPatrolTarget, this.getPosition());
            if (BlockPosUtil.getDistance2D(pos, this.getPosition()) > (long)this.getPatrolDistance()) {
                return this.getPosition();
            }
            return pos;
        }
        if (this.patrolTargets == null || this.patrolTargets.isEmpty()) {
            return null;
        }
        if (currentPatrolTarget == null) {
            return this.patrolTargets.get(0);
        }
        if (this.patrolTargets.contains(currentPatrolTarget)) {
            int index = this.patrolTargets.indexOf(currentPatrolTarget) + 1;
            if (index >= this.patrolTargets.size()) {
                index = 0;
            }
            return this.patrolTargets.get(index);
        }
        return this.patrolTargets.get(0);
    }

    @Override
    public int getPatrolDistance() {
        return this.getBuildingLevel() * 40;
    }

    @Override
    public GuardType getGuardType() {
        if (this.job == null) {
            ArrayList guardTypes = new ArrayList(IGuardTypeRegistry.getInstance().getValuesCollection());
            this.job = (GuardType)((Object)guardTypes.get(new Random().nextInt(guardTypes.size())));
        }
        return this.job;
    }

    @Override
    public void setGuardType(GuardType job) {
        this.job = job;
        for (ICitizenData citizen : this.getAssignedCitizen()) {
            this.cancelAllRequestsOfCitizen(citizen);
            citizen.setJob(this.createJob(citizen));
        }
        this.markDirty();
    }

    @Override
    @NotNull
    public IJob createJob(ICitizenData citizen) {
        return this.getGuardType().getGuardJobProducer().apply(citizen);
    }

    @Override
    @NotNull
    public String getJobName() {
        return this.getGuardType().getJobTranslationKey();
    }

    @Override
    public List<BlockPos> getPatrolTargets() {
        return new ArrayList<BlockPos>(this.patrolTargets);
    }

    @Override
    public boolean shallRetrieveOnLowHealth() {
        return this.retrieveOnLowHealth;
    }

    @Override
    public void setRetrieveOnLowHealth(boolean retrieve) {
        this.retrieveOnLowHealth = retrieve;
    }

    @Override
    public boolean shallPatrolManually() {
        return this.patrolManually;
    }

    @Override
    public void setPatrolManually(boolean patrolManually) {
        this.patrolManually = patrolManually;
    }

    @Override
    public boolean shallAssignManually() {
        return this.assignManually;
    }

    @Override
    public void setAssignManually(boolean assignManually) {
        this.assignManually = assignManually;
    }

    @Override
    public boolean isTightGrouping() {
        return this.tightGrouping;
    }

    @Override
    public void setTightGrouping(boolean tightGrouping) {
        this.tightGrouping = tightGrouping;
    }

    @Override
    public BlockPos getGuardPos() {
        return this.guardPos;
    }

    @Override
    public void setGuardPos(BlockPos guardPos) {
        this.guardPos = guardPos;
    }

    @Override
    public Map<Class<? extends Entity>, MobEntryView> getMobsToAttack() {
        return this.mobsToAttack;
    }

    @Override
    public void setMobsToAttack(List<MobEntryView> list) {
        this.mobsToAttack = new HashMap<Class<? extends Entity>, MobEntryView>();
        for (MobEntryView entry : list) {
            this.mobsToAttack.put(entry.getEntityEntry().getEntityClass(), entry);
        }
    }

    @Override
    public BlockPos getPlayerToFollow() {
        if (this.task.equals((Object)GuardTask.FOLLOW) && this.followPlayer != null) {
            return this.followPlayer.func_180425_c();
        }
        this.task = GuardTask.GUARD;
        this.markDirty();
        return this.getPosition();
    }

    @Override
    public void setPlayerToFollow(EntityPlayer player) {
        if (this.getColony().getWorld() != null) {
            this.getColony().getWorld().func_96441_U().func_151392_a(player.func_70005_c_(), "teamcolony" + this.getColony().getID());
            player.func_70690_d(new PotionEffect(Constants.GLOW_EFFECT, 12000, 20));
            if (this.followPlayer != null) {
                try {
                    this.getColony().getWorld().func_96441_U().func_96512_b(this.followPlayer.func_70005_c_(), this.getColony().getWorld().func_96441_U().func_96508_e("teamcolony" + this.getColony().getID()));
                    player.func_184589_d(Constants.GLOW_EFFECT);
                }
                catch (Exception e) {
                    Log.getLogger().warn("Unable to remove player " + this.followPlayer.func_70005_c_() + " from team " + "teamcolony" + this.getColony().getID());
                }
            }
        }
        this.followPlayer = player;
    }

    private int getBonusHealth() {
        return this.getBuildingLevel() * 2;
    }

    @Override
    public void addPatrolTargets(BlockPos target) {
        this.patrolTargets.add(target);
        this.markDirty();
    }

    @Override
    public void resetPatrolTargets() {
        this.patrolTargets = new ArrayList<BlockPos>();
        this.markDirty();
    }

    @Override
    public int getBonusVision() {
        return this.getBuildingLevel() * 5;
    }

    @Override
    public void calculateMobs() {
        this.mobsToAttack = new HashMap<Class<? extends Entity>, MobEntryView>();
        int i = 0;
        for (EntityEntry entry : ForgeRegistries.ENTITIES.getValuesCollection()) {
            if (EntityMob.class.isAssignableFrom(entry.getEntityClass())) {
                this.mobsToAttack.put(entry.getEntityClass(), new MobEntryView(entry.getRegistryName(), true, ++i));
                continue;
            }
            for (String location : Configurations.gameplay.guardResourceLocations) {
                if (entry.getRegistryName() == null || !entry.getRegistryName().toString().equals(location)) continue;
                this.mobsToAttack.put(entry.getEntityClass(), new MobEntryView(entry.getRegistryName(), true, ++i));
            }
        }
        this.getColony().getPackageManager().getCloseSubscribers().forEach(player -> MineColonies.getNetwork().sendTo((IMessage)new GuardMobAttackListMessage(this.getColony().getID(), this.getID(), new ArrayList<MobEntryView>(this.mobsToAttack.values())), player));
    }

    @Override
    public boolean canWorkDuringTheRain() {
        return true;
    }

    public static class View
    extends AbstractBuildingWorker.View {
        private boolean assignManually = false;
        private boolean retrieveOnLowHealth = false;
        private boolean patrolManually = false;
        private GuardTask task = GuardTask.GUARD;
        private BlockPos guardPos = this.getID();
        private GuardType guardType = null;
        private boolean tightGrouping = true;
        private List<BlockPos> patrolTargets = new ArrayList<BlockPos>();
        private List<MobEntryView> mobsToAttack = new ArrayList<MobEntryView>();
        @NotNull
        private final List<Integer> guards = new ArrayList<Integer>();

        public View(IColonyView c, @NotNull BlockPos l) {
            super(c, l);
        }

        @Override
        @NotNull
        public Window getWindow() {
            return new WindowHutGuardTower(this);
        }

        @NotNull
        public List<Integer> getGuards() {
            return Collections.unmodifiableList(this.guards);
        }

        @Override
        public void deserialize(@NotNull ByteBuf buf) {
            super.deserialize(buf);
            this.assignManually = buf.readBoolean();
            this.retrieveOnLowHealth = buf.readBoolean();
            this.patrolManually = buf.readBoolean();
            this.tightGrouping = buf.readBoolean();
            this.task = GuardTask.values()[buf.readInt()];
            ResourceLocation jobId = new ResourceLocation(ByteBufUtils.readUTF8String((ByteBuf)buf));
            this.guardType = (GuardType)IGuardTypeRegistry.getInstance().getValue(jobId);
            int targetSize = buf.readInt();
            this.patrolTargets = new ArrayList<BlockPos>();
            for (int i = 0; i < targetSize; ++i) {
                this.patrolTargets.add(BlockPosUtil.readFromByteBuf(buf));
            }
            int mobSize = buf.readInt();
            for (int i = 0; i < mobSize; ++i) {
                MobEntryView mobEntry = MobEntryView.readFromByteBuf(buf);
                this.mobsToAttack.add(mobEntry);
            }
            this.guardPos = BlockPosUtil.readFromByteBuf(buf);
            int numResidents = buf.readInt();
            for (int i = 0; i < numResidents; ++i) {
                this.guards.add(buf.readInt());
            }
        }

        @Override
        @NotNull
        public IBuildingWorker.Skill getPrimarySkill() {
            return this.getGuardType().getPrimarySkill();
        }

        @Override
        @NotNull
        public IBuildingWorker.Skill getSecondarySkill() {
            return this.getGuardType().getSecondarySkill();
        }

        public void setAssignManually(boolean assignManually) {
            this.assignManually = assignManually;
        }

        public boolean isAssignManually() {
            return this.assignManually;
        }

        public void setRetrieveOnLowHealth(boolean retrieveOnLowHealth) {
            this.retrieveOnLowHealth = retrieveOnLowHealth;
        }

        public boolean isRetrieveOnLowHealth() {
            return this.retrieveOnLowHealth;
        }

        public void setTightGrouping(boolean tightGrouping) {
            this.tightGrouping = tightGrouping;
        }

        public boolean isTightGrouping() {
            return this.tightGrouping;
        }

        public void setPatrolManually(boolean patrolManually) {
            this.patrolManually = patrolManually;
        }

        public void setMobsToAttack(List<MobEntryView> mobsToAttack) {
            this.mobsToAttack = new ArrayList<MobEntryView>(mobsToAttack);
        }

        public boolean isPatrolManually() {
            return this.patrolManually;
        }

        public void setTask(GuardTask task) {
            this.task = task;
            this.getColony().markDirty();
        }

        public GuardTask getTask() {
            return this.task;
        }

        public BlockPos getGuardPos() {
            return this.guardPos;
        }

        public GuardType getGuardType() {
            return this.guardType;
        }

        public void setGuardType(GuardType job) {
            this.guardType = job;
        }

        public List<BlockPos> getPatrolTargets() {
            return new ArrayList<BlockPos>(this.patrolTargets);
        }

        public List<MobEntryView> getMobsToAttack() {
            return new ArrayList<MobEntryView>(this.mobsToAttack);
        }
    }
}

