/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.workerbuildings;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.IBuildingWorker;
import com.minecolonies.api.colony.buildings.ModBuildings;
import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.blockout.views.Window;
import com.minecolonies.coremod.client.gui.WindowHutCook;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingFurnaceUser;
import com.minecolonies.coremod.colony.buildings.views.AbstractFilterableListsView;
import com.minecolonies.coremod.colony.jobs.JobCook;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import org.jetbrains.annotations.NotNull;

public class BuildingCook
extends AbstractBuildingFurnaceUser {
    private static final String COOK_DESC = "Cook";
    private static final int MAX_BUILDING_LEVEL = 5;

    public BuildingCook(IColony c, BlockPos l) {
        super(c, l);
        this.keepX.put(ItemStackUtils.ISFOOD, new Tuple((Object)64, (Object)true));
        this.keepX.put(ItemStackUtils.ISCOOKABLE, new Tuple((Object)64, (Object)true));
        this.keepX.put(TileEntityFurnace::func_145954_b, new Tuple((Object)64, (Object)true));
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return COOK_DESC;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    @NotNull
    public IJob createJob(ICitizenData citizen) {
        return new JobCook(citizen);
    }

    @Override
    @NotNull
    public String getJobName() {
        return COOK_DESC;
    }

    @Override
    public boolean canCraftComplexRecipes() {
        return true;
    }

    @Override
    public boolean canWorkDuringTheRain() {
        return true;
    }

    @Override
    public int buildingRequiresCertainAmountOfItem(ItemStack stack, List<ItemStorage> localAlreadyKept, boolean inventory) {
        if (stack.func_190926_b()) {
            return 0;
        }
        if (ItemStackUtils.ISFOOD.test(stack) && localAlreadyKept.stream().filter(storage -> ItemStackUtils.ISFOOD.test(storage.getItemStack())).mapToInt(ItemStorage::getAmount).sum() < 64 || !inventory) {
            ItemStorage kept = new ItemStorage(stack);
            if (localAlreadyKept.contains(kept)) {
                kept.setAmount(localAlreadyKept.remove(localAlreadyKept.indexOf(kept)).getAmount());
            }
            localAlreadyKept.add(kept);
            return 0;
        }
        Predicate<ItemStack> allowedFuel = theStack -> this.getAllowedFuel().stream().anyMatch(fuelStack -> fuelStack.func_77969_a(theStack));
        if (allowedFuel.test(stack) && localAlreadyKept.stream().filter(storage -> allowedFuel.test(storage.getItemStack())).mapToInt(ItemStorage::getAmount).sum() < 64 || !inventory) {
            ItemStorage kept = new ItemStorage(stack);
            if (localAlreadyKept.contains(kept)) {
                kept.setAmount(localAlreadyKept.remove(localAlreadyKept.indexOf(kept)).getAmount());
            }
            localAlreadyKept.add(kept);
            return 0;
        }
        return super.buildingRequiresCertainAmountOfItem(stack, localAlreadyKept, inventory);
    }

    @Override
    public BuildingEntry getBuildingRegistryEntry() {
        return ModBuildings.cook;
    }

    public static class View
    extends AbstractFilterableListsView {
        public View(IColonyView c, BlockPos l) {
            super(c, l);
        }

        @Override
        @NotNull
        public Window getWindow() {
            return new WindowHutCook(this);
        }

        @Override
        @NotNull
        public IBuildingWorker.Skill getPrimarySkill() {
            return IBuildingWorker.Skill.CHARISMA;
        }

        @Override
        @NotNull
        public IBuildingWorker.Skill getSecondarySkill() {
            return IBuildingWorker.Skill.INTELLIGENCE;
        }
    }
}

