/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.workerbuildings;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.IBuildingWorker;
import com.minecolonies.api.colony.buildings.ModBuildings;
import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.api.colony.buildings.workerbuildings.IBuildingDeliveryman;
import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.api.colony.requestsystem.location.ILocation;
import com.minecolonies.api.colony.requestsystem.resolver.IRequestResolver;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.util.constant.TypeConstants;
import com.minecolonies.blockout.views.Window;
import com.minecolonies.coremod.client.gui.WindowHutWorkerPlaceholder;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.colony.jobs.JobDeliveryman;
import com.minecolonies.coremod.colony.requestsystem.resolvers.DeliveryRequestResolver;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.util.math.BlockPos;
import org.jetbrains.annotations.NotNull;

public class BuildingDeliveryman
extends AbstractBuildingWorker
implements IBuildingDeliveryman {
    private static final String DELIVERYMAN = "Deliveryman";
    private ILocation buildingToDeliver;

    public BuildingDeliveryman(IColony c, BlockPos l) {
        super(c, l);
    }

    @Override
    public ILocation getBuildingToDeliver() {
        return this.buildingToDeliver;
    }

    @Override
    public void setBuildingToDeliver(ILocation building) {
        this.buildingToDeliver = building;
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return DELIVERYMAN;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    public ImmutableCollection<IRequestResolver<?>> createResolvers() {
        ImmutableCollection<IRequestResolver<?>> supers = super.createResolvers();
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.addAll(supers);
        builder.add((Object)new DeliveryRequestResolver(this.getRequester().getLocation(), this.getColony().getRequestManager().getFactoryController().getNewInstance(TypeConstants.ITOKEN)));
        return builder.build();
    }

    @Override
    public BuildingEntry getBuildingRegistryEntry() {
        return ModBuildings.deliveryman;
    }

    @Override
    @NotNull
    public IJob createJob(ICitizenData citizen) {
        return new JobDeliveryman(citizen);
    }

    @Override
    @NotNull
    public String getJobName() {
        return DELIVERYMAN;
    }

    @Override
    public void serializeToView(@NotNull ByteBuf buf) {
        super.serializeToView(buf);
    }

    @Override
    public void removeCitizen(ICitizenData citizen) {
        if (citizen != null) {
            Optional<AbstractEntityCitizen> optCitizen = citizen.getCitizenEntity();
            optCitizen.ifPresent(entityCitizen -> entityCitizen.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3));
        }
        super.removeCitizen(citizen);
    }

    public static class View
    extends AbstractBuildingWorker.View {
        public View(IColonyView c, BlockPos l) {
            super(c, l);
        }

        @Override
        @NotNull
        public Window getWindow() {
            return new WindowHutWorkerPlaceholder<View>(this, BuildingDeliveryman.DELIVERYMAN);
        }

        @Override
        public void deserialize(@NotNull ByteBuf buf) {
            super.deserialize(buf);
        }

        @Override
        @NotNull
        public IBuildingWorker.Skill getPrimarySkill() {
            return IBuildingWorker.Skill.INTELLIGENCE;
        }

        @Override
        @NotNull
        public IBuildingWorker.Skill getSecondarySkill() {
            return IBuildingWorker.Skill.ENDURANCE;
        }
    }
}

