/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.workerbuildings;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.IBuildingWorker;
import com.minecolonies.api.colony.buildings.ModBuildings;
import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.api.items.ModItems;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.NBTUtils;
import com.minecolonies.blockout.views.Window;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.client.gui.WindowHutEnchanter;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.colony.jobs.JobEnchanter;
import com.minecolonies.coremod.network.messages.EnchanterWorkerSetMessage;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildingEnchanter
extends AbstractBuildingWorker {
    private static final String ENCHANTER = "Enchanter";
    private static final int MAX_BUILDING_LEVEL = 5;
    private Map<BlockPos, Boolean> buildingToGatherFrom = new HashMap<BlockPos, Boolean>();
    private int dailyDrain = 1;
    private Random random = new Random();

    public BuildingEnchanter(@NotNull IColony c, BlockPos l) {
        super(c, l);
        this.keepX.put(stack -> stack.func_77973_b() == ModItems.ancientTome, new Tuple((Object)64, (Object)true));
    }

    @Override
    @NotNull
    public IJob createJob(ICitizenData citizen) {
        return new JobEnchanter(citizen);
    }

    @Override
    @NotNull
    public String getJobName() {
        return ENCHANTER;
    }

    @Override
    public String getSchematicName() {
        return ENCHANTER;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    public BuildingEntry getBuildingRegistryEntry() {
        return ModBuildings.enchanter;
    }

    public void addWorker(BlockPos blockPos) {
        this.buildingToGatherFrom.put(blockPos, false);
        this.markDirty();
    }

    public void removeWorker(BlockPos blockPos) {
        this.buildingToGatherFrom.remove(blockPos);
        this.markDirty();
    }

    public void setDailyDrainage(int qty) {
        this.dailyDrain = qty;
        this.markDirty();
    }

    public int getDailyDrain() {
        return this.dailyDrain;
    }

    @Override
    public void onWakeUp() {
        HashSet<BlockPos> keys = new HashSet<BlockPos>(this.buildingToGatherFrom.keySet());
        this.buildingToGatherFrom.clear();
        keys.forEach(k -> this.buildingToGatherFrom.put((BlockPos)k, false));
    }

    @Override
    public void deserializeNBT(NBTTagCompound compound) {
        super.deserializeNBT(compound);
        this.buildingToGatherFrom.clear();
        NBTUtils.streamCompound(compound.func_150295_c("buildingstogather", 10)).map(this::deserializeListElement).forEach(t -> this.buildingToGatherFrom.put((BlockPos)t.func_76341_a(), (Boolean)t.func_76340_b()));
        this.dailyDrain = compound.func_74762_e("quantity");
    }

    private Tuple<BlockPos, Boolean> deserializeListElement(NBTTagCompound nbtTagCompound) {
        BlockPos pos = BlockPosUtil.readFromNBT(nbtTagCompound, "pos");
        boolean gatheredAlready = nbtTagCompound.func_74767_n("gatheredalready");
        return new Tuple((Object)pos, (Object)gatheredAlready);
    }

    @Override
    public NBTTagCompound serializeNBT() {
        NBTTagCompound compound = super.serializeNBT();
        compound.func_74782_a("buildingstogather", (NBTBase)this.buildingToGatherFrom.entrySet().stream().map(this::serializeListElement).collect(NBTUtils.toNBTTagList()));
        compound.func_74768_a("quantity", this.dailyDrain);
        return compound;
    }

    private NBTTagCompound serializeListElement(Map.Entry<BlockPos, Boolean> entry) {
        NBTTagCompound compound = new NBTTagCompound();
        BlockPosUtil.writeToNBT(compound, "pos", entry.getKey());
        compound.func_74757_a("gatheredalready", entry.getValue().booleanValue());
        return compound;
    }

    @Override
    public void serializeToView(@NotNull ByteBuf buf) {
        super.serializeToView(buf);
        buf.writeInt(this.buildingToGatherFrom.size());
        for (BlockPos pos : this.buildingToGatherFrom.keySet()) {
            BlockPosUtil.writeToByteBuf(buf, pos);
        }
        buf.writeInt(this.dailyDrain);
    }

    public Set<BlockPos> getBuildingsToGatherFrom() {
        return new HashSet<BlockPos>(this.buildingToGatherFrom.keySet());
    }

    @Nullable
    public BlockPos getRandomBuildingToDrainFrom() {
        List buildings = this.buildingToGatherFrom.entrySet().stream().filter(k -> (Boolean)k.getValue() == false).map(Map.Entry::getKey).collect(Collectors.toList());
        if (buildings.isEmpty()) {
            return null;
        }
        return (BlockPos)buildings.get(this.random.nextInt(buildings.size()));
    }

    public void setAsGathered(BlockPos pos) {
        this.buildingToGatherFrom.put(pos, true);
    }

    public static class View
    extends AbstractBuildingWorker.View {
        private List<BlockPos> buildingToGatherFrom = new ArrayList<BlockPos>();
        private int qty = 1;

        public View(IColonyView c, BlockPos l) {
            super(c, l);
        }

        @Override
        @NotNull
        public Window getWindow() {
            return new WindowHutEnchanter(this);
        }

        @Override
        public void deserialize(@NotNull ByteBuf buf) {
            super.deserialize(buf);
            int size = buf.readInt();
            for (int i = 0; i < size; ++i) {
                this.buildingToGatherFrom.add(BlockPosUtil.readFromByteBuf(buf));
            }
            this.qty = buf.readInt();
        }

        public List<BlockPos> getBuildingsToGatherFrom() {
            return new ArrayList<BlockPos>(this.buildingToGatherFrom);
        }

        public int getDailyDrain() {
            return this.qty;
        }

        @Override
        @NotNull
        public IBuildingWorker.Skill getPrimarySkill() {
            return IBuildingWorker.Skill.INTELLIGENCE;
        }

        @Override
        @NotNull
        public IBuildingWorker.Skill getSecondarySkill() {
            return IBuildingWorker.Skill.CHARISMA;
        }

        public void addWorker(BlockPos blockPos) {
            this.buildingToGatherFrom.add(blockPos);
            MineColonies.getNetwork().sendToServer((IMessage)new EnchanterWorkerSetMessage(this, blockPos, true));
        }

        public void removeWorker(BlockPos blockPos) {
            this.buildingToGatherFrom.remove(blockPos);
            MineColonies.getNetwork().sendToServer((IMessage)new EnchanterWorkerSetMessage(this, blockPos, false));
        }

        public void setQuantity(int qty) {
            this.qty = qty;
        }
    }
}

