/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.workerbuildings;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.IBuildingWorker;
import com.minecolonies.api.colony.buildings.ModBuildings;
import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.constant.ToolType;
import com.minecolonies.blockout.views.Window;
import com.minecolonies.coremod.achievements.ModAchievements;
import com.minecolonies.coremod.client.gui.WindowHutMiner;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingStructureBuilder;
import com.minecolonies.coremod.colony.buildings.views.AbstractBuildingBuilderView;
import com.minecolonies.coremod.colony.jobs.JobMiner;
import com.minecolonies.coremod.colony.workorders.WorkOrderBuildMiner;
import com.minecolonies.coremod.entity.ai.citizen.miner.Level;
import com.minecolonies.coremod.entity.ai.citizen.miner.Node;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildingMiner
extends AbstractBuildingStructureBuilder {
    private static final String MINER = "Miner";
    @NotNull
    private final List<Level> levels = new ArrayList<Level>();
    private boolean clearedShaft = false;
    private int startingLevelShaft = 0;
    private BlockPos cobbleLocation;
    private int startingLevelNode = 0;
    private int currentLevel = 0;
    private BlockPos shaftStart;
    private int vectorX = 1;
    private int vectorZ = 1;
    private BlockPos ladderLocation;
    private boolean foundLadder = false;
    @Nullable
    private Node activeNode = null;
    @Nullable
    private Node oldNode = null;

    public BuildingMiner(IColony c, BlockPos l) {
        super(c, l);
        ItemStack stackLadder = new ItemStack(Blocks.field_150468_ap);
        ItemStack stackFence = new ItemStack(Blocks.field_180407_aO);
        ItemStack stackTorch = new ItemStack(Blocks.field_150478_aa);
        ItemStack stackCobble = new ItemStack(Blocks.field_150347_e);
        ItemStack stackSlab = new ItemStack((Block)Blocks.field_150376_bx);
        ItemStack stackPlanks = new ItemStack(Blocks.field_150344_f);
        ItemStack stackDirt = new ItemStack(Blocks.field_150346_d);
        this.keepX.put(arg_0 -> ((ItemStack)stackLadder).func_77969_a(arg_0), new Tuple((Object)64, (Object)true));
        this.keepX.put(arg_0 -> ((ItemStack)stackFence).func_77969_a(arg_0), new Tuple((Object)64, (Object)true));
        this.keepX.put(arg_0 -> ((ItemStack)stackTorch).func_77969_a(arg_0), new Tuple((Object)64, (Object)true));
        this.keepX.put(arg_0 -> ((ItemStack)stackCobble).func_77969_a(arg_0), new Tuple((Object)64, (Object)true));
        this.keepX.put(arg_0 -> ((ItemStack)stackSlab).func_77969_a(arg_0), new Tuple((Object)64, (Object)true));
        this.keepX.put(arg_0 -> ((ItemStack)stackPlanks).func_77969_a(arg_0), new Tuple((Object)64, (Object)true));
        this.keepX.put(arg_0 -> ((ItemStack)stackDirt).func_77969_a(arg_0), new Tuple((Object)64, (Object)true));
        this.keepX.put(itemStack -> ItemStackUtils.hasToolLevel(itemStack, ToolType.PICKAXE, 0, this.getMaxToolLevel()), new Tuple((Object)1, (Object)true));
        this.keepX.put(itemStack -> ItemStackUtils.hasToolLevel(itemStack, ToolType.SHOVEL, 0, this.getMaxToolLevel()), new Tuple((Object)1, (Object)true));
        this.keepX.put(itemStack -> ItemStackUtils.hasToolLevel(itemStack, ToolType.AXE, 0, this.getMaxToolLevel()), new Tuple((Object)1, (Object)true));
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return MINER;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    public void onUpgradeComplete(int newLevel) {
        super.onUpgradeComplete(newLevel);
        if (newLevel == 1) {
            this.getColony().getStatsManager().triggerAchievement(ModAchievements.achievementBuildingMiner);
        }
        if (newLevel >= this.getMaxBuildingLevel()) {
            this.getColony().getStatsManager().triggerAchievement(ModAchievements.achievementUpgradeMinerMax);
        }
    }

    @Override
    public BuildingEntry getBuildingRegistryEntry() {
        return ModBuildings.miner;
    }

    @Override
    @NotNull
    public IJob createJob(ICitizenData citizen) {
        return new JobMiner(citizen);
    }

    @Override
    public void deserializeNBT(NBTTagCompound compound) {
        super.deserializeNBT(compound);
        this.startingLevelShaft = compound.func_74762_e("startingLevelShaft");
        this.clearedShaft = compound.func_74767_n("clearedShaft");
        this.vectorX = compound.func_74762_e("vectorx");
        this.vectorZ = compound.func_74762_e("vectorz");
        if (compound.func_74764_b("activeNodeNode")) {
            this.activeNode = Node.createFromNBT(compound.func_74775_l("activeNodeNode"));
        } else if (compound.func_74764_b("oldNodeNode")) {
            this.oldNode = Node.createFromNBT(compound.func_74775_l("oldNodeNode"));
        }
        this.currentLevel = compound.func_74762_e("currentLevel");
        this.ladderLocation = BlockPosUtil.readFromNBT(compound, "ladderlocation");
        this.foundLadder = compound.func_74767_n("found_ladder");
        this.shaftStart = BlockPosUtil.readFromNBT(compound, "shaftLocation");
        this.cobbleLocation = BlockPosUtil.readFromNBT(compound, "cobblelocation");
        this.startingLevelNode = compound.func_74762_e("StartingNode");
        NBTTagList levelTagList = compound.func_150295_c("levels", 10);
        for (int i = 0; i < levelTagList.func_74745_c(); ++i) {
            this.levels.add(new Level(levelTagList.func_150305_b(i)));
        }
    }

    @Override
    public NBTTagCompound serializeNBT() {
        NBTTagCompound nodeCompound;
        NBTTagCompound compound = super.serializeNBT();
        compound.func_74768_a("startingLevelShaft", this.startingLevelShaft);
        compound.func_74757_a("clearedShaft", this.clearedShaft);
        compound.func_74768_a("vectorx", this.vectorX);
        compound.func_74768_a("vectorz", this.vectorZ);
        if (this.activeNode != null) {
            nodeCompound = new NBTTagCompound();
            this.activeNode.writeToNBT(nodeCompound);
            compound.func_74782_a("activeNodeNode", (NBTBase)nodeCompound);
        }
        if (this.oldNode != null) {
            nodeCompound = new NBTTagCompound();
            this.oldNode.writeToNBT(new NBTTagCompound());
            compound.func_74782_a("oldNodeNode", (NBTBase)nodeCompound);
        }
        compound.func_74768_a("currentLevel", this.currentLevel);
        compound.func_74757_a("found_ladder", this.foundLadder);
        compound.func_74768_a("StartingNode", this.startingLevelNode);
        if (this.shaftStart != null && this.cobbleLocation != null) {
            BlockPosUtil.writeToNBT(compound, "shaftLocation", this.shaftStart);
            BlockPosUtil.writeToNBT(compound, "cobblelocation", this.cobbleLocation);
        }
        if (this.ladderLocation != null) {
            BlockPosUtil.writeToNBT(compound, "ladderlocation", this.ladderLocation);
        }
        NBTTagList levelTagList = new NBTTagList();
        for (Level level : this.levels) {
            NBTTagCompound levelCompound = new NBTTagCompound();
            level.writeToNBT(levelCompound);
            levelTagList.func_74742_a((NBTBase)levelCompound);
        }
        compound.func_74782_a("levels", (NBTBase)levelTagList);
        return compound;
    }

    @Override
    @NotNull
    public String getJobName() {
        return MINER;
    }

    @Override
    public void serializeToView(@NotNull ByteBuf buf) {
        super.serializeToView(buf);
        buf.writeInt(this.currentLevel);
        buf.writeInt(this.levels.size());
        for (Level level : this.levels) {
            buf.writeInt(level.getNumberOfBuiltNodes());
            buf.writeInt(level.getDepth());
        }
    }

    public void addLevel(Level currentLevel) {
        this.levels.add(currentLevel);
    }

    public int getNumberOfLevels() {
        return this.levels.size();
    }

    @Nullable
    public Level getCurrentLevel() {
        if (this.currentLevel >= 0 && this.currentLevel < this.levels.size()) {
            return this.levels.get(this.currentLevel);
        }
        return null;
    }

    public int getLevelId(Level level) {
        return this.levels.indexOf(level);
    }

    public void setCurrentLevel(int currentLevel) {
        this.currentLevel = currentLevel;
        this.activeNode = null;
        this.oldNode = null;
    }

    public int getDepthLimit() {
        if (this.getBuildingLevel() == 1) {
            return 50;
        }
        if (this.getBuildingLevel() == 2) {
            return 30;
        }
        if (this.getBuildingLevel() >= 3) {
            return 5;
        }
        return 70;
    }

    public BlockPos getLadderLocation() {
        return this.ladderLocation;
    }

    public void setLadderLocation(BlockPos ladderLocation) {
        this.ladderLocation = ladderLocation;
    }

    public boolean hasFoundLadder() {
        return this.foundLadder;
    }

    public void setFoundLadder(boolean foundLadder) {
        this.foundLadder = foundLadder;
    }

    public int getVectorX() {
        return this.vectorX;
    }

    public void setVectorX(int vectorX) {
        this.vectorX = vectorX;
    }

    public int getVectorZ() {
        return this.vectorZ;
    }

    public void setVectorZ(int vectorZ) {
        this.vectorZ = vectorZ;
    }

    public BlockPos getCobbleLocation() {
        return this.cobbleLocation;
    }

    public void setCobbleLocation(BlockPos pos) {
        this.cobbleLocation = pos;
    }

    public void setShaftStart(BlockPos pos) {
        this.shaftStart = pos;
    }

    public int getStartingLevelShaft() {
        return this.startingLevelShaft;
    }

    public void resetStartingLevelShaft() {
        this.startingLevelShaft = 1;
    }

    public void incrementStartingLevelShaft() {
        ++this.startingLevelShaft;
    }

    public boolean hasClearedShaft() {
        return this.clearedShaft;
    }

    public void setClearedShaft(boolean clearedShaft) {
        this.clearedShaft = clearedShaft;
    }

    @NotNull
    public Node getActiveNode() {
        return this.activeNode == null || this.activeNode.getStatus() == Node.NodeStatus.COMPLETED ? this.levels.get(this.currentLevel).getRandomNode(this.oldNode) : this.activeNode;
    }

    public void setActiveNode(Node activeNode) {
        this.activeNode = activeNode;
    }

    public Node getOldNode() {
        return this.oldNode;
    }

    public void setOldNode(Node oldNode) {
        this.oldNode = oldNode;
    }

    @Override
    public void searchWorkOrder() {
        ICitizenData citizen = this.getMainCitizen();
        if (citizen == null) {
            return;
        }
        List<WorkOrderBuildMiner> list = this.getColony().getWorkManager().getOrderedList(WorkOrderBuildMiner.class, this.getPosition());
        for (WorkOrderBuildMiner wo : list) {
            if (!this.getID().equals((Object)wo.getMinerBuilding())) continue;
            citizen.getJob(JobMiner.class).setWorkOrder(wo);
            wo.setClaimedBy(citizen);
            return;
        }
    }

    public static class View
    extends AbstractBuildingBuilderView {
        public List<Tuple<Integer, Integer>> levelsInfo;
        public int current;

        public View(IColonyView c, BlockPos l) {
            super(c, l);
        }

        @Override
        @NotNull
        public Window getWindow() {
            return new WindowHutMiner(this);
        }

        @Override
        public void deserialize(@NotNull ByteBuf buf) {
            super.deserialize(buf);
            this.current = buf.readInt();
            int size = buf.readInt();
            this.levelsInfo = new ArrayList<Tuple<Integer, Integer>>(size);
            for (int i = 0; i < size; ++i) {
                this.levelsInfo.add(i, (Tuple<Integer, Integer>)new Tuple((Object)buf.readInt(), (Object)buf.readInt()));
            }
        }

        @Override
        @NotNull
        public IBuildingWorker.Skill getPrimarySkill() {
            return IBuildingWorker.Skill.STRENGTH;
        }

        @Override
        @NotNull
        public IBuildingWorker.Skill getSecondarySkill() {
            return IBuildingWorker.Skill.ENDURANCE;
        }
    }
}

