/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.citizen.guard;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.IGuardBuilding;
import com.minecolonies.api.colony.buildings.views.MobEntryView;
import com.minecolonies.api.colony.guardtype.registry.ModGuardTypes;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.entity.ai.citizen.guards.GuardTask;
import com.minecolonies.api.entity.ai.statemachine.AIOneTimeEventTarget;
import com.minecolonies.api.entity.ai.statemachine.AITarget;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.constant.Constants;
import com.minecolonies.api.util.constant.ToolType;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingGuards;
import com.minecolonies.coremod.colony.buildings.AbstractSchematicProvider;
import com.minecolonies.coremod.colony.jobs.AbstractJobGuard;
import com.minecolonies.coremod.entity.SittingEntity;
import com.minecolonies.coremod.entity.ai.basic.AbstractEntityAIFight;
import com.minecolonies.coremod.entity.citizen.EntityCitizen;
import com.minecolonies.coremod.network.messages.SleepingParticleMessage;
import com.minecolonies.coremod.util.TeleportHelper;
import java.lang.ref.WeakReference;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.IInventory;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractEntityAIGuard<J extends AbstractJobGuard>
extends AbstractEntityAIFight<J> {
    private static final int ACTIONS_UNTIL_DUMPING = 5;
    private static final int MAX_PATROL_DERIVATION = 50;
    private static final int MAX_FOLLOW_DERIVATION = 20;
    private static final int MAX_GUARD_DERIVATION = 10;
    private static final int STOP_PERSECUTION_AFTER = 200;
    protected int currentAttackDelay = 0;
    private int lastSeen = 0;
    protected EntityLivingBase target = null;
    private BlockPos currentPatrolPoint = null;
    private WeakReference<EntityCitizen> helpCitizen = new WeakReference<Object>(null);
    protected final IGuardBuilding buildingGuards;
    private static final int PARTICLE_INTERVAL = 30;
    private static final int SHOULD_SLEEP_INTERVAL = 200;
    private static final int GUARD_TASK_INTERVAL = 20;
    private static final int GUARD_REGEN_INTERVAL = 40;
    private int sleepTimer = 0;
    private int wakeTimer = 0;
    private WeakReference<EntityCitizen> sleepingGuard = new WeakReference<Object>(null);

    public AbstractEntityAIGuard(@NotNull J job) {
        super(job);
        super.registerTargets(new AITarget((IAIState)AIWorkerState.DECIDE, this::decide, 20), new AITarget(AIWorkerState.GUARD_PATROL, this::shouldSleep, () -> AIWorkerState.GUARD_SLEEP, 200), new AITarget((IAIState)AIWorkerState.GUARD_PATROL, this::decide, 20), new AITarget((IAIState)AIWorkerState.GUARD_SLEEP, this::sleep, 1), new AITarget((IAIState)AIWorkerState.GUARD_SLEEP, this::sleepParticles, 30), new AITarget((IAIState)AIWorkerState.GUARD_WAKE, this::wakeUpGuard, 20), new AITarget((IAIState)AIWorkerState.GUARD_FOLLOW, this::decide, 20), new AITarget(AIWorkerState.GUARD_GUARD, this::shouldSleep, () -> AIWorkerState.GUARD_SLEEP, 200), new AITarget((IAIState)AIWorkerState.GUARD_GUARD, this::decide, 20), new AITarget((IAIState)AIWorkerState.GUARD_REGEN, this::regen, 40), new AITarget((IAIState)AIWorkerState.HELP_CITIZEN, this::helping, 20));
        this.buildingGuards = (IGuardBuilding)this.getOwnBuilding();
    }

    private IAIState wakeUpGuard() {
        if (this.sleepingGuard.get() == null || !(((EntityCitizen)((Object)this.sleepingGuard.get())).getCitizenJobHandler().getColonyJob() instanceof AbstractJobGuard) || !((EntityCitizen)((Object)this.sleepingGuard.get())).getCitizenJobHandler().getColonyJob(AbstractJobGuard.class).isAsleep()) {
            return AIWorkerState.DECIDE;
        }
        ++this.wakeTimer;
        if (this.wakeTimer == 1) {
            return this.getState();
        }
        if (BlockPosUtil.getDistanceSquared(((EntityCitizen)((Object)this.sleepingGuard.get())).func_180425_c(), this.worker.func_180425_c()) <= 4L || this.wakeTimer > 10) {
            this.worker.func_184609_a(EnumHand.OFF_HAND);
            ((EntityCitizen)((Object)this.sleepingGuard.get())).func_70097_a(new DamageSource("wakeywakey").func_76348_h(), 1.0f);
            ((EntityCitizen)((Object)this.sleepingGuard.get())).func_70604_c((EntityLivingBase)this.worker);
            return AIWorkerState.DECIDE;
        }
        this.worker.getNavigator().moveToEntityLiving((Entity)this.sleepingGuard.get(), this.getCombatMovementSpeed());
        return this.getState();
    }

    private boolean shouldSleep() {
        if (this.worker.func_70643_av() != null || this.target != null) {
            return false;
        }
        if (this.worker.getRandom().nextInt((int)((double)this.worker.getCitizenExperienceHandler().getLevel() * 0.5) + 20) == 1) {
            this.sleepTimer = this.worker.getRandom().nextInt(500) + 2500;
            SittingEntity entity = new SittingEntity(this.world, this.worker.field_70165_t, this.worker.field_70163_u - 1.0, this.worker.field_70161_v, this.sleepTimer);
            this.worker.func_184220_m(entity);
            this.world.func_72838_d((Entity)entity);
            this.worker.getNavigator().func_75499_g();
            return true;
        }
        return false;
    }

    private IAIState sleepParticles() {
        MineColonies.getNetwork().sendToAllTracking((IMessage)new SleepingParticleMessage(this.worker.field_70165_t, this.worker.field_70163_u + 2.0, this.worker.field_70161_v), (Entity)this.worker);
        if (this.worker.func_110143_aJ() < this.worker.func_110138_aP()) {
            this.worker.func_70606_j(this.worker.func_110143_aJ() + 0.5f);
        }
        return null;
    }

    private IAIState sleep() {
        if (this.worker.func_70643_av() != null || (this.sleepTimer -= this.getTickRate()) < 0) {
            this.resetTarget();
            this.worker.func_70604_c(null);
            this.worker.func_184210_p();
            this.worker.func_70107_b(this.worker.field_70165_t, this.worker.field_70163_u + 1.0, this.worker.field_70161_v);
            return AIWorkerState.DECIDE;
        }
        this.worker.func_70671_ap().func_75650_a(this.worker.field_70165_t + (double)this.worker.func_174811_aO().func_82601_c(), this.worker.field_70163_u + (double)this.worker.func_174811_aO().func_96559_d(), this.worker.field_70161_v + (double)this.worker.func_174811_aO().func_82599_e(), 0.0f, -30.0f);
        return null;
    }

    private IAIState regen() {
        if (this.walkToBuilding()) {
            return AIWorkerState.GUARD_REGEN;
        }
        if ((double)this.worker.func_110143_aJ() < (double)((int)this.worker.func_110138_aP()) * 0.75 && this.buildingGuards.shallRetrieveOnLowHealth()) {
            if (!this.worker.func_70644_a(MobEffects.field_76428_l)) {
                this.worker.func_70690_d(new PotionEffect(MobEffects.field_76428_l, 200));
            }
            return AIWorkerState.GUARD_REGEN;
        }
        return AIWorkerState.START_WORKING;
    }

    public abstract IAIState getAttackState();

    private IAIState guard() {
        if (this.checkForTarget()) {
            if (this.hasTool()) {
                return this.getAttackState();
            }
            return AIWorkerState.START_WORKING;
        }
        this.worker.isWorkerAtSiteWithMove(this.buildingGuards.getGuardPos(), 3);
        return AIWorkerState.GUARD_GUARD;
    }

    private IAIState follow() {
        if (this.checkForTarget()) {
            if (this.hasTool()) {
                return this.getAttackState();
            }
            return AIWorkerState.START_WORKING;
        }
        this.worker.func_70690_d(new PotionEffect(Constants.GLOW_EFFECT, 600, 20));
        this.world.func_96441_U().func_151392_a(this.worker.func_70005_c_(), "teamcolony" + this.worker.getCitizenColonyHandler().getColonyId());
        if (BlockPosUtil.getDistance2D(this.worker.func_180425_c(), this.buildingGuards.getPlayerToFollow()) > 20L) {
            TeleportHelper.teleportCitizen(this.worker, this.worker.func_130014_f_(), this.buildingGuards.getPlayerToFollow());
            return AIWorkerState.GUARD_FOLLOW;
        }
        if (this.buildingGuards.isTightGrouping()) {
            this.worker.isWorkerAtSiteWithMove(this.buildingGuards.getPlayerToFollow(), 8);
        } else if (!this.isWithinPersecutionDistance(this.buildingGuards.getPlayerToFollow())) {
            this.worker.getNavigator().func_75499_g();
            this.worker.func_70605_aq().func_188488_a(0.0f, 0.0f);
        } else {
            this.worker.isWorkerAtSiteWithMove(this.buildingGuards.getPlayerToFollow(), 20);
        }
        return AIWorkerState.GUARD_FOLLOW;
    }

    private IAIState patrol() {
        if (this.checkForTarget()) {
            if (this.hasTool()) {
                return this.getAttackState();
            }
            return AIWorkerState.START_WORKING;
        }
        if (this.currentPatrolPoint == null) {
            this.currentPatrolPoint = this.buildingGuards.getNextPatrolTarget(null);
        }
        if (this.currentPatrolPoint != null && (this.worker.isWorkerAtSiteWithMove(this.currentPatrolPoint, 2) || this.worker.getCitizenStuckHandler().isStuck())) {
            this.currentPatrolPoint = this.buildingGuards.getNextPatrolTarget(this.currentPatrolPoint);
        }
        return AIWorkerState.GUARD_PATROL;
    }

    @Override
    public Class getExpectedBuildingClass() {
        return AbstractBuildingGuards.class;
    }

    @Override
    protected int getActionsDoneUntilDumping() {
        return this.getOwnBuilding(AbstractBuildingGuards.class).getTask() == GuardTask.FOLLOW || this.target != null ? Integer.MAX_VALUE : 5 * ((AbstractSchematicProvider)this.getOwnBuilding()).getBuildingLevel();
    }

    public boolean hasTool() {
        for (ToolType toolType : this.toolsNeeded) {
            if (InventoryUtils.hasItemHandlerToolWithLevel((IItemHandler)new InvWrapper((IInventory)this.getInventory()), toolType, 0, this.buildingGuards.getMaxToolLevel())) continue;
            return false;
        }
        return true;
    }

    public void startHelpCitizen(EntityCitizen citizen, EntityLivingBase attacker) {
        if (this.canHelp()) {
            this.registerTarget(new AIOneTimeEventTarget(AIWorkerState.HELP_CITIZEN));
            this.target = attacker;
            this.helpCitizen = new WeakReference<EntityCitizen>(citizen);
        }
    }

    public boolean canHelp() {
        return !this.isEntityValidTarget(this.target) && this.getState() == AIWorkerState.GUARD_PATROL;
    }

    private IAIState helping() {
        this.reduceAttackDelay(20 * this.getTickRate());
        if (this.helpCitizen.get() == null || !((EntityCitizen)((Object)this.helpCitizen.get())).isCurrentlyFleeing()) {
            return AIWorkerState.DECIDE;
        }
        if (this.target == null || this.target.field_70128_L) {
            this.target = ((EntityCitizen)((Object)this.helpCitizen.get())).func_70643_av();
            if (this.target == null || this.target.field_70128_L) {
                return AIWorkerState.DECIDE;
            }
        }
        this.currentPatrolPoint = null;
        if (this.worker.func_70635_at().func_75522_a((Entity)this.target) && this.isWithinPersecutionDistance(this.target.func_180425_c())) {
            this.target.func_70604_c((EntityLivingBase)this.worker);
            return this.getAttackState();
        }
        this.moveInAttackPosition();
        return AIWorkerState.HELP_CITIZEN;
    }

    protected IAIState decide() {
        this.reduceAttackDelay(20 * this.getTickRate());
        switch (this.buildingGuards.getTask()) {
            case PATROL: {
                return this.patrol();
            }
            case GUARD: {
                return this.guard();
            }
            case FOLLOW: {
                return this.follow();
            }
        }
        this.worker.isWorkerAtSiteWithMove(this.worker.getCitizenColonyHandler().getWorkBuilding().getPosition(), 3);
        return AIWorkerState.DECIDE;
    }

    protected boolean checkForTarget() {
        if (this.target != null && this.target.field_70128_L) {
            this.incrementActionsDoneAndDecSaturation();
            this.worker.getCitizenExperienceHandler().addExperience(5.0);
        }
        if (this.isEntityValidTarget(this.target)) {
            this.lastSeen = !this.worker.func_70685_l((Entity)this.target) ? (this.lastSeen += 20) : 0;
            if (this.lastSeen > 200) {
                this.resetTarget();
                return false;
            }
            if (!this.isInAttackDistance(this.target.func_180425_c()) && this.worker.getNavigator().func_75500_f()) {
                this.moveInAttackPosition();
            }
            return true;
        }
        this.resetTarget();
        if (this.isEntityValidTargetAndCanbeSeen(this.worker.func_70643_av())) {
            this.target = this.worker.func_70643_av();
            return true;
        }
        this.target = this.getNearbyTarget();
        return this.target != null;
    }

    public boolean isEntityValidTargetAndCanbeSeen(EntityLivingBase entity) {
        return this.isEntityValidTarget(entity) && this.worker.func_70685_l((Entity)entity);
    }

    public boolean isEntityValidTarget(EntityLivingBase entity) {
        MobEntryView entry;
        if (entity == null || entity.field_70128_L || !this.isWithinPersecutionDistance(entity.func_180425_c())) {
            return false;
        }
        if (entity == this.worker.func_70643_av()) {
            return true;
        }
        if (entity instanceof IMob && (entry = this.buildingGuards.getMobsToAttack().get(entity.getClass())) != null && entry.shouldAttack()) {
            return true;
        }
        IColony colony = this.worker.getCitizenColonyHandler().getColony();
        if (colony == null) {
            return false;
        }
        if (entity instanceof EntityPlayer && (colony.getPermissions().hasPermission((EntityPlayer)entity, Action.GUARDS_ATTACK) || colony.isValidAttackingPlayer((EntityPlayer)entity))) {
            return true;
        }
        return entity instanceof EntityCitizen && colony.isValidAttackingGuard((AbstractEntityCitizen)entity);
    }

    public void resetTarget() {
        if (this.target == null) {
            return;
        }
        if (this.worker.func_110144_aD() == this.target) {
            this.worker.func_130011_c(null);
        }
        if (this.worker.func_70643_av() == this.target) {
            this.worker.func_70604_c(null);
        }
        this.target = null;
    }

    public abstract void moveInAttackPosition();

    public IAIState preAttackChecks() {
        if (!this.hasMainWeapon()) {
            this.resetTarget();
            return AIWorkerState.START_WORKING;
        }
        if (this.buildingGuards.shallRetrieveOnLowHealth() && (double)this.worker.func_110143_aJ() < (double)((int)this.worker.func_110138_aP()) * 0.2) {
            this.resetTarget();
            return AIWorkerState.GUARD_REGEN;
        }
        if (!this.checkForTarget()) {
            return AIWorkerState.DECIDE;
        }
        this.wearWeapon();
        return this.getState();
    }

    public abstract boolean hasMainWeapon();

    protected EntityLivingBase getNearbyTarget() {
        IColony colony = this.worker.getCitizenColonyHandler().getColony();
        if (colony == null) {
            this.resetTarget();
            return null;
        }
        List entities = this.world.func_72872_a(EntityLivingBase.class, this.getSearchArea());
        int closest = Integer.MAX_VALUE;
        EntityLivingBase targetEntity = null;
        for (EntityLivingBase entity : entities) {
            int tempDistance;
            EntityCitizen citizen;
            if (!this.worker.func_70685_l((Entity)entity) || entity.field_70128_L) continue;
            if (entity instanceof EntityCitizen && (citizen = (EntityCitizen)entity).getCitizenJobHandler().getColonyJob() instanceof AbstractJobGuard && ((AbstractJobGuard)citizen.getCitizenJobHandler().getColonyJob()).isAsleep()) {
                this.sleepingGuard = new WeakReference<EntityCitizen>(citizen);
                this.wakeTimer = 0;
                this.registerTarget(new AIOneTimeEventTarget(AIWorkerState.GUARD_WAKE));
                return null;
            }
            if (!this.isEntityValidTarget(entity) || (tempDistance = (int)this.worker.func_180425_c().func_177954_c(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v)) >= closest) continue;
            closest = tempDistance;
            targetEntity = entity;
        }
        return targetEntity;
    }

    public abstract void wearWeapon();

    public boolean isInAttackDistance(BlockPos position) {
        return BlockPosUtil.getDistanceSquared2D(this.worker.func_180425_c(), position) <= (long)(this.getAttackRange() * this.getAttackRange());
    }

    public void reduceAttackDelay(int value) {
        if (this.currentAttackDelay > 0) {
            this.currentAttackDelay -= value;
        }
    }

    private boolean isWithinPersecutionDistance(BlockPos entityPos) {
        return (double)BlockPosUtil.getDistanceSquared(this.getTaskReferencePoint(), entityPos) <= Math.pow(this.getPersecutionDistance() + this.getAttackRange(), 2.0);
    }

    public int getLevelDamage() {
        if (this.worker.getCitizenData() == null) {
            return 0;
        }
        return this.worker.getCitizenData().getLevel() / (5 + this.worker.getCitizenData().getLevel() / 15);
    }

    private BlockPos getTaskReferencePoint() {
        switch (this.buildingGuards.getTask()) {
            case PATROL: {
                return this.currentPatrolPoint != null ? this.currentPatrolPoint : this.worker.func_180425_c();
            }
            case FOLLOW: {
                return this.buildingGuards.getPlayerToFollow();
            }
        }
        return this.buildingGuards.getGuardPos();
    }

    private int getPersecutionDistance() {
        switch (this.buildingGuards.getTask()) {
            case PATROL: {
                return 50;
            }
            case FOLLOW: {
                return 20;
            }
        }
        return 10 + (this.buildingGuards.getGuardType() == ModGuardTypes.knight ? 20 : 0);
    }

    private AxisAlignedBB getSearchArea() {
        IGuardBuilding building = (IGuardBuilding)this.getOwnBuilding();
        double x1 = this.worker.func_180425_c().func_177958_n() + (building.getBonusVision() + 10);
        double x2 = this.worker.func_180425_c().func_177958_n() - (building.getBonusVision() + 10);
        double y1 = this.worker.func_180425_c().func_177956_o() + 5;
        double y2 = this.worker.func_180425_c().func_177956_o() - 20;
        double z1 = this.worker.func_180425_c().func_177952_p() + (building.getBonusVision() + 10);
        double z2 = this.worker.func_180425_c().func_177952_p() - (building.getBonusVision() + 10);
        return new AxisAlignedBB(x1, y1, z1, x2, y2, z2);
    }

    @Override
    protected abstract int getAttackRange();
}

