/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.citizen.smelter;

import com.google.common.reflect.TypeToken;
import com.ldtteam.structurize.api.util.LanguageHandler;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.interactionhandling.ChatPriority;
import com.minecolonies.api.colony.interactionhandling.TranslationTextComponent;
import com.minecolonies.api.colony.requestsystem.requestable.IRequestable;
import com.minecolonies.api.colony.requestsystem.requestable.StackList;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.entity.ai.statemachine.AITarget;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingFurnaceUser;
import com.minecolonies.coremod.colony.buildings.AbstractSchematicProvider;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingSmeltery;
import com.minecolonies.coremod.colony.interactionhandling.StandardInteractionResponseHandler;
import com.minecolonies.coremod.colony.jobs.JobSmelter;
import com.minecolonies.coremod.colony.requestable.SmeltableOre;
import com.minecolonies.coremod.entity.ai.basic.AbstractEntityAIUsesFurnace;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Tuple;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;

public class EntityAIWorkSmelter
extends AbstractEntityAIUsesFurnace<JobSmelter> {
    private static final int STRENGTH_MULTIPLIER = 2;
    private static final int INTELLIGENCE_MULTIPLIER = 1;
    private static final int HIT_DELAY = 20;
    private static final int PROGRESS_MULTIPLIER = 50;
    private static final int MAX_LEVEL = 50;
    private static final int HITTING_TIME = 5;
    private static final int CHEST_MAT_AMOUNT = 8;
    private static final int LEGS_MAT_AMOUNT = 7;
    private static final int HEAD_MAT_AMOUNT = 5;
    private static final int FEET_MAT_AMOUNT = 4;
    private static final double BASE_XP_GAIN = 5.0;
    public static final String ORE_LIST = "ores";
    private int progress = 0;
    private static final int[] ENCHANTED_BOOK_CHANCE = new int[]{0, 10, 25, 40, 60};
    private static final int MAX_ENCHANTED_BOOK_CHANCE = 100;

    public EntityAIWorkSmelter(@NotNull JobSmelter job) {
        super(job);
        super.registerTargets(new AITarget((IAIState)AIWorkerState.SMELTER_SMELTING_ITEMS, this::smeltStuff, 20));
        this.worker.getCitizenExperienceHandler().setSkillModifier(2 * this.worker.getCitizenData().getStrength() + 1 * this.worker.getCitizenData().getIntelligence());
        this.worker.func_98053_h(true);
    }

    @Override
    public Class getExpectedBuildingClass() {
        return BuildingSmeltery.class;
    }

    private IAIState smeltStuff() {
        int slot;
        this.worker.getCitizenStatusHandler().setLatestStatus(new ITextComponent[]{new TranslationTextComponent("com.minecolonies.coremod.status.smeltingdown", new Object[0])});
        if (this.walkToBuilding()) {
            return this.getState();
        }
        if (ItemStackUtils.isEmpty(this.worker.func_184586_b(EnumHand.MAIN_HAND)).booleanValue()) {
            this.progress = 0;
            if (InventoryUtils.getItemCountInItemHandler((IItemHandler)new InvWrapper((IInventory)this.worker.getInventoryCitizen()), EntityAIWorkSmelter::isSmeltableToolOrWeapon) <= 0) {
                if (!InventoryUtils.hasItemInProvider(this.getOwnBuilding(), EntityAIWorkSmelter::isSmeltableToolOrWeapon)) {
                    return AIWorkerState.START_WORKING;
                }
                InventoryUtils.transferItemStackIntoNextFreeSlotFromProvider(this.getOwnBuilding(), InventoryUtils.findFirstSlotInProviderNotEmptyWith(this.getOwnBuilding(), EntityAIWorkSmelter::isSmeltableToolOrWeapon), (IItemHandler)new InvWrapper((IInventory)this.worker.getInventoryCitizen()));
            }
            if ((slot = InventoryUtils.findFirstSlotInItemHandlerWith((IItemHandler)new InvWrapper((IInventory)this.worker.getInventoryCitizen()), EntityAIWorkSmelter::isSmeltableToolOrWeapon)) == -1) {
                return AIWorkerState.START_WORKING;
            }
            this.worker.getCitizenItemHandler().setHeldItem(EnumHand.MAIN_HAND, slot);
        }
        this.worker.getCitizenItemHandler().hitBlockWithToolInHand(((AbstractSchematicProvider)this.getOwnBuilding()).getPosition());
        if (this.progress >= this.getRequiredProgressForMakingRawMaterial()) {
            this.progress = 0;
            slot = InventoryUtils.findFirstSlotInItemHandlerWith((IItemHandler)new InvWrapper((IInventory)this.worker.getInventoryCitizen()), EntityAIWorkSmelter::isSmeltableToolOrWeapon);
            if (slot == -1) {
                this.worker.func_184611_a(EnumHand.MAIN_HAND, ItemStackUtils.EMPTY);
                return AIWorkerState.START_WORKING;
            }
            ItemStack stack = new InvWrapper((IInventory)this.worker.getInventoryCitizen()).extractItem(slot, 1, false);
            Tuple<ItemStack, Integer> materialTuple = EntityAIWorkSmelter.getMaterialAndAmount(stack);
            ItemStack material = (ItemStack)materialTuple.func_76341_a();
            if (!ItemStackUtils.isEmpty(material).booleanValue()) {
                material.func_190920_e(((Integer)materialTuple.func_76340_b()).intValue());
                material.func_77964_b(0);
                new InvWrapper((IInventory)this.worker.getInventoryCitizen()).setStackInSlot(slot, material);
                if (((AbstractSchematicProvider)this.getOwnBuilding()).getBuildingLevel() > 0 && stack.func_77948_v() && ENCHANTED_BOOK_CHANCE[((AbstractSchematicProvider)this.getOwnBuilding()).getBuildingLevel() - 1] < new Random().nextInt(100)) {
                    ItemStack book = this.extractEnchantFromItem(stack);
                    new InvWrapper((IInventory)this.worker.getInventoryCitizen()).insertItem(InventoryUtils.findFirstSlotInItemHandlerWith((IItemHandler)new InvWrapper((IInventory)this.worker.getInventoryCitizen()), ItemStack::func_190926_b), book, false);
                }
                this.incrementActionsDoneAndDecSaturation();
            } else {
                new InvWrapper((IInventory)this.worker.getInventoryCitizen()).setStackInSlot(slot, stack);
            }
            this.worker.decreaseSaturationForAction();
            this.worker.getCitizenExperienceHandler().addExperience(5.0);
            this.worker.func_184611_a(EnumHand.MAIN_HAND, ItemStackUtils.EMPTY);
            return AIWorkerState.START_WORKING;
        }
        ++this.progress;
        return this.getState();
    }

    private static Tuple<ItemStack, Integer> getMaterialAndAmount(ItemStack stack) {
        int amount = 1;
        ItemStack material = ItemStackUtils.EMPTY;
        if (stack.func_77973_b() instanceof ItemSword) {
            material = Item.ToolMaterial.valueOf((String)((ItemSword)stack.func_77973_b()).func_150932_j()).getRepairItemStack();
        } else if (stack.func_77973_b() instanceof ItemTool) {
            material = Item.ToolMaterial.valueOf((String)((ItemTool)stack.func_77973_b()).func_77861_e()).getRepairItemStack();
        } else if (stack.func_77973_b() instanceof ItemArmor) {
            material = ((ItemArmor)stack.func_77973_b()).func_82812_d().getRepairItemStack();
            EntityEquipmentSlot eq = ((ItemArmor)stack.func_77973_b()).field_77881_a;
            if (eq == EntityEquipmentSlot.CHEST) {
                amount = 8;
            } else if (eq == EntityEquipmentSlot.LEGS) {
                amount = 7;
            } else if (eq == EntityEquipmentSlot.HEAD) {
                amount = 5;
            } else if (eq == EntityEquipmentSlot.FEET) {
                amount = 4;
            }
        }
        return new Tuple((Object)material, (Object)amount);
    }

    @Override
    protected void extractFromFurnace(TileEntityFurnace furnace) {
        ItemStack copyStack;
        ItemStack ingots = new InvWrapper((IInventory)furnace).extractItem(2, 64, false);
        int multiplier = ((BuildingSmeltery)this.getOwnBuilding()).ingotMultiplier(this.worker.getCitizenData().getLevel(), this.worker.getRandom());
        for (int amount = ingots.func_190916_E() * multiplier; amount > 0; amount -= copyStack.func_190916_E()) {
            copyStack = ingots.func_77946_l();
            if (amount < ingots.func_77976_d()) {
                copyStack.func_190920_e(amount);
            } else {
                copyStack.func_190920_e(ingots.func_77976_d());
            }
            ItemStack resultStack = InventoryUtils.addItemStackToItemHandlerWithResult((IItemHandler)new InvWrapper((IInventory)this.worker.getInventoryCitizen()), copyStack);
            if (!ItemStackUtils.isEmpty(resultStack).booleanValue()) {
                resultStack.func_190920_e(resultStack.func_190916_E() + amount / multiplier);
                new InvWrapper((IInventory)furnace).setStackInSlot(2, resultStack);
                return;
            }
            this.worker.getCitizenExperienceHandler().addExperience(5.0);
            this.worker.decreaseSaturationForAction();
        }
    }

    @Override
    protected IAIState checkForAdditionalJobs() {
        int amountOfTools = InventoryUtils.getItemCountInProvider(this.getOwnBuilding(), EntityAIWorkSmelter::isSmeltableToolOrWeapon) + InventoryUtils.getItemCountInItemHandler((IItemHandler)new InvWrapper((IInventory)this.worker.getInventoryCitizen()), EntityAIWorkSmelter::isSmeltableToolOrWeapon);
        if (amountOfTools > 0) {
            return AIWorkerState.SMELTER_SMELTING_ITEMS;
        }
        this.worker.getCitizenStatusHandler().setLatestStatus(new ITextComponent[]{new TranslationTextComponent("com.minecolonies.coremod.status.idling", new Object[0])});
        this.setDelay(50);
        return AIWorkerState.START_WORKING;
    }

    @Override
    protected IRequestable getSmeltAbleClass() {
        return new SmeltableOre(64);
    }

    @Override
    protected boolean isSmeltable(ItemStack stack) {
        return ItemStackUtils.isEmpty(stack) == false && ItemStackUtils.IS_SMELTABLE.and(itemStack -> IColonyManager.getInstance().getCompatibilityManager().isOre(stack)).test(stack);
    }

    @Override
    public void requestSmeltable() {
        if (!((AbstractBuilding)this.getOwnBuilding()).hasWorkerOpenRequestsOfType(this.worker.getCitizenData(), TypeToken.of(this.getSmeltAbleClass().getClass())) && !((AbstractBuilding)this.getOwnBuilding()).hasWorkerOpenRequestsFiltered(this.worker.getCitizenData(), req -> req.getShortDisplayString().func_150260_c().equals(LanguageHandler.format((String)"com.minecolonies.coremod.request.smeltableore", (Object[])new Object[0])))) {
            Map<String, List<ItemStorage>> allowedItems = this.getOwnBuilding(AbstractBuildingFurnaceUser.class).getCopyOfAllowedItems();
            if (allowedItems.containsKey(ORE_LIST)) {
                List<ItemStack> requests = IColonyManager.getInstance().getCompatibilityManager().getSmeltableOres().stream().filter(storage -> !((List)allowedItems.get(ORE_LIST)).contains(storage)).map(ItemStorage::getItemStack).collect(Collectors.toList());
                if (requests.isEmpty()) {
                    if (this.worker.getCitizenData() != null) {
                        this.worker.getCitizenData().triggerInteraction(new StandardInteractionResponseHandler((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.furnaceUser.noOre", new Object[0]), ChatPriority.BLOCKING));
                    }
                } else {
                    this.worker.getCitizenData().createRequestAsync(new StackList(requests, "com.minecolonies.coremod.request.smeltableore"));
                }
            } else {
                this.worker.getCitizenData().createRequestAsync(this.getSmeltAbleClass());
            }
        }
    }

    private static boolean isSmeltableToolOrWeapon(ItemStack stack) {
        return ItemStackUtils.isEmpty(stack) == false && (stack.func_77973_b() instanceof ItemSword || stack.func_77973_b() instanceof ItemTool || stack.func_77973_b() instanceof ItemArmor) && !stack.func_77973_b().isDamaged(stack);
    }

    private int getRequiredProgressForMakingRawMaterial() {
        return 50 / Math.min(this.worker.getCitizenExperienceHandler().getLevel() + 1, 50) * 5;
    }

    private ItemStack extractEnchantFromItem(ItemStack item) {
        Map enchants = EnchantmentHelper.func_82781_a((ItemStack)item);
        ItemStack books = new ItemStack(Items.field_151134_bR);
        for (Map.Entry entry : enchants.entrySet()) {
            ItemEnchantedBook.func_92115_a((ItemStack)books, (EnchantmentData)new EnchantmentData((Enchantment)entry.getKey(), ((Integer)entry.getValue()).intValue()));
        }
        this.worker.decreaseSaturationForAction();
        return books;
    }
}

