/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.citizen.citizenhandlers;

import com.minecolonies.api.colony.buildings.IBuildingWorker;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenInventoryHandler;
import com.minecolonies.api.util.InventoryUtils;
import net.minecraft.block.Block;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class CitizenInventoryHandler
implements ICitizenInventoryHandler {
    private final AbstractEntityCitizen citizen;

    public CitizenInventoryHandler(AbstractEntityCitizen citizen) {
        this.citizen = citizen;
    }

    @Override
    public int findFirstSlotInInventoryWith(Item targetItem, int itemDamage) {
        return InventoryUtils.findFirstSlotInItemHandlerWith((IItemHandler)new InvWrapper((IInventory)this.citizen.getInventoryCitizen()), targetItem, itemDamage);
    }

    @Override
    public int findFirstSlotInInventoryWith(Block block, int itemDamage) {
        return InventoryUtils.findFirstSlotInItemHandlerWith((IItemHandler)new InvWrapper((IInventory)this.citizen.getInventoryCitizen()), block, itemDamage);
    }

    @Override
    public int getItemCountInInventory(Block block, int itemDamage) {
        return InventoryUtils.getItemCountInItemHandler((IItemHandler)new InvWrapper((IInventory)this.citizen.getInventoryCitizen()), block, itemDamage);
    }

    @Override
    public int getItemCountInInventory(Item targetItem, int itemDamage) {
        return InventoryUtils.getItemCountInItemHandler((IItemHandler)new InvWrapper((IInventory)this.citizen.getInventoryCitizen()), targetItem, itemDamage);
    }

    @Override
    public boolean hasItemInInventory(Block block, int itemDamage) {
        return InventoryUtils.hasItemInItemHandler((IItemHandler)new InvWrapper((IInventory)this.citizen.getInventoryCitizen()), block, itemDamage);
    }

    @Override
    public boolean hasItemInInventory(Item item, int itemDamage) {
        return InventoryUtils.hasItemInItemHandler((IItemHandler)new InvWrapper((IInventory)this.citizen.getInventoryCitizen()), item, itemDamage);
    }

    @Override
    public void onInventoryChanged() {
        IBuildingWorker building;
        if (this.citizen.getCitizenData() != null && (building = this.citizen.getCitizenData().getWorkBuilding()) != null) {
            building.markDirty();
        }
    }

    @Override
    public boolean isInventoryFull() {
        return InventoryUtils.isProviderFull((ICapabilityProvider)this.citizen);
    }
}

