/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.citizen.citizenhandlers;

import com.minecolonies.api.client.render.modeltype.BipedModelType;
import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenJobHandler;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.coremod.entity.ai.basic.AbstractEntityAIInteract;
import net.minecraft.entity.ai.EntityAITasks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CitizenJobHandler
implements ICitizenJobHandler {
    private final AbstractEntityCitizen citizen;

    public CitizenJobHandler(AbstractEntityCitizen citizen) {
        this.citizen = citizen;
    }

    @Override
    public void setModelDependingOnJob(@Nullable IJob job) {
        if (this.citizen.func_70631_g_()) {
            this.citizen.setModelId(BipedModelType.CHILD);
            this.citizen.func_184212_Q().func_187227_b(AbstractEntityCitizen.DATA_MODEL, (Object)this.citizen.getModelType().getName());
            this.citizen.setRenderMetadata("");
            return;
        }
        if (job == null) {
            if (this.citizen.getCitizenColonyHandler().getHomeBuilding() != null) {
                switch (this.citizen.getCitizenColonyHandler().getHomeBuilding().getBuildingLevel()) {
                    case 3: {
                        this.citizen.setModelId(BipedModelType.CITIZEN);
                        break;
                    }
                    case 4: {
                        this.citizen.setModelId(BipedModelType.NOBLE);
                        break;
                    }
                    case 5: {
                        this.citizen.setModelId(BipedModelType.ARISTOCRAT);
                        break;
                    }
                    default: {
                        this.citizen.setModelId(BipedModelType.SETTLER);
                        break;
                    }
                }
            } else {
                this.citizen.setModelId(BipedModelType.SETTLER);
            }
        } else {
            this.citizen.setModelId(job.getModel());
        }
        this.citizen.func_184212_Q().func_187227_b(AbstractEntityCitizen.DATA_MODEL, (Object)this.citizen.getModelType().getName());
        this.citizen.setRenderMetadata("");
    }

    @Override
    public void onJobChanged(@Nullable IJob job) {
        Object[] currentTasks;
        this.setModelDependingOnJob(job);
        for (Object task : currentTasks = this.citizen.getTasks().field_75782_a.toArray()) {
            if (!(((EntityAITasks.EntityAITaskEntry)task).field_75733_a instanceof AbstractEntityAIInteract)) continue;
            this.citizen.getTasks().func_85156_a(((EntityAITasks.EntityAITaskEntry)task).field_75733_a);
        }
        if (job != null) {
            job.addWorkerAIToTaskList(this.citizen.getTasks());
            if (this.citizen.getTicksExisted() > 0 && this.citizen.getCitizenColonyHandler().getWorkBuilding() != null) {
                BlockPosUtil.tryMoveBaseCitizenEntityToXYZ(this.citizen, this.citizen.getCitizenColonyHandler().getWorkBuilding().getPosition());
            }
        }
    }

    @Override
    @Nullable
    public <J extends IJob> J getColonyJob(@NotNull Class<J> type) {
        return this.citizen.getCitizenData() == null ? null : (J)this.citizen.getCitizenData().getJob(type);
    }

    @Override
    @Nullable
    public IJob getColonyJob() {
        return this.citizen.getCitizenData() == null ? null : this.citizen.getCitizenData().getJob();
    }

    @Override
    public boolean shouldRunAvoidance() {
        return this.getColonyJob() == null || this.getColonyJob().allowsAvoidance();
    }
}

