/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.mobs;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyRelated;
import com.minecolonies.api.entity.ai.statemachine.states.IState;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.ITickRateStateMachine;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.TickRateStateMachine;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.TickingTransition;
import com.minecolonies.api.entity.pathfinding.AbstractAdvancedPathNavigate;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.LanguageHandler;
import com.minecolonies.blockout.Log;
import com.minecolonies.coremod.entity.ai.minimal.EntityAIOpenFenceGate;
import com.minecolonies.coremod.entity.citizen.EntityCitizen;
import com.minecolonies.coremod.entity.mobs.EntityMercenaryAI;
import com.minecolonies.coremod.entity.pathfinding.GeneralEntityWalkToProxy;
import com.minecolonies.coremod.entity.pathfinding.MinecoloniesAdvancedPathNavigate;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.INpc;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIOpenDoor;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class EntityMercenary
extends EntityCreature
implements INpc,
IColonyRelated {
    private static final int SLAP_INTERVAL = 100;
    private IColony colony;
    private AbstractAdvancedPathNavigate newNavigator;
    private GeneralEntityWalkToProxy proxy;
    private int slapTimer = 0;
    private final Random rand = new Random();
    private long worldTimeAtSpawn = 0L;
    private boolean isLeader = false;
    private List<EntityMercenary> soldiers = new ArrayList<EntityMercenary>();
    private int spawnEventTime = 0;
    private boolean doSpawnEvent = false;
    private ITickRateStateMachine<IState> stateMachine;
    private static final String ENTITY_NAME = "Mercenary";

    public EntityMercenary(World world) {
        this(world, null);
    }

    public EntityMercenary(World world, IColony colony) {
        super(world);
        this.colony = colony;
        this.field_98038_p = true;
        this.func_70105_a(1.0f, 2.0f);
        this.func_174805_g(true);
        this.func_110163_bv();
        ItemStack mainhand = new ItemStack(Items.field_151010_B, 1);
        mainhand.func_77966_a(Enchantments.field_77334_n, 1);
        this.func_184201_a(EntityEquipmentSlot.MAINHAND, mainhand);
        ItemStack helmet = new ItemStack((Item)Items.field_151161_ac, 1);
        helmet.func_77966_a(Enchantments.field_180310_c, 4);
        this.func_184201_a(EntityEquipmentSlot.HEAD, helmet);
        ItemStack chest = new ItemStack((Item)Items.field_151171_ah, 1);
        chest.func_77966_a(Enchantments.field_180310_c, 4);
        this.func_184201_a(EntityEquipmentSlot.CHEST, chest);
        ItemStack legs = new ItemStack((Item)Items.field_151022_W, 1);
        this.func_184201_a(EntityEquipmentSlot.LEGS, legs);
        ItemStack boots = new ItemStack((Item)Items.field_151029_X, 1);
        this.func_184201_a(EntityEquipmentSlot.FEET, boots);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(35.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(60.0);
        this.func_70606_j(this.func_110138_aP());
        this.stateMachine = new TickRateStateMachine<EntityMercenaryAI.State>(EntityMercenaryAI.State.INIT, this::handleStateException);
        this.stateMachine.addTransition(new TickingTransition<IState>(EntityMercenaryAI.State.INIT, this::isInitialized, () -> EntityMercenaryAI.State.SPAWN_EVENT, 20));
        this.stateMachine.addTransition(new TickingTransition<IState>(EntityMercenaryAI.State.SPAWN_EVENT, this::spawnEvent, () -> EntityMercenaryAI.State.ALIVE, 30));
        this.stateMachine.addTransition(new TickingTransition<IState>(EntityMercenaryAI.State.ALIVE, this::shouldDespawn, () -> EntityMercenaryAI.State.DEAD, 100));
        this.stateMachine.addTransition(new TickingTransition<IState>(EntityMercenaryAI.State.DEAD, () -> true, this::getState, 500));
    }

    private void handleStateException(RuntimeException e) {
        Log.getLogger().warn("Mercenary entity threw an exception:", (Throwable)e);
    }

    private boolean shouldDespawn() {
        if (this.field_70170_p == null || this.field_70170_p.func_82737_E() - this.worldTimeAtSpawn > 48000L || this.colony == null || this.func_82150_aj()) {
            this.func_70106_y();
            return true;
        }
        return false;
    }

    private boolean isInitialized() {
        if (this.worldTimeAtSpawn == 0L) {
            this.worldTimeAtSpawn = this.field_70170_p.func_82737_E();
        }
        return this.field_70170_p != null && this.colony != null && !this.field_70128_L && !this.func_82150_aj();
    }

    private boolean spawnEvent() {
        if (this.spawnEventTime > 0) {
            --this.spawnEventTime;
        }
        if (!this.doSpawnEvent || this.spawnEventTime == 0) {
            return true;
        }
        if (!this.isLeader) {
            return false;
        }
        if (!this.getNavigator().func_75500_f()) {
            return false;
        }
        BlockPos first = this.soldiers.get(0).func_180425_c().func_177982_a(0, 0, 1);
        BlockPos last = this.soldiers.get(this.soldiers.size() - 1).func_180425_c().func_177982_a(0, 0, 1);
        this.func_184185_a(SoundEvents.field_191243_bm, 2.0f, 1.0f);
        if (this.func_180425_c().equals((Object)first)) {
            this.getNavigator().tryMoveToBlockPos(last, 0.5);
        } else {
            this.getNavigator().tryMoveToBlockPos(first, 0.5);
        }
        return false;
    }

    public void setDoSpawnEvent() {
        this.doSpawnEvent = true;
        this.spawnEventTime = 15;
    }

    public void setLeader(List<EntityMercenary> soldiers) {
        this.soldiers = soldiers;
        this.isLeader = true;
        this.doSpawnEvent = true;
        this.spawnEventTime = 17;
    }

    public IState getState() {
        return this.stateMachine.getState();
    }

    public void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_187713_n, 0.45f, 1.0f);
    }

    public NBTTagCompound func_189511_e(NBTTagCompound compound) {
        compound.func_74772_a("time", this.worldTimeAtSpawn);
        compound.func_74768_a("colony", this.colony == null ? 0 : this.colony.getID());
        return super.func_189511_e(compound);
    }

    public void func_70020_e(NBTTagCompound compound) {
        int colonyId;
        this.worldTimeAtSpawn = compound.func_74763_f("time");
        if (compound.func_74764_b("colony") && (colonyId = compound.func_74762_e("colony")) != 0) {
            this.setColony(IColonyManager.getInstance().getColonyByWorld(colonyId, this.field_70170_p));
        }
        super.func_70020_e(compound);
    }

    public String func_70005_c_() {
        return ENTITY_NAME;
    }

    @Override
    public void registerWithColony() {
    }

    @Override
    public IColony getColony() {
        return this.colony;
    }

    @Override
    public void setColony(IColony colony) {
        if (colony != null) {
            this.colony = colony;
            this.registerWithColony();
        }
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        if (source.func_76346_g() instanceof EntityLivingBase) {
            this.func_70624_b((EntityLivingBase)source.func_76346_g());
        }
        return super.func_70097_a(source, damage);
    }

    protected void func_82167_n(Entity entityIn) {
        if (this.slapTimer == 0 && entityIn instanceof EntityPlayer) {
            this.slapTimer = 100;
            entityIn.func_70097_a((DamageSource)new EntityDamageSource("slap", (Entity)this), 1.0f);
            this.func_184609_a(EnumHand.OFF_HAND);
        }
        if (this.slapTimer == 0 && entityIn instanceof EntityCitizen && this.colony != null) {
            this.slapTimer = 100;
            IItemHandler handler = ((EntityCitizen)entityIn).getItemHandlerCitizen();
            ItemStack stack = handler.extractItem(this.rand.nextInt(handler.getSlots()), 5, false);
            if (!ItemStackUtils.isEmpty(stack).booleanValue()) {
                this.func_184609_a(EnumHand.OFF_HAND);
                LanguageHandler.sendPlayersMessage(this.colony.getMessageEntityPlayers(), "com.minecolonies.coremod.mercenary.mercenaryStealCitizen", entityIn.func_70005_c_(), stack.func_82833_r());
            }
        }
    }

    public GeneralEntityWalkToProxy getProxy() {
        if (this.proxy == null) {
            this.proxy = new GeneralEntityWalkToProxy((EntityLiving)this);
        }
        return this.proxy;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityMercenaryAI(this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIOpenDoor((EntityLiving)this, true));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIOpenFenceGate((EntityLiving)this, true));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityMob.class, false));
    }

    @NotNull
    public AbstractAdvancedPathNavigate getNavigator() {
        if (this.newNavigator == null) {
            this.newNavigator = new MinecoloniesAdvancedPathNavigate((EntityLiving)this, this.field_70170_p);
            this.field_70699_by = this.newNavigator;
            this.newNavigator.func_179693_d(true);
            this.newNavigator.func_179691_c(true);
        }
        return this.newNavigator;
    }

    public void func_70636_d() {
        if (this.field_70170_p != null && !this.field_70170_p.field_72995_K) {
            this.stateMachine.tick();
        }
        if (this.slapTimer > 0) {
            --this.slapTimer;
        }
        this.func_82168_bl();
        super.func_70636_d();
    }

    public boolean func_70692_ba() {
        return false;
    }

    public static void spawnMercenariesInColony(@NotNull IColony colony) {
        World world = colony.getWorld();
        if (colony.getMercenaryUseTime() != 0L && world.func_82737_E() - colony.getMercenaryUseTime() < 48000L) {
            return;
        }
        colony.usedMercenaries();
        int amountOfMercenaries = colony.getCitizenManager().getCurrentCitizenCount();
        amountOfMercenaries /= 10;
        BlockPos spawn = EntityMercenary.findMercenarySpawnPos(colony, amountOfMercenaries += 3);
        ArrayList<EntityMercenary> soldiers = new ArrayList<EntityMercenary>();
        for (int i = 0; i < amountOfMercenaries; ++i) {
            EntityMercenary merc = new EntityMercenary(world, colony);
            merc.func_70107_b(spawn.func_177958_n() + i, spawn.func_177956_o(), spawn.func_177952_p());
            merc.setDoSpawnEvent();
            soldiers.add(merc);
            world.func_72838_d((Entity)merc);
        }
        EntityMercenary merc = new EntityMercenary(world, colony);
        merc.func_70107_b(spawn.func_177958_n(), spawn.func_177956_o(), spawn.func_177952_p() + 1);
        merc.setLeader(soldiers);
        world.func_72838_d((Entity)merc);
    }

    private static BlockPos findMercenarySpawnPos(IColony colony, int amountOfMercenaries) {
        AxisAlignedBB buildingArea = colony.getBuildingManager().getTownHall().getTargetableArea(colony.getWorld());
        BlockPos spawn = new BlockPos((buildingArea.field_72336_d + buildingArea.field_72340_a) / 2.0, 0.0, buildingArea.field_72339_c);
        double height = colony.getWorld().func_189649_b(spawn.func_177958_n(), spawn.func_177952_p());
        if (height > buildingArea.field_72337_e) {
            height = buildingArea.field_72338_b + 1.0;
        }
        spawn = spawn.func_177963_a(0.0, height, 0.0);
        for (int i = -3; i < 4; ++i) {
            if (!EntityMercenary.isValidSpawnForMercenaries((IBlockAccess)colony.getWorld(), spawn.func_177982_a(0, 0, i), amountOfMercenaries)) continue;
            spawn = spawn.func_177982_a(0, 0, i);
            break;
        }
        return spawn;
    }

    private static boolean isValidSpawnForMercenaries(IBlockAccess world, BlockPos spawn, int amountOfMercenaries) {
        for (int i = 0; i < amountOfMercenaries; ++i) {
            if (world.func_175623_d(spawn.func_177984_a().func_177982_a(i, 0, 0)) && world.func_175623_d(spawn.func_177984_a().func_177982_a(i, 0, 1))) continue;
            return false;
        }
        return true;
    }
}

