/*
 * Decompiled with CFR 0.152.
 */
package yalter.mousetweaks.reflect;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.crash.CrashReport;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Slot;
import net.minecraft.util.ReportedException;
import yalter.mousetweaks.impl.Obfuscation;
import yalter.mousetweaks.reflect.ReflectionCache;
import yalter.mousetweaks.util.Constants;
import yalter.mousetweaks.util.MTLog;
import yalter.mousetweaks.util.ObfuscatedName;

public class Reflection {
    private static Obfuscation obfuscation;
    private static boolean checkObfuscation;
    private static final HashMap<Class<?>, Method> HMCCache;
    public static ReflectionCache guiContainerClass;

    public static void reflectGuiContainer() {
        MTLog.logger.info("Reflecting GuiContainer...");
        guiContainerClass = new ReflectionCache();
        for (ObfuscatedName fieldName : Constants.FIELDS) {
            try {
                Field f = Reflection.getGuiField(Reflection.getObfuscatedName(fieldName));
                guiContainerClass.storeField(fieldName.forgeName, f);
            }
            catch (NoSuchFieldException e) {
                MTLog.logger.error("Could not reflect GuiContainer." + fieldName.mcpName);
                guiContainerClass = null;
                return;
            }
        }
        try {
            Method m = Reflection.getGuiMethod(Reflection.getObfuscatedName(Constants.GETSLOTATPOSITION_NAME), Integer.TYPE, Integer.TYPE);
            guiContainerClass.storeMethod(Constants.GETSLOTATPOSITION_NAME.forgeName, m);
        }
        catch (NoSuchMethodException e) {
            MTLog.logger.info("Could not retrieve GuiContainer.getSlotAtPosition().");
            guiContainerClass = null;
            return;
        }
        MTLog.logger.info("Success.");
    }

    public static Method getHMCMethod(GuiContainer object) {
        if (HMCCache.containsKey(object.getClass())) {
            return HMCCache.get(object.getClass());
        }
        try {
            Method method = Reflection.searchMethod(object.getClass(), Reflection.getObfuscatedName(Constants.HANDLEMOUSECLICK_NAME), Slot.class, Integer.TYPE, Integer.TYPE, ClickType.class);
            MTLog.logger.debug("Found handleMouseClick() for " + object.getClass().getSimpleName() + ", caching.");
            HMCCache.put(object.getClass(), method);
            return method;
        }
        catch (NoSuchMethodException e) {
            CrashReport crashreport = CrashReport.func_85055_a((Throwable)e, (String)"MouseTweaks could not find handleMouseClick() in a GuiContainer.");
            throw new ReportedException(crashreport);
        }
    }

    public static Method getHMCMethod(Object object) {
        if (HMCCache.containsKey(object.getClass())) {
            return HMCCache.get(object.getClass());
        }
        try {
            Method method = Reflection.searchMethod(object.getClass(), Reflection.getObfuscatedName(Constants.HANDLEMOUSECLICK_NAME), Slot.class, Integer.TYPE, Integer.TYPE, ClickType.class);
            MTLog.logger.debug("Found handleMouseClick() for " + object.getClass().getSimpleName() + ", caching.");
            HMCCache.put(object.getClass(), method);
            return method;
        }
        catch (NoSuchMethodException e) {
            MTLog.logger.debug("Could not find handleMouseClick() for " + object.getClass().getSimpleName() + ", using windowClick().");
            return null;
        }
    }

    private static Field getGuiField(String name) throws NoSuchFieldException {
        Field field;
        try {
            field = GuiContainer.class.getField(name);
        }
        catch (NoSuchFieldException e) {
            field = GuiContainer.class.getDeclaredField(name);
        }
        field.setAccessible(true);
        return field;
    }

    private static Method getGuiMethod(String name, Class<?> ... args) throws NoSuchMethodException {
        Method method;
        try {
            method = GuiContainer.class.getMethod(name, args);
        }
        catch (NoSuchMethodException e) {
            method = GuiContainer.class.getDeclaredMethod(name, args);
        }
        method.setAccessible(true);
        return method;
    }

    private static Method searchMethod(Class<?> clazz, String name, Class<?> ... args) throws NoSuchMethodException {
        while (true) {
            try {
                Method method = clazz.getDeclaredMethod(name, args);
                method.setAccessible(true);
                return method;
            }
            catch (NoSuchMethodException e) {
                if ((clazz = clazz.getSuperclass()) != null) continue;
                throw new NoSuchMethodException();
            }
            break;
        }
    }

    private static String getObfuscatedName(ObfuscatedName obfuscatedName) {
        if (checkObfuscation) {
            Reflection.checkObfuscation();
        }
        return obfuscatedName.get(obfuscation);
    }

    private static void checkObfuscation() {
        checkObfuscation = false;
        try {
            Reflection.getGuiField(Constants.IGNOREMOUSEUP_NAME.mcpName);
            obfuscation = Obfuscation.MCP;
        }
        catch (NoSuchFieldException e) {
            try {
                Reflection.getGuiField(Constants.IGNOREMOUSEUP_NAME.forgeName);
                obfuscation = Obfuscation.FORGE;
            }
            catch (NoSuchFieldException ex) {
                obfuscation = Obfuscation.VANILLA;
            }
        }
        MTLog.logger.info("Detected obfuscation: " + (Object)((Object)obfuscation) + ".");
    }

    static {
        checkObfuscation = true;
        HMCCache = new HashMap();
    }
}

