/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.compat.xnet;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import mcjty.lib.varia.WorldTools;
import mcjty.rftools.blocks.storagemonitor.InventoryAccessSettings;
import mcjty.rftools.blocks.storagemonitor.StorageScannerTileEntity;
import mcjty.rftools.compat.xnet.StorageConnectorSettings;
import mcjty.xnet.api.channels.IChannelSettings;
import mcjty.xnet.api.channels.IConnectorSettings;
import mcjty.xnet.api.channels.IControllerContext;
import mcjty.xnet.api.gui.IEditorGui;
import mcjty.xnet.api.gui.IndicatorIcon;
import mcjty.xnet.api.helper.DefaultChannelSettings;
import mcjty.xnet.api.keys.SidedConsumer;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import org.apache.commons.lang3.tuple.Pair;

public class StorageChannelSettings
extends DefaultChannelSettings
implements IChannelSettings {
    public static final ResourceLocation iconGuiElements = new ResourceLocation("rftools", "textures/gui/guielements.png");
    private List<Pair<SidedConsumer, StorageConnectorSettings>> storageControllers = null;
    private Map<BlockPos, InventoryAccessSettings> access = null;
    private int delay = 0;

    public void readFromNBT(NBTTagCompound tag) {
    }

    public void writeToNBT(NBTTagCompound tag) {
    }

    public void tick(int channel, IControllerContext context) {
        if (this.updateCache(channel, context)) {
            this.delay = 0;
        }
        --this.delay;
        if (this.delay > 0) {
            return;
        }
        this.delay = 10;
        World world = context.getControllerWorld();
        for (Pair<SidedConsumer, StorageConnectorSettings> entry : this.storageControllers) {
            TileEntity te;
            EnumFacing side;
            BlockPos pos;
            BlockPos extractorPos = context.findConsumerPosition(((SidedConsumer)entry.getKey()).getConsumerId());
            if (extractorPos == null || !WorldTools.chunkLoaded((World)world, (BlockPos)(pos = extractorPos.func_177972_a(side = ((SidedConsumer)entry.getKey()).getSide()))) || !((te = world.func_175625_s(pos)) instanceof StorageScannerTileEntity)) continue;
            StorageScannerTileEntity scanner = (StorageScannerTileEntity)te;
            scanner.register(this.access);
        }
    }

    private BlockPos getInventory(IControllerContext context, SidedConsumer sidedConsumer) {
        BlockPos consumerPos = context.findConsumerPosition(sidedConsumer.getConsumerId());
        if (consumerPos != null) {
            EnumFacing side = sidedConsumer.getSide();
            BlockPos pos = consumerPos.func_177972_a(side);
            TileEntity te = context.getControllerWorld().func_175625_s(pos);
            if (te != null && (te instanceof IInventory || te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null))) {
                return pos;
            }
        }
        return null;
    }

    private boolean updateCache(int channel, IControllerContext context) {
        if (this.storageControllers == null) {
            StorageConnectorSettings con;
            this.storageControllers = new ArrayList<Pair<SidedConsumer, StorageConnectorSettings>>();
            this.access = new HashMap<BlockPos, InventoryAccessSettings>();
            Map connectors = context.getConnectors(channel);
            for (Map.Entry<SidedConsumer, IConnectorSettings> entry : connectors.entrySet()) {
                con = (StorageConnectorSettings)((Object)entry.getValue());
                this.addInventory(context, entry, con);
            }
            connectors = context.getRoutedConnectors(channel);
            for (Map.Entry<SidedConsumer, IConnectorSettings> entry : connectors.entrySet()) {
                con = (StorageConnectorSettings)((Object)entry.getValue());
                this.addInventory(context, entry, con);
            }
            return true;
        }
        return false;
    }

    private void addInventory(IControllerContext context, Map.Entry<SidedConsumer, IConnectorSettings> entry, StorageConnectorSettings con) {
        if (con.getMode() == StorageConnectorSettings.Mode.STORAGE) {
            this.storageControllers.add((Pair<SidedConsumer, StorageConnectorSettings>)Pair.of((Object)entry.getKey(), (Object)((Object)con)));
        } else {
            BlockPos inventory = this.getInventory(context, entry.getKey());
            if (inventory != null) {
                this.access.put(inventory, ((StorageConnectorSettings)entry.getValue()).getAccessSettings());
            }
        }
    }

    public void cleanCache() {
        this.storageControllers = null;
        this.access = null;
    }

    public int getColors() {
        return 0;
    }

    @Nullable
    public IndicatorIcon getIndicatorIcon() {
        return new IndicatorIcon(iconGuiElements, 0, 57, 11, 10);
    }

    @Nullable
    public String getIndicator() {
        return null;
    }

    public boolean isEnabled(String tag) {
        return true;
    }

    public void createGui(IEditorGui gui) {
    }

    public void update(Map<String, Object> data) {
    }
}

