/*
 * Decompiled with CFR 0.152.
 */
package me.hypherionmc.simplerpc;

import java.io.File;
import me.hypherionmc.shaded.moonconfig.core.file.FileWatcher;
import me.hypherionmc.simplerpc.ForgeClientHandler;
import me.hypherionmc.simplerpc.network.ConfigPacket;
import me.hypherionmc.simplerpc.network.NetworkHandler;
import me.hypherionmc.simplerpclib.RPCConstants;
import me.hypherionmc.simplerpclib.configuration.ConfigEngine;
import me.hypherionmc.simplerpclib.configuration.ServerConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod(modid="simple-rpc", name="Simple RPC", clientSideOnly=false, acceptableRemoteVersions="*", acceptedMinecraftVersions="1.12.2", dependencies="required-after:forge;before:pixelmon")
public class SimpleRPCForge {
    @Mod.Instance(value="simple-rpc")
    public static SimpleRPCForge INSTANCE;
    private ServerConfig serverConfig;
    private FileWatcher serverConfigWatcher = new FileWatcher();

    @Mod.EventHandler
    public void preinit(FMLPreInitializationEvent event) {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            ForgeClientHandler clientEventHandler = new ForgeClientHandler();
            MinecraftForge.EVENT_BUS.register((Object)clientEventHandler);
            ForgeClientHandler.init(Minecraft.func_71410_x(), Minecraft.func_71410_x().field_71474_y);
        } else {
            this.serverConfig = ConfigEngine.loadServerConfig(".");
            try {
                this.serverConfigWatcher.addWatch(new File("./config/simple-rpc-server.toml"), () -> {
                    this.serverConfig = ConfigEngine.loadServerConfig(".");
                    ConfigPacket packet = new ConfigPacket(this.serverConfig);
                    NetworkHandler.sendToAll(packet);
                });
            }
            catch (Exception e) {
                RPCConstants.logger.error("Failed to register server config for auto reloading", (Throwable)e);
            }
            MinecraftForge.EVENT_BUS.register((Object)this);
        }
        NetworkHandler.registerMessages();
    }

    @SubscribeEvent
    public void onEntityJoin(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof EntityPlayerMP && FMLCommonHandler.instance().getEffectiveSide().isServer() && this.serverConfig != null && this.serverConfig.enabled) {
            ConfigPacket packet = new ConfigPacket(this.serverConfig);
            NetworkHandler.sendTo((EntityPlayerMP)event.getEntity(), packet);
        }
    }
}

