/*
 * Decompiled with CFR 0.152.
 */
package me.hypherionmc.simplerpc;

import com.mojang.realmsclient.dto.PlayerInfo;
import com.mojang.realmsclient.dto.RealmsServer;
import me.hypherionmc.simplerpc.ForgeClientHandler;
import me.hypherionmc.simplerpclib.RPCConstants;
import me.hypherionmc.simplerpclib.discord.RichPresenceVariables;
import me.hypherionmc.simplerpclib.integrations.known.KnownBiomeHelper;
import me.hypherionmc.simplerpclib.integrations.known.KnownDimensionHelper;
import me.hypherionmc.simplerpclib.integrations.known.KnownServerHelpers;
import me.hypherionmc.simplerpclib.integrations.launchers.LauncherAssets;
import me.hypherionmc.simplerpclib.util.APIUtils;
import me.hypherionmc.simplerpclib.util.MCTimeUtils;
import me.hypherionmc.simplerpclib.util.MinecraftUtilHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.network.ServerPinger;
import net.minecraft.realms.RealmsSharedConstants;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Loader;
import org.apache.commons.lang3.StringUtils;

public class Utils
implements MinecraftUtilHandler {
    private final Minecraft mc = Minecraft.func_71410_x();
    public static RealmsServer realmsServer;

    @Override
    public String parseVars(String input) {
        block12: {
            input = RichPresenceVariables.MCVER.resolve(input, RealmsSharedConstants.VERSION_STRING);
            input = RichPresenceVariables.PLAYER.resolve(input, this.mc.func_110432_I().func_111285_a());
            input = RichPresenceVariables.PLAYER_HEAD.resolve(input, RichPresenceVariables.PLAYER_HEAD.getDefaultVal().replace("{UUID}", this.mc.func_110432_I().func_148256_e().getId().toString()) + "?size=512");
            if (Loader.instance().getModList() != null) {
                input = RichPresenceVariables.MODS.resolve(input, String.valueOf(Loader.instance().getModList().size()));
            }
            if (this.mc.field_71441_e != null) {
                input = RichPresenceVariables.WORLD.resolve(input, this.resolveWorldName((World)this.mc.field_71441_e));
                input = RichPresenceVariables.DIFFICULTY.resolve(input, this.mc.field_71441_e.func_175659_aa().name());
                input = this.mc.func_71401_C() != null ? RichPresenceVariables.SAVENAME.resolve(input, this.mc.func_71401_C().func_71221_J()) : RichPresenceVariables.SAVENAME.resolve(input, "Server World");
                input = RichPresenceVariables.GAME_TIME.resolve(input, MCTimeUtils.format12(this.mc.field_71441_e.func_72820_D()));
                input = RichPresenceVariables.GAME_TIME24.resolve(input, MCTimeUtils.format24(this.mc.field_71441_e.func_72820_D()));
                input = RichPresenceVariables.DAY.resolve(input, String.valueOf(this.mc.field_71441_e.func_72820_D() / 24000L));
            }
            if (this.mc.field_71439_g != null) {
                input = RichPresenceVariables.POSITION.resolve(input, this.getBlockPosString(this.mc.field_71439_g.func_180425_c()));
                input = RichPresenceVariables.BIOME.resolve(input, this.resolveBiomeName(this.mc.field_71439_g.func_180425_c()));
                if (this.mc.field_71441_e != null) {
                    String weather = "Clear";
                    if (this.mc.field_71441_e.func_72896_J()) {
                        weather = "Raining/Snowing";
                    }
                    if (this.mc.field_71441_e.func_72911_I()) {
                        weather = "Thunderstorm";
                    }
                    input = RichPresenceVariables.WEATHER.resolve(input, weather);
                }
            }
            if (this.mc.func_147104_D() != null && !this.mc.func_181540_al()) {
                try {
                    ServerData serverData = this.mc.func_147104_D();
                    input = RichPresenceVariables.SERVERIP.resolve(input, serverData.field_78845_b);
                    input = RichPresenceVariables.SERVER.resolve(input, serverData.field_78845_b.toLowerCase().replace(".", "_"));
                    input = RichPresenceVariables.SERVERNAME.resolve(input, KnownServerHelpers.isKnownServer(serverData.field_78845_b) ? KnownServerHelpers.getKnownServer((String)serverData.field_78845_b).severName : APIUtils.stringNN(serverData.field_78847_a));
                    input = RichPresenceVariables.MOTD.resolve(input, serverData.field_78843_d != null ? serverData.field_78843_d : RichPresenceVariables.MOTD.getDefaultVal());
                    input = RichPresenceVariables.SERVERICON.resolve(input, RichPresenceVariables.SERVERICON.getDefaultVal().replace("{serverurl}", serverData.field_78845_b));
                    if (!serverData.field_78841_f) {
                        ServerPinger pinger = new ServerPinger();
                        pinger.func_147224_a(serverData);
                    }
                    int online = this.mc.func_147114_u().func_175106_d().size();
                    int maxOnline = Integer.parseInt(TextFormatting.func_110646_a((String)serverData.field_78846_c).split("/")[1]);
                    input = RichPresenceVariables.PLAYERS.resolve(input, String.valueOf(online));
                    input = RichPresenceVariables.PLAYERS_EXCL.resolve(input, String.valueOf(online - 1));
                    input = RichPresenceVariables.MAXPLAYERS.resolve(input, String.valueOf(maxOnline));
                }
                catch (Exception e) {
                    if (!ForgeClientHandler.rpcCore.getClientConfig().general.debugging) break block12;
                    RPCConstants.logger.error(e.getMessage());
                    e.printStackTrace();
                }
            }
        }
        if (realmsServer != null && this.mc.func_181540_al()) {
            input = RichPresenceVariables.REALM_NAME.resolve(input, realmsServer.getName());
            input = RichPresenceVariables.REALM_DESCRIPTION.resolve(input, realmsServer.getDescription());
            input = RichPresenceVariables.REALM_WORLD.resolve(input, Utils.realmsServer.worldType.name().toLowerCase());
            input = RichPresenceVariables.REALM_GAME.resolve(input, realmsServer.getMinigameName());
            input = RichPresenceVariables.REALM_IMAGE.resolve(input, Utils.realmsServer.minigameImage);
            input = RichPresenceVariables.PLAYERS.resolve(input, String.valueOf(Utils.realmsServer.players.stream().filter(PlayerInfo::getOnline).count()));
            input = RichPresenceVariables.MAXPLAYERS.resolve(input, "10");
        }
        if (ForgeClientHandler.rpcCore != null) {
            LauncherAssets launcherAssets = ForgeClientHandler.rpcCore.getLauncherAssets();
            input = RichPresenceVariables.LAUNCHER.resolve(input, StringUtils.capitalize((String)ForgeClientHandler.rpcCore.getLauncherType().toString().toLowerCase()));
            input = RichPresenceVariables.INSTANCE.resolve(input, launcherAssets != null ? launcherAssets.PACK_NAME : "Unknown Instance");
            input = RichPresenceVariables.LAUNCHER_NAME.resolve(input, ForgeClientHandler.rpcCore.getLauncherType().toString().toLowerCase().replace(" ", ""));
        }
        return input;
    }

    @Override
    public String getWorld() {
        if (this.mc.field_71441_e.field_73011_w.func_186058_p() != null) {
            return this.mc.field_71441_e.field_73011_w.func_186058_p().func_186065_b();
        }
        return "unknown_world";
    }

    private String resolveWorldName(World world) {
        if (world.field_73011_w.func_186058_p() != null) {
            String worldResKey = world.field_73011_w.func_186058_p().func_186065_b();
            return KnownDimensionHelper.tryKnownDimensions(worldResKey).equalsIgnoreCase(worldResKey) ? APIUtils.worldNameToReadable(worldResKey) : KnownDimensionHelper.tryKnownDimensions(worldResKey);
        }
        return "Unknown World";
    }

    private String resolveBiomeName(BlockPos pos) {
        if (this.mc.field_71439_g != null && this.mc.field_71441_e.func_180494_b(pos) != null) {
            ResourceLocation location = this.mc.field_71441_e.func_180494_b(pos).getRegistryName();
            if (KnownBiomeHelper.tryKnownBiomes(location.func_110623_a()).equalsIgnoreCase(location.func_110623_a())) {
                return this.mc.field_71441_e.func_180494_b(pos).func_185359_l();
            }
            return KnownBiomeHelper.tryKnownBiomes(location.func_110623_a());
        }
        return "Unknown Biome";
    }

    public String getBlockPosString(BlockPos pos) {
        return "x: " + pos.func_177958_n() + ", y:" + pos.func_177956_o() + ", z:" + pos.func_177952_p();
    }

    @Override
    public String getBiome() {
        if (this.mc.field_71439_g != null && this.mc.field_71441_e != null) {
            BlockPos pos = this.mc.field_71439_g.func_180425_c();
            ResourceLocation location = this.mc.field_71441_e.func_180494_b(pos).getRegistryName();
            return location.toString();
        }
        return "unknown";
    }
}

