/*
 * Decompiled with CFR 0.152.
 */
package me.hypherionmc.simplerpc.network;

import io.netty.buffer.ByteBuf;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.List;
import me.hypherionmc.simplerpclib.configuration.ServerConfig;
import me.hypherionmc.simplerpclib.configuration.objects.DimensionSection;
import me.hypherionmc.simplerpclib.discord.RichPresenceCore;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class ConfigPacket
implements IMessage {
    private ServerConfig serverConfig;

    public ConfigPacket() {
    }

    public ConfigPacket(ServerConfig serverConfig) {
        this.serverConfig = serverConfig;
    }

    public void fromBytes(ByteBuf bb) {
        PacketBuffer buf = new PacketBuffer(bb);
        try {
            ServerConfig config = new ServerConfig();
            config.enabled = buf.readBoolean();
            config.multi_player.enabled = buf.readBoolean();
            config.multi_player.description = buf.func_150789_c(Integer.MAX_VALUE);
            config.multi_player.state = buf.func_150789_c(Integer.MAX_VALUE);
            config.multi_player.largeImageKey = buf.func_150789_c(Integer.MAX_VALUE);
            config.multi_player.largeImageText = buf.func_150789_c(Integer.MAX_VALUE);
            config.multi_player.smallImageKey = buf.func_150789_c(Integer.MAX_VALUE);
            config.multi_player.smallImageText = buf.func_150789_c(Integer.MAX_VALUE);
            ByteArrayInputStream bis = new ByteArrayInputStream(buf.func_179251_a());
            ObjectInputStream in = new ObjectInputStream(bis);
            config.multi_player.buttonsList = (List)in.readObject();
            ByteArrayInputStream bis2 = new ByteArrayInputStream(buf.func_179251_a());
            ObjectInputStream in2 = new ObjectInputStream(bis2);
            config.dimension_overrides = (DimensionSection)in2.readObject();
            this.serverConfig = config;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void toBytes(ByteBuf bb) {
        PacketBuffer buf = new PacketBuffer(bb);
        try {
            buf.writeBoolean(this.serverConfig.enabled);
            buf.writeBoolean(this.serverConfig.multi_player.enabled);
            buf.func_180714_a(this.serverConfig.multi_player.description);
            buf.func_180714_a(this.serverConfig.multi_player.state);
            buf.func_180714_a(this.serverConfig.multi_player.largeImageKey);
            buf.func_180714_a(this.serverConfig.multi_player.largeImageText);
            buf.func_180714_a(this.serverConfig.multi_player.smallImageKey);
            buf.func_180714_a(this.serverConfig.multi_player.smallImageText);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(this.serverConfig.multi_player.buttonsList);
            oos.flush();
            buf.func_179250_a(bos.toByteArray());
            ByteArrayOutputStream bos2 = new ByteArrayOutputStream();
            ObjectOutputStream oos2 = new ObjectOutputStream(bos2);
            oos2.writeObject(this.serverConfig.dimension_overrides);
            oos2.flush();
            buf.func_179250_a(bos2.toByteArray());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static class Handler
    implements IMessageHandler<ConfigPacket, IMessage> {
        public IMessage onMessage(ConfigPacket message, MessageContext ctx) {
            if (message.serverConfig != null) {
                RichPresenceCore.setServerConfig(message.serverConfig);
            }
            return null;
        }
    }
}

