/*
 * Decompiled with CFR 0.152.
 */
package alexndr.api.config.types;

import alexndr.api.config.types.ConfigEntry;
import net.minecraftforge.common.config.Configuration;

public class ConfigBlock
extends ConfigEntry {
    private float hardness = 0.0f;
    private float resistance = 0.0f;
    private float lightValue = 0.0f;
    private int harvestLevel = 0;
    private String harvestTool;
    private boolean unbreakable = false;
    private boolean beaconBase = false;

    public ConfigBlock(String name, String category) {
        super(name, category, true);
    }

    @Override
    public void GetConfig(Configuration config) {
        super.GetConfig(config);
        this.hardness = config.getFloat("hardness", this.subcategory, this.hardness, 0.0f, 32000.0f, "how many hits it takes to break a block");
        this.resistance = config.getFloat("resistance", this.subcategory, this.resistance, 0.0f, 32000.0f, "how much this block can resist explosions");
        this.lightValue = config.getFloat("lightValue", this.subcategory, this.lightValue, 0.0f, 1.0f, "Amount of light emitted (1.0F is max torchlight)");
        this.harvestLevel = config.getInt("harvestLevel", this.subcategory, this.harvestLevel, 0, 8, "level required to harvest this block (0=wood, 3=diamond)");
        this.harvestTool = config.getString("harvestTool", this.subcategory, this.harvestTool, "tool Class");
        this.unbreakable = config.getBoolean("unbreakable", this.subcategory, this.unbreakable, "is literally unbreakable?");
        this.beaconBase = config.getBoolean("beaconBase", this.subcategory, this.beaconBase, "block can serve as a beacon base");
    }

    public float getHardness() {
        return this.hardness;
    }

    public ConfigBlock setHardness(float hardness) {
        this.hardness = hardness;
        return this;
    }

    public float getResistance() {
        return this.resistance;
    }

    public ConfigBlock setResistance(float resistance) {
        this.resistance = resistance;
        return this;
    }

    public float getLightValue() {
        return this.lightValue;
    }

    public ConfigBlock setLightValue(float lightValue) {
        this.lightValue = lightValue;
        return this;
    }

    public int getHarvestLevel() {
        return this.harvestLevel;
    }

    public ConfigBlock setHarvestLevel(int harvestLevel) {
        this.harvestLevel = harvestLevel;
        return this;
    }

    public String getHarvestTool() {
        return this.harvestTool;
    }

    public ConfigBlock setHarvestTool(String harvestTool) {
        this.harvestTool = harvestTool;
        return this;
    }

    public boolean getUnbreakable() {
        return this.unbreakable;
    }

    public ConfigBlock setUnbreakable(boolean unbreakable) {
        this.unbreakable = unbreakable;
        return this;
    }

    public boolean getBeaconBase() {
        return this.beaconBase;
    }

    public ConfigBlock setBeaconBase(boolean beaconBase) {
        this.beaconBase = beaconBase;
        return this;
    }
}

