/*
 * Decompiled with CFR 0.152.
 */
package alexndr.api.config.types;

import alexndr.api.config.types.ConfigEntry;
import net.minecraftforge.common.config.Configuration;

public class ConfigTool
extends ConfigEntry {
    private int uses = 0;
    private int harvestLevel = 0;
    private float harvestSpeed = 0.0f;
    private float damageVsEntity = 0.0f;
    private int enchantability = 0;
    private boolean render3D = true;

    public ConfigTool(String name) {
        super(name, "Tools", true);
    }

    @Override
    public void GetConfig(Configuration config) {
        super.GetConfig(config);
        this.uses = config.getInt("Uses", this.subcategory, this.uses, 1, 32000, "number of uses this material allows. (wood = 59, stone = 131, iron = 250, diamond = 1561, gold = 32)");
        this.harvestLevel = config.getInt("harvestLevel", this.subcategory, this.harvestLevel, 0, 10, "tier of material tool can harvest (3 = DIAMOND, 2 = IRON, 1 = STONE, 0 = WOOD/GOLD)");
        this.harvestSpeed = config.getFloat("harvestSpeed", this.subcategory, this.harvestSpeed, 0.0f, 32000.0f, "how fast this tool harvests blocks (higher is faster");
        this.damageVsEntity = config.getFloat("damageVsEntity", this.subcategory, this.damageVsEntity, 0.0f, 255.0f, "Damage versus entities");
        this.enchantability = config.getInt("Enchantability", this.subcategory, this.enchantability, 1, 255, "higher = more enchantable");
        this.render3D = config.getBoolean("render3D", this.subcategory, this.render3D, "render tool in 3D");
    }

    public int getUses() {
        return this.uses;
    }

    public ConfigTool setUses(int uses) {
        this.uses = uses;
        return this;
    }

    public int getHarvestLevel() {
        return this.harvestLevel;
    }

    public ConfigTool setHarvestLevel(int harvestLevel) {
        this.harvestLevel = harvestLevel;
        return this;
    }

    public float getHarvestSpeed() {
        return this.harvestSpeed;
    }

    public ConfigTool setHarvestSpeed(float harvestSpeed) {
        this.harvestSpeed = harvestSpeed;
        return this;
    }

    public float getDamageVsEntity() {
        return this.damageVsEntity;
    }

    public ConfigTool setDamageVsEntity(float damageVsEntity) {
        this.damageVsEntity = damageVsEntity;
        return this;
    }

    public int getEnchantability() {
        return this.enchantability;
    }

    public ConfigTool setEnchantability(int enchantability) {
        this.enchantability = enchantability;
        return this;
    }

    public boolean getRender3D() {
        return this.render3D;
    }

    public ConfigTool setRender3D(boolean render3d) {
        this.render3D = render3d;
        return this;
    }
}

