/*
 * Decompiled with CFR 0.152.
 */
package alexndr.api.content.blocks;

import alexndr.api.config.IConfigureBlockHelper;
import alexndr.api.config.types.ConfigBlock;
import alexndr.api.core.SimpleCoreAPI;
import alexndr.api.helpers.game.TabHelper;
import alexndr.api.helpers.game.TooltipHelper;
import alexndr.api.registry.ContentCategories;
import alexndr.api.registry.Plugin;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class SimpleBlock
extends Block
implements IConfigureBlockHelper<SimpleBlock> {
    protected Plugin plugin;
    protected Material material;
    protected ContentCategories.Block category;
    protected ConfigBlock entry;
    protected String name;
    protected boolean dropItem = false;
    protected Item itemToDrop;
    protected int quantityToDrop = 1;
    protected boolean fireSource = false;
    protected boolean isLeaves = false;
    protected boolean isWood = false;
    protected boolean isOre = false;

    public SimpleBlock(String name, Plugin plugin, Material material, ContentCategories.Block category) {
        super(material);
        this.name = name;
        this.plugin = plugin;
        this.material = material;
        this.category = category;
        this.func_149663_c(name);
        this.setRegistryName(plugin.getModId(), name);
    }

    public SimpleBlock setStepSound(SoundType sound) {
        super.func_149672_a(sound);
        return this;
    }

    public void registerItemModel(Item itemBlock) {
        SimpleCoreAPI.proxy.registerItemRenderer(this.plugin, itemBlock, 0, this.name);
    }

    public Item createItemBlock() {
        return (Item)new ItemBlock((Block)this).setRegistryName(this.getRegistryName());
    }

    @Override
    public ConfigBlock getConfigEntry() {
        return this.entry;
    }

    @Override
    public SimpleBlock setConfigEntry(ConfigBlock entry) {
        this.entry = entry;
        this.func_149711_c(entry.getHardness());
        this.func_149752_b(entry.getResistance());
        this.func_149715_a(entry.getLightValue());
        this.setHarvestLevel(entry.getHarvestTool(), entry.getHarvestLevel());
        this.setAdditionalProperties();
        return this;
    }

    public SimpleBlock setCreativeTab(String tabName) {
        this.func_149647_a(TabHelper.getTab(tabName));
        return this;
    }

    @Override
    public SimpleBlock addToolTip(String toolTip) {
        TooltipHelper.addTooltipToBlock(this, toolTip);
        return this;
    }

    public boolean getDropItem() {
        return this.dropItem;
    }

    public Item getItemToDrop() {
        return this.itemToDrop;
    }

    public SimpleBlock setDropItem(boolean dropItem) {
        this.dropItem = dropItem;
        return this;
    }

    public SimpleBlock setItemToDrop(Item itemToDrop) {
        this.itemToDrop = itemToDrop;
        return this;
    }

    public SimpleBlock setItemToDrop(String itemToDropName) {
        this.itemToDrop = Item.func_111206_d((String)itemToDropName);
        return this;
    }

    public int getQuantityToDrop() {
        return this.quantityToDrop;
    }

    public SimpleBlock setQuantityToDrop(int quantityToDrop) {
        this.quantityToDrop = quantityToDrop;
        return this;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        if (this.getDropItem()) {
            return this.getItemToDrop();
        }
        return Item.func_150898_a((Block)this);
    }

    public int func_149745_a(Random random) {
        if (this.getDropItem()) {
            return this.getQuantityToDrop();
        }
        return 1;
    }

    public void func_180653_a(World worldIn, BlockPos pos, IBlockState state, float chance, int fortune) {
        super.func_180653_a(worldIn, pos, state, chance, fortune);
        if (this.func_180660_a(state, worldIn.field_73012_v, fortune) != Item.func_150898_a((Block)this)) {
            int amount = MathHelper.func_76136_a((Random)worldIn.field_73012_v, (int)16, (int)33);
            this.func_180637_b(worldIn, pos, amount);
        }
    }

    public int func_149679_a(int fortune, Random random) {
        if (fortune > 0 && this.func_180660_a((IBlockState)this.func_176194_O().func_177619_a().iterator().next(), random, fortune) != Item.func_150898_a((Block)this)) {
            int var = random.nextInt(fortune + 2) - 1;
            if (var < 0) {
                var = 0;
            }
            return this.func_149745_a(random) * (var + 1);
        }
        return this.func_149745_a(random);
    }

    public SimpleBlock setFireSource(boolean fireSource) {
        this.fireSource = fireSource;
        return this;
    }

    public boolean isFireSource(World world, BlockPos pos, EnumFacing side) {
        return this.fireSource;
    }

    public SimpleBlock setIsLeaves(boolean isLeaves) {
        this.isLeaves = isLeaves;
        return this;
    }

    public boolean isLeaves(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.isLeaves;
    }

    public SimpleBlock setIsWood(boolean isWood) {
        this.isWood = isWood;
        return this;
    }

    public boolean isWood(IBlockAccess world, BlockPos pos) {
        return this.isWood;
    }

    public boolean isBeaconBase(IBlockAccess worldObj, BlockPos pos, BlockPos beaconPos) {
        return this.entry.getBeaconBase();
    }

    @Override
    public void setAdditionalProperties() {
        if (this.entry.getUnbreakable()) {
            this.func_149722_s();
        }
    }
}

