/*
 * Decompiled with CFR 0.152.
 */
package alexndr.api.content.blocks;

import alexndr.api.config.IConfigureBlockHelper;
import alexndr.api.config.types.ConfigBlock;
import alexndr.api.helpers.game.TooltipHelper;
import alexndr.api.logger.LogHelper;
import alexndr.api.registry.ContentCategories;
import alexndr.api.registry.Plugin;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SimpleDoor
extends BlockDoor
implements IConfigureBlockHelper<SimpleDoor> {
    protected Plugin plugin;
    protected Material material;
    protected ContentCategories.Block category;
    protected ConfigBlock entry;
    protected ResourceLocation ItemOfDoorResource;
    protected String name;

    public SimpleDoor(String name, Plugin plugin, Material materialIn, String itemOfBlockName, ContentCategories.Block category) {
        super(materialIn);
        this.name = name;
        this.plugin = plugin;
        this.material = materialIn;
        this.category = category;
        this.ItemOfDoorResource = new ResourceLocation(plugin.getModId(), itemOfBlockName);
        this.func_149663_c(name);
        this.setRegistryName(plugin.getModId(), name);
    }

    @SideOnly(value=Side.CLIENT)
    public void setCustomStateMapper() {
        StateMap doorMapper = new StateMap.Builder().func_178442_a(new IProperty[]{BlockDoor.field_176522_N}).func_178441_a();
        ModelLoader.setCustomStateMapper((Block)this, (IStateMapper)doorMapper);
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return new ItemStack(this.func_176509_j());
    }

    protected Item func_176509_j() {
        if (this.ItemOfDoorResource == null) {
            return null;
        }
        if (Item.field_150901_e.func_82594_a((Object)this.ItemOfDoorResource) == null) {
            LogHelper.severe(this.plugin.getName(), "Item of Door " + this.ItemOfDoorResource + " never initialized!");
        }
        return (Item)Item.field_150901_e.func_82594_a((Object)this.ItemOfDoorResource);
    }

    @Nullable
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return state.func_177229_b((IProperty)field_176523_O) == BlockDoor.EnumDoorHalf.UPPER ? null : this.func_176509_j();
    }

    @Override
    public ConfigBlock getConfigEntry() {
        return this.entry;
    }

    @Override
    public SimpleDoor setConfigEntry(ConfigBlock entry) {
        this.entry = entry;
        this.func_149711_c(entry.getHardness());
        this.func_149752_b(entry.getResistance());
        this.func_149715_a(entry.getLightValue());
        this.setHarvestLevel(entry.getHarvestTool(), entry.getHarvestLevel());
        this.setAdditionalProperties();
        return this;
    }

    @Override
    public SimpleDoor addToolTip(String toolTip) {
        TooltipHelper.addTooltipToBlock((Block)this, toolTip);
        return this;
    }

    @Override
    public void setAdditionalProperties() {
    }
}

