/*
 * Decompiled with CFR 0.152.
 */
package alexndr.api.core;

import alexndr.api.content.inventory.SimpleTab;
import alexndr.api.core.APISettings;
import alexndr.api.core.ModBlocks;
import alexndr.api.core.ProxyCommon;
import alexndr.api.helpers.events.CommonEventHelper;
import alexndr.api.helpers.game.OreGenerator;
import alexndr.api.helpers.game.TabHelper;
import alexndr.api.helpers.game.TestFurnaceGuiHandler;
import alexndr.api.logger.LogHelper;
import alexndr.api.registry.ContentCategories;
import alexndr.api.registry.ContentRegistry;
import alexndr.api.registry.Plugin;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;

@Mod(modid="simplecore", name="SimpleCore API", version="1.7.3.4", dependencies="", acceptedMinecraftVersions="[1.12,)", updateJSON="https://raw.githubusercontent.com/Sinhika/SimpleCore/1.12/update.json")
public class SimpleCoreAPI {
    @SidedProxy(clientSide="alexndr.api.core.ProxyClient", serverSide="alexndr.api.core.ProxyCommon")
    public static ProxyCommon proxy;
    @Mod.Instance
    public static SimpleCoreAPI instance;
    public static Plugin plugin;
    public static Plugin vanilla;
    private static boolean iconsSet;
    private static SimpleTab simpleBlocks;
    private static SimpleTab simpleDecorations;
    private static SimpleTab simpleMaterials;
    private static SimpleTab simpleTools;
    private static SimpleTab simpleCombat;
    private static SimpleTab simpleMachines;

    public SimpleCoreAPI() {
        FluidRegistry.enableUniversalBucket();
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        LogHelper.info("SimpleCore API Loading...");
        MinecraftForge.EVENT_BUS.register((Object)new CommonEventHelper());
        APISettings.createOrLoadSettings(event);
        LogHelper.loggerSetup();
        if (!APISettings.tabs) {
            this.addVanillaTabs();
        }
        try {
            ModBlocks.configureBlocks();
        }
        catch (Exception e) {
            LogHelper.severe("SimpleCore API", "Content pre-init failed. This is a serious problem!");
            e.printStackTrace();
        }
        proxy.preInit(event);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)new TestFurnaceGuiHandler());
        GameRegistry.registerWorldGenerator((IWorldGenerator)new OreGenerator(), (int)1);
        proxy.load(event);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        LogHelper.info("SimpleCore API Loading Complete!");
    }

    public static void tabPreInit() {
        LogHelper.verbose("Creating tabs");
        if (APISettings.tabs) {
            simpleBlocks = new SimpleTab(plugin, "SimpleBlocks", ContentCategories.CreativeTab.BLOCKS);
            if (APISettings.separateTabs) {
                simpleDecorations = new SimpleTab(plugin, "SimpleDecorations", ContentCategories.CreativeTab.DECORATIONS);
                simpleMaterials = new SimpleTab(plugin, "SimpleMaterials", ContentCategories.CreativeTab.MATERIALS);
                simpleTools = new SimpleTab(plugin, "SimpleTools", ContentCategories.CreativeTab.TOOLS);
                simpleCombat = new SimpleTab(plugin, "SimpleCombat", ContentCategories.CreativeTab.COMBAT);
                simpleMachines = new SimpleTab(plugin, "SimpleMachines", ContentCategories.CreativeTab.REDSTONE);
            }
        }
        TabHelper.setTabInitDone(true);
    }

    public static void setTabIcons(List<Item> iconItemsList) {
        if (!iconsSet) {
            iconsSet = true;
            if (APISettings.tabs) {
                simpleBlocks.setIcon(iconItemsList.get(0));
                if (APISettings.separateTabs) {
                    simpleDecorations.setIcon(iconItemsList.get(1));
                    simpleMaterials.setIcon(iconItemsList.get(2));
                    simpleTools.setIcon(iconItemsList.get(3));
                    simpleCombat.setIcon(iconItemsList.get(4));
                    simpleMachines.setIcon(iconItemsList.get(5));
                }
            }
        }
    }

    private void addVanillaTabs() {
        LogHelper.verbose("Adding vanilla tabs to ContentRegistry");
        ContentRegistry.registerPlugin(vanilla);
        ContentRegistry.registerTab(vanilla, CreativeTabs.field_78030_b, CreativeTabs.field_78030_b.func_78013_b(), ContentCategories.CreativeTab.GENERAL);
        ContentRegistry.registerTab(vanilla, CreativeTabs.field_78026_f, CreativeTabs.field_78026_f.func_78013_b(), ContentCategories.CreativeTab.OTHER);
        ContentRegistry.registerTab(vanilla, CreativeTabs.field_78038_k, CreativeTabs.field_78038_k.func_78013_b(), ContentCategories.CreativeTab.OTHER);
        ContentRegistry.registerTab(vanilla, CreativeTabs.field_78037_j, CreativeTabs.field_78037_j.func_78013_b(), ContentCategories.CreativeTab.COMBAT);
        ContentRegistry.registerTab(vanilla, CreativeTabs.field_78031_c, CreativeTabs.field_78031_c.func_78013_b(), ContentCategories.CreativeTab.DECORATIONS);
        ContentRegistry.registerTab(vanilla, CreativeTabs.field_78039_h, CreativeTabs.field_78039_h.func_78013_b(), ContentCategories.CreativeTab.OTHER);
        ContentRegistry.registerTab(vanilla, CreativeTabs.field_78035_l, CreativeTabs.field_78035_l.func_78013_b(), ContentCategories.CreativeTab.MATERIALS);
        ContentRegistry.registerTab(vanilla, CreativeTabs.field_78028_d, CreativeTabs.field_78028_d.func_78013_b(), ContentCategories.CreativeTab.REDSTONE);
        ContentRegistry.registerTab(vanilla, CreativeTabs.field_78040_i, CreativeTabs.field_78040_i.func_78013_b(), ContentCategories.CreativeTab.TOOLS);
        ContentRegistry.registerTab(vanilla, CreativeTabs.field_78029_e, CreativeTabs.field_78029_e.func_78013_b(), ContentCategories.CreativeTab.OTHER);
    }

    static {
        plugin = new Plugin("simplecore", "SimpleCore API");
        vanilla = new Plugin("minecraft", "Minecraft");
        iconsSet = false;
    }
}

