/*
 * Decompiled with CFR 0.152.
 */
package alexndr.api.helpers.game;

import com.google.common.base.Predicate;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class OreGenHelper
extends WorldGenerator {
    private Block blockToGenerate;
    private Block blockToReplace;
    private Predicate<IBlockState> replaceableOreGenBlock = BlockMatcher.func_177642_a((Block)Blocks.field_150348_b);
    private int blockToGenerateMeta;
    private int blockToReplaceMeta;
    private int veinSize;
    private boolean replaceOreGenBlocks = true;

    public OreGenHelper(Block blockToGenerate, Block blockToReplace, int veinSize) {
        this(blockToGenerate, 0, blockToReplace, 0, veinSize);
    }

    public OreGenHelper(Block blockToGenerate, int blockToGenerateMeta, Block blockToReplace, int blockToReplaceMeta, int veinSize) {
        this.blockToGenerate = blockToGenerate;
        this.blockToGenerateMeta = blockToGenerateMeta;
        this.blockToReplace = blockToReplace;
        this.blockToReplaceMeta = blockToReplaceMeta;
        this.veinSize = veinSize;
    }

    public OreGenHelper setReplaceableOreGenBlock(Block replaceableOreGenBlock) {
        this.replaceableOreGenBlock = BlockMatcher.func_177642_a((Block)replaceableOreGenBlock);
        return this;
    }

    public OreGenHelper setReplaceOreGenBlocks(boolean replaceOreGenBlocks) {
        this.replaceOreGenBlocks = replaceOreGenBlocks;
        return this;
    }

    public boolean func_180709_b(World worldIn, Random random, BlockPos blockpos) {
        float randFloat = random.nextFloat() * (float)Math.PI;
        double randXMax = (float)(blockpos.func_177958_n() + 8) + MathHelper.func_76126_a((float)randFloat) * (float)this.veinSize / 8.0f;
        double randXMin = (float)(blockpos.func_177958_n() + 8) - MathHelper.func_76126_a((float)randFloat) * (float)this.veinSize / 8.0f;
        double randZMax = (float)(blockpos.func_177952_p() + 8) + MathHelper.func_76126_a((float)randFloat) * (float)this.veinSize / 8.0f;
        double randZMin = (float)(blockpos.func_177952_p() + 8) - MathHelper.func_76126_a((float)randFloat) * (float)this.veinSize / 8.0f;
        double randYMax = blockpos.func_177956_o() + random.nextInt(3) - 2;
        double randYMin = blockpos.func_177956_o() + random.nextInt(3) - 2;
        for (int i = 0; i <= this.veinSize; ++i) {
            float ratio = (float)i / (float)this.veinSize;
            double randX = randXMax + (randXMin - randXMax) * (double)ratio;
            double randY = randYMax + (randYMin - randYMax) * (double)ratio;
            double randZ = randZMax + (randZMin - randZMax) * (double)ratio;
            double var1 = random.nextDouble() * (double)this.veinSize / 16.0;
            double var2 = (double)(MathHelper.func_76126_a((float)((float)Math.PI * ratio)) + 1.0f) * var1 + 1.0;
            double var3 = (double)(MathHelper.func_76126_a((float)((float)Math.PI * ratio)) + 1.0f) * var1 + 1.0;
            int chunkXMin = MathHelper.func_76128_c((double)(randX - var2 / 2.0));
            int chunkYMin = MathHelper.func_76128_c((double)(randY - var3 / 2.0));
            int chunkZMin = MathHelper.func_76128_c((double)(randZ - var2 / 2.0));
            int chunkXMax = MathHelper.func_76128_c((double)(randX + var2 / 2.0));
            int chunkYMax = MathHelper.func_76128_c((double)(randY + var3 / 2.0));
            int chunkZMax = MathHelper.func_76128_c((double)(randZ + var2 / 2.0));
            for (int chunkX = chunkXMin; chunkX <= chunkXMax; ++chunkX) {
                double var4 = ((double)chunkX + 0.5 - randX) / (var2 / 2.0);
                if (!(var4 * var4 < 1.0)) continue;
                for (int chunkY = chunkYMin; chunkY <= chunkYMax; ++chunkY) {
                    double var5 = ((double)chunkY + 0.5 - randY) / (var3 / 2.0);
                    if (!(var4 * var4 + var5 * var5 < 1.0)) continue;
                    for (int chunkZ = chunkZMin; chunkZ <= chunkZMax; ++chunkZ) {
                        BlockPos blockpos1;
                        IBlockState state;
                        double var6 = ((double)chunkZ + 0.5 - randZ) / (var2 / 2.0);
                        if (!(var4 * var4 + var5 * var5 + var6 * var6 < 1.0) || !(state = worldIn.func_180495_p(blockpos1 = new BlockPos(chunkX, chunkY, chunkZ))).func_177230_c().isReplaceableOreGen(state, (IBlockAccess)worldIn, blockpos1, this.replaceableOreGenBlock)) continue;
                        worldIn.func_180501_a(blockpos1, this.blockToGenerate.func_176194_O().func_177621_b(), 2);
                    }
                }
            }
        }
        return true;
    }
}

