/*
 * Decompiled with CFR 0.152.
 */
package mrthomas20121.tinkers_reforged.library;

import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import mrthomas20121.tinkers_reforged.library.ForgeUtils;
import mrthomas20121.tinkers_reforged.library.IManager;
import mrthomas20121.tinkers_reforged.library.IModule;
import mrthomas20121.tinkers_reforged.library.ModuleBase;
import mrthomas20121.tinkers_reforged.library.block.ReforgedBlockGlass;
import mrthomas20121.tinkers_reforged.library.block.ReforgedItemBlock;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.StringUtils;
import slimeknights.tconstruct.library.modifiers.Modifier;

public class Manager
extends IManager<ModuleBase> {
    private final List<String> alloys = new LinkedList<String>();
    private final List<Item> items = new LinkedList<Item>();
    private final List<Block> blocks = new LinkedList<Block>();
    private final List<Modifier> modifiers = new LinkedList<Modifier>();
    public CreativeTabs tab = new CreativeTabs("tinkers_reforged"){

        @Nonnull
        public ItemStack func_78016_d() {
            return new ItemStack(ForgeUtils.getItem("tinkers_reforged", "lavium_ingot"));
        }
    };

    public Manager() {
        super(new ResourceLocation("tinkers_reforged", "manager"));
    }

    @Override
    public void add(ModuleBase module) {
        if (this.isLoaded(module)) {
            this.value.add(module);
        }
    }

    public List<Item> getItems() {
        return this.items;
    }

    public List<Block> getBlocks() {
        return this.blocks;
    }

    public List<Modifier> getModifiers() {
        return this.modifiers;
    }

    @Override
    public boolean isLoaded(ModuleBase module) {
        return Loader.isModLoaded((String)module.getRegistryName().func_110624_b()) && module.canLoad();
    }

    @Override
    public ModuleBase get(int i) {
        return (ModuleBase)this.value.get(i);
    }

    @Override
    public void earlyPreInit() {
        this.value.forEach(IModule::earlyPreInit);
        this.value.forEach(module -> module.registerAlloys(this.alloys));
    }

    @Override
    public void preInit() {
        this.value.forEach(IModule::preInit);
    }

    @Override
    public void init() {
        this.alloys.forEach(alloy -> {
            OreDictionary.registerOre((String)("ingot" + this.cap((String)alloy)), (Item)ForgeUtils.getItem("tinkers_reforged", alloy + "_ingot"));
            OreDictionary.registerOre((String)("dust" + this.cap((String)alloy)), (Item)ForgeUtils.getItem("tinkers_reforged", alloy + "_dust"));
            OreDictionary.registerOre((String)("plate" + this.cap((String)alloy)), (Item)ForgeUtils.getItem("tinkers_reforged", alloy + "_plate"));
            OreDictionary.registerOre((String)("gear" + this.cap((String)alloy)), (Item)ForgeUtils.getItem("tinkers_reforged", alloy + "_gear"));
            OreDictionary.registerOre((String)("block" + this.cap((String)alloy)), (Block)ForgeUtils.getBlock("tinkers_reforged", alloy + "_block"));
        });
        this.value.forEach(IModule::init);
        this.value.forEach(moduleBase -> moduleBase.registerModifiers(this.modifiers));
    }

    @Override
    public void postInit() {
        this.value.forEach(IModule::postInit);
    }

    @Override
    public void registerRecipes(IForgeRegistry<IRecipe> r) {
        this.value.forEach(module -> module.registerRecipes(r));
    }

    @Override
    public void registerItems(RegistryEvent.Register<Item> event) {
        IForgeRegistry r = event.getRegistry();
        this.alloys.forEach(alloy -> {
            this.register((IForgeRegistry<Item>)r, new Item(), alloy + "_ingot");
            this.register((IForgeRegistry<Item>)r, new Item(), alloy + "_dust");
            this.register((IForgeRegistry<Item>)r, new Item(), alloy + "_plate");
            this.register((IForgeRegistry<Item>)r, new Item(), alloy + "_gear");
        });
        this.blocks.forEach(block -> r.register((IForgeRegistryEntry)new ReforgedItemBlock((Block)block)));
    }

    @Override
    public void registerBlocks(RegistryEvent.Register<Block> event) {
        IForgeRegistry r = event.getRegistry();
        this.alloys.forEach(alloy -> this.register((IForgeRegistry<Block>)r, new Block(Material.field_151573_f), alloy + "_block"));
        this.register((IForgeRegistry<Block>)r, (Block)new ReforgedBlockGlass(), "kovar_glass");
    }

    private void register(IForgeRegistry<Block> r, Block block, String name) {
        block.setRegistryName("tinkers_reforged", name);
        block.func_149663_c("tinkers_reforged." + name);
        block.func_149647_a(this.tab);
        r.register((IForgeRegistryEntry)block);
        this.blocks.add(block);
    }

    private void register(IForgeRegistry<Item> r, Item item, String name) {
        item.setRegistryName("tinkers_reforged", name);
        item.func_77655_b("tinkers_reforged." + name);
        item.func_77637_a(this.tab);
        r.register((IForgeRegistryEntry)item);
        this.items.add(item);
    }

    private String cap(String str) {
        String[] array = str.split("_");
        StringBuilder s = new StringBuilder();
        for (String string : array) {
            s.append(StringUtils.capitalize((String)string));
        }
        return s.toString();
    }
}

