/*
 * Decompiled with CFR 0.152.
 */
package mrthomas20121.tinkers_reforged.library.book;

import mrthomas20121.tinkers_reforged.config.TinkersReforgedConfig;
import mrthomas20121.tinkers_reforged.tools.Tools;
import net.minecraftforge.fml.common.Loader;
import slimeknights.mantle.client.book.data.BookData;
import slimeknights.mantle.client.book.data.PageData;
import slimeknights.mantle.client.book.data.SectionData;
import slimeknights.mantle.client.book.repository.FileRepository;
import slimeknights.tconstruct.library.book.content.ContentListing;
import slimeknights.tconstruct.library.book.sectiontransformer.SectionTransformer;
import slimeknights.tconstruct.library.tools.TinkerToolCore;

public class ToolsTransformer
extends SectionTransformer {
    public ToolsTransformer() {
        super("tools");
    }

    public void transform(BookData book, SectionData section) {
        if (TinkersReforgedConfig.SettingTools.enableTools) {
            if (TinkersReforgedConfig.SettingTools.enableGladius) {
                ToolsTransformer.addTool(section, (TinkerToolCore)Tools.gladius);
            }
            if (TinkersReforgedConfig.SettingTools.enableLightsword) {
                ToolsTransformer.addTool(section, (TinkerToolCore)Tools.swordLight);
            }
            if (Loader.isModLoaded((String)"atum") && TinkersReforgedConfig.SettingMaterials.modules.atum) {
                if (TinkersReforgedConfig.SettingTools.enableClub) {
                    ToolsTransformer.addTool(section, (TinkerToolCore)Tools.club);
                }
                if (TinkersReforgedConfig.SettingTools.enableGreatsword) {
                    ToolsTransformer.addTool(section, (TinkerToolCore)Tools.greatsword);
                }
                if (TinkersReforgedConfig.SettingTools.enableKhopesh) {
                    ToolsTransformer.addTool(section, (TinkerToolCore)Tools.khopesh);
                }
            }
            if (Loader.isModLoaded((String)"roots") && TinkersReforgedConfig.SettingMaterials.modules.roots && TinkersReforgedConfig.SettingTools.enableKnife) {
                ToolsTransformer.addTool(section, (TinkerToolCore)Tools.knife);
            }
            if (Loader.isModLoaded((String)"geolosys") && TinkersReforgedConfig.SettingTools.enableProPick) {
                ToolsTransformer.addTool(section, (TinkerToolCore)Tools.knife);
            }
        }
    }

    private static void addTool(SectionData section, TinkerToolCore tool) {
        ContentListing listing = (ContentListing)((PageData)section.pages.get((int)0)).content;
        PageData page = new PageData();
        page.source = new FileRepository("tinkers_reforged:book");
        page.parent = section;
        page.type = "tool";
        page.data = "tools/" + tool.getRegistryName().func_110623_a() + ".json";
        section.pages.add(page);
        page.load();
        listing.addEntry(tool.getLocalizedName(), page);
    }
}

