/*
 * Decompiled with CFR 0.152.
 */
package mrthomas20121.tinkers_reforged.library.trait;

import mrthomas20121.tinkers_reforged.library.potion.PotionRegistry;
import mrthomas20121.tinkers_reforged.library.trait.ReforgedTrait;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.tconstruct.library.tools.ToolCore;
import slimeknights.tconstruct.library.utils.TinkerUtil;
import slimeknights.tconstruct.library.utils.ToolHelper;

@Mod.EventBusSubscriber(modid="tinkers_reforged")
public class TraitManager {
    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void onTooltips(ItemTooltipEvent event) {
        ItemStack tool = event.getItemStack();
        EntityPlayer player = event.getEntityPlayer();
        if (TraitManager.isTool(tool) && !ToolHelper.isBroken((ItemStack)tool)) {
            TinkerUtil.getTraitsOrdered((ItemStack)tool).forEach(trait -> {
                if (trait instanceof ReforgedTrait) {
                    ((ReforgedTrait)((Object)trait)).onTooltip(tool, player, event.getToolTip());
                }
            });
        }
    }

    @SubscribeEvent
    public static void onBlockRightClick(PlayerInteractEvent.RightClickBlock event) {
        ItemStack tool = event.getItemStack();
        World world = event.getWorld();
        EntityPlayer player = event.getEntityPlayer();
        BlockPos pos = event.getPos();
        EnumHand hand = event.getHand();
        if (TraitManager.isTool(tool) && !ToolHelper.isBroken((ItemStack)tool)) {
            TinkerUtil.getTraitsOrdered((ItemStack)tool).forEach(trait -> {
                if (trait instanceof ReforgedTrait) {
                    ((ReforgedTrait)((Object)trait)).onBlockRightClick(tool, world, player, pos, hand);
                }
            });
        }
    }

    @SubscribeEvent
    public static void onItemRightClick(PlayerInteractEvent.RightClickItem event) {
        ItemStack tool = event.getItemStack();
        World world = event.getWorld();
        EntityPlayer player = event.getEntityPlayer();
        BlockPos pos = event.getPos();
        EnumHand hand = event.getHand();
        if (TraitManager.isTool(tool) && !ToolHelper.isBroken((ItemStack)tool)) {
            TinkerUtil.getTraitsOrdered((ItemStack)tool).forEach(trait -> {
                if (trait instanceof ReforgedTrait) {
                    ((ReforgedTrait)((Object)trait)).onItemRightClick(tool, world, player, pos, hand);
                }
            });
        }
    }

    @SubscribeEvent
    public static void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        ItemStack tool = event.getItemStack();
        World world = event.getWorld();
        EntityPlayer player = event.getEntityPlayer();
        BlockPos pos = event.getPos();
        Entity entity = event.getTarget();
        EnumHand hand = event.getHand();
        if (TraitManager.isTool(tool) && !ToolHelper.isBroken((ItemStack)tool)) {
            TinkerUtil.getTraitsOrdered((ItemStack)tool).forEach(trait -> {
                if (trait instanceof ReforgedTrait) {
                    ((ReforgedTrait)((Object)trait)).onEntityRightClick(tool, world, player, pos, entity, hand);
                }
            });
        }
    }

    @SubscribeEvent
    public static void onEntityAttack(LivingAttackEvent event) {
        ItemStack tool;
        Entity player = event.getSource().func_76346_g();
        EntityLivingBase target = event.getEntityLiving();
        DamageSource source = event.getSource();
        float amount = event.getAmount();
        if (player instanceof EntityPlayer && TraitManager.isTool(tool = ((EntityPlayer)player).func_184614_ca()) && !ToolHelper.isBroken((ItemStack)tool)) {
            TinkerUtil.getTraitsOrdered((ItemStack)tool).forEach(trait -> {
                if (trait instanceof ReforgedTrait) {
                    ((ReforgedTrait)((Object)trait)).onEntityAttack(tool, (EntityPlayer)player, target, source, amount, event);
                }
            });
        }
    }

    @SubscribeEvent
    public static void enderTeleportEvent(EnderTeleportEvent event) {
        if (event.isCanceled()) {
            return;
        }
        EntityLivingBase entity = event.getEntityLiving();
        if (entity.func_70644_a(PotionRegistry.ender)) {
            entity.func_70097_a(DamageSource.field_188407_q, entity.func_110143_aJ() / 4.0f);
        }
    }

    @SubscribeEvent
    public static void onPlayerHeal(LivingHealEvent event) {
        EntityLivingBase living = event.getEntityLiving();
        ItemStack tool = living.func_184614_ca();
        float healing = event.getAmount();
        if (living instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)living;
            if (TraitManager.isTool(tool) && !ToolHelper.isBroken((ItemStack)tool)) {
                TinkerUtil.getTraitsOrdered((ItemStack)tool).forEach(trait -> {
                    if (trait instanceof ReforgedTrait) {
                        ((ReforgedTrait)((Object)trait)).onPlayerHeal(tool, player, healing);
                    }
                });
            }
        } else if (TraitManager.isTool(tool) && !ToolHelper.isBroken((ItemStack)tool)) {
            TinkerUtil.getTraitsOrdered((ItemStack)tool).forEach(trait -> {
                if (trait instanceof ReforgedTrait) {
                    ((ReforgedTrait)((Object)trait)).onEntityHeal(tool, living, healing);
                }
            });
        }
    }

    private static boolean isTool(ItemStack stack) {
        return stack != null && stack.func_77973_b() instanceof ToolCore;
    }
}

