/*
 * Decompiled with CFR 0.152.
 */
package mrthomas20121.tinkers_reforged.modules;

import mrthomas20121.tinkers_reforged.Reference;
import mrthomas20121.tinkers_reforged.ReforgedTraits;
import mrthomas20121.tinkers_reforged.config.TinkersReforgedConfig;
import mrthomas20121.tinkers_reforged.library.ForgeUtils;
import mrthomas20121.tinkers_reforged.library.MaterialGen;
import mrthomas20121.tinkers_reforged.library.ModuleBase;
import mrthomas20121.tinkers_reforged.trait.TraitFiery;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.StringUtils;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.materials.BowMaterialStats;
import slimeknights.tconstruct.library.materials.ExtraMaterialStats;
import slimeknights.tconstruct.library.materials.HandleMaterialStats;
import slimeknights.tconstruct.library.materials.HeadMaterialStats;
import slimeknights.tconstruct.library.materials.IMaterialStats;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.traits.ITrait;
import slimeknights.tconstruct.tools.TinkerTraits;

public class MaterialsBlueSkies
extends ModuleBase {
    private final MaterialGen horizonnite = new MaterialGen("horizonite", 15891243, "Horizonite", 700);
    private final MaterialGen charoite = new MaterialGen("charoite", 10125242, "Charoite", 500, true);
    private final MaterialGen diopside = new MaterialGen("diopside", 5040201, "Diopside", 500, true);
    private final MaterialGen pyrope = new MaterialGen("pyrope", 14297150, "Pyrope", 500, true);
    private final MaterialGen turquoise = new MaterialGen("turquoise", 5957585, "Turquoise", 500, true);
    private final TraitFiery fiery = new TraitFiery();

    public MaterialsBlueSkies() {
        super(new ResourceLocation(Reference.blue_skies, "module"));
    }

    @Override
    public boolean canLoad() {
        return TinkersReforgedConfig.SettingMaterials.modules.blue_skies;
    }

    @Override
    public void preInit() {
        if (TinkersReforgedConfig.SettingMaterials.materials.horizonite) {
            this.horizonnite.preInit();
            this.horizonnite.getMaterial().addTrait((ITrait)TinkerTraits.autosmelt, "head");
            this.horizonnite.getMaterial().addTrait((ITrait)this.fiery);
            TinkerRegistry.addMaterial((Material)this.horizonnite.getMaterial());
            TinkerRegistry.addMaterialStats((Material)this.horizonnite.getMaterial(), (IMaterialStats)new HeadMaterialStats(200, 6.3f, 4.0f, 2), (IMaterialStats[])new IMaterialStats[]{new HandleMaterialStats(0.9f, 90), new ExtraMaterialStats(10), new BowMaterialStats(3.5f, 2.2f, 4.2f)});
        }
        if (TinkersReforgedConfig.SettingMaterials.materials.charoite) {
            this.charoite.preInit();
            this.charoite.getMaterial().addTrait((ITrait)TinkerTraits.lightweight);
            TinkerRegistry.addMaterial((Material)this.charoite.getMaterial());
            TinkerRegistry.addMaterialStats((Material)this.charoite.getMaterial(), (IMaterialStats)new HeadMaterialStats(200, 6.3f, 4.0f, 2), (IMaterialStats[])new IMaterialStats[]{new HandleMaterialStats(0.9f, 90), new ExtraMaterialStats(10), new BowMaterialStats(2.5f, 3.2f, 3.2f)});
        }
        if (TinkersReforgedConfig.SettingMaterials.materials.diopside) {
            this.diopside.preInit();
            this.diopside.getMaterial().addTrait((ITrait)TinkerTraits.sharp);
            TinkerRegistry.addMaterial((Material)this.diopside.getMaterial());
            TinkerRegistry.addMaterialStats((Material)this.diopside.getMaterial(), (IMaterialStats)new HeadMaterialStats(400, 8.0f, 8.0f, 2), (IMaterialStats[])new IMaterialStats[]{new HandleMaterialStats(1.2f, 90), new ExtraMaterialStats(100), new BowMaterialStats(3.0f, 8.2f, 2.1f)});
        }
        if (TinkersReforgedConfig.SettingMaterials.materials.pyrope) {
            this.pyrope.preInit();
            this.pyrope.getMaterial().addTrait((ITrait)ReforgedTraits.fast);
            TinkerRegistry.addMaterial((Material)this.pyrope.getMaterial());
            TinkerRegistry.addMaterialStats((Material)this.pyrope.getMaterial(), (IMaterialStats)new HeadMaterialStats(200, 6.3f, 4.0f, 2), (IMaterialStats[])new IMaterialStats[]{new HandleMaterialStats(0.9f, 90), new ExtraMaterialStats(10), new BowMaterialStats(3.5f, 2.2f, 4.2f)});
        }
        if (TinkersReforgedConfig.SettingMaterials.materials.turquoise) {
            this.turquoise.preInit();
            this.turquoise.getMaterial().addTrait((ITrait)TinkerTraits.fractured);
            TinkerRegistry.addMaterial((Material)this.turquoise.getMaterial());
            TinkerRegistry.addMaterialStats((Material)this.turquoise.getMaterial(), (IMaterialStats)new HeadMaterialStats(200, 6.3f, 4.0f, 2), (IMaterialStats[])new IMaterialStats[]{new HandleMaterialStats(0.9f, 90), new ExtraMaterialStats(10), new BowMaterialStats(3.5f, 2.2f, 4.2f)});
        }
    }

    @Override
    public void init() {
        String[] gems;
        for (String gem : gems = new String[]{"pyrope", "turquoise", "charoite", "diopside"}) {
            OreDictionary.registerOre((String)("gem" + StringUtils.capitalize((String)gem)), (Item)ForgeUtils.getItem(Reference.blue_skies, gem.equals("charoite") ? gem : gem + "_gem"));
            OreDictionary.registerOre((String)("ore" + StringUtils.capitalize((String)gem)), (Block)ForgeUtils.getBlock(Reference.blue_skies, "everdawn_" + gem + "_ore"));
            OreDictionary.registerOre((String)("ore" + StringUtils.capitalize((String)gem)), (Block)ForgeUtils.getBlock(Reference.blue_skies, "everbright_" + gem + "_ore"));
            OreDictionary.registerOre((String)("block" + StringUtils.capitalize((String)gem)), (Block)ForgeUtils.getBlock(Reference.blue_skies, gem + "_block"));
        }
        OreDictionary.registerOre((String)"ingotHorizonite", (Item)ForgeUtils.getItem(Reference.blue_skies, "horizonite_ingot"));
        OreDictionary.registerOre((String)"oreHorizonite", (Block)ForgeUtils.getBlock(Reference.blue_skies, "horizonite_ore"));
        OreDictionary.registerOre((String)"blockHorizonnite", (Block)ForgeUtils.getBlock(Reference.blue_skies, "horizonite_block"));
        if (TinkersReforgedConfig.SettingMaterials.materials.horizonite) {
            this.horizonnite.init();
        }
        if (TinkersReforgedConfig.SettingMaterials.materials.charoite) {
            this.charoite.init();
        }
        if (TinkersReforgedConfig.SettingMaterials.materials.diopside) {
            this.diopside.init();
        }
        if (TinkersReforgedConfig.SettingMaterials.materials.pyrope) {
            this.pyrope.init();
        }
        if (TinkersReforgedConfig.SettingMaterials.materials.turquoise) {
            this.turquoise.init();
        }
    }
}

