/*
 * Decompiled with CFR 0.152.
 */
package mrthomas20121.tinkers_reforged.modules;

import mrthomas20121.tinkers_reforged.Reference;
import mrthomas20121.tinkers_reforged.ReforgedTraits;
import mrthomas20121.tinkers_reforged.compat.BotaniaCompat;
import mrthomas20121.tinkers_reforged.config.TinkersReforgedConfig;
import mrthomas20121.tinkers_reforged.library.ForgeUtils;
import mrthomas20121.tinkers_reforged.library.ModuleBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.oredict.OreDictionary;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.materials.BowMaterialStats;
import slimeknights.tconstruct.library.materials.ExtraMaterialStats;
import slimeknights.tconstruct.library.materials.HandleMaterialStats;
import slimeknights.tconstruct.library.materials.HeadMaterialStats;
import slimeknights.tconstruct.library.materials.IMaterialStats;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.tools.IToolPart;
import slimeknights.tconstruct.library.traits.ITrait;
import slimeknights.tconstruct.tools.TinkerTraits;

public class MaterialsBotania
extends ModuleBase {
    private final Material manasteel = new Material("ref_manasteel", 3377663);
    private final Material livingwood = new Material("ref_livingwood", 3019014);
    private final Material livingrock = new Material("ref_livingrock", 0xCCCEBC);
    private final Material dreamwood = new Material("ref_dreamwood", 10927286);

    public MaterialsBotania() {
        super(new ResourceLocation(Reference.botania, "module"));
    }

    @Override
    public boolean canLoad() {
        return TinkersReforgedConfig.SettingMaterials.modules.botania;
    }

    @Override
    public void preInit() {
        if (TinkersReforgedConfig.SettingMaterials.materials.manasteel) {
            this.manasteel.addTrait((ITrait)ReforgedTraits.manaInfusion, "head");
            this.manasteel.addTrait((ITrait)ReforgedTraits.manaBoost);
            TinkerRegistry.addMaterial((Material)this.manasteel);
            TinkerRegistry.addMaterialStats((Material)this.manasteel, (IMaterialStats)new HeadMaterialStats(204, 6.0f, 4.0f, 2), (IMaterialStats[])new IMaterialStats[]{new HandleMaterialStats(1.2f, 9), new ExtraMaterialStats(50), new BowMaterialStats(0.5f, 1.4f, 7.0f)});
        }
        if (TinkersReforgedConfig.SettingMaterials.materials.livingwood) {
            this.livingwood.addTrait((ITrait)ReforgedTraits.enchantedWood);
            TinkerRegistry.addMaterial((Material)this.livingwood);
            TinkerRegistry.addMaterialStats((Material)this.livingwood, (IMaterialStats)new HeadMaterialStats(200, 4.0f, 4.0f, 1), (IMaterialStats[])new IMaterialStats[]{new HandleMaterialStats(1.2f, 0), new ExtraMaterialStats(50), new BowMaterialStats(2.0f, 1.7f, 5.0f)});
        }
        if (TinkersReforgedConfig.SettingMaterials.materials.livingrock) {
            this.livingrock.addTrait((ITrait)ReforgedTraits.living);
            TinkerRegistry.addMaterial((Material)this.livingrock);
            TinkerRegistry.addMaterialStats((Material)this.livingrock, (IMaterialStats)new HeadMaterialStats(200, 4.0f, 4.0f, 1), (IMaterialStats[])new IMaterialStats[]{new HandleMaterialStats(1.2f, 0), new ExtraMaterialStats(50), new BowMaterialStats(3.0f, 1.7f, 3.0f)});
        }
        if (TinkersReforgedConfig.SettingMaterials.materials.dreamwood) {
            this.dreamwood.addTrait((ITrait)TinkerTraits.ecological);
            this.dreamwood.addTrait((ITrait)ReforgedTraits.enchantedWood, "head");
            TinkerRegistry.addMaterial((Material)this.dreamwood);
            TinkerRegistry.addMaterialStats((Material)this.dreamwood, (IMaterialStats)new HeadMaterialStats(200, 4.0f, 4.0f, 2), (IMaterialStats[])new IMaterialStats[]{new HandleMaterialStats(1.3f, 0), new ExtraMaterialStats(50), new BowMaterialStats(3.0f, 1.7f, 3.0f)});
        }
    }

    @Override
    public void init() {
        if (TinkersReforgedConfig.SettingMaterials.materials.manasteel) {
            this.manasteel.setRepresentativeItem("ingotManasteel");
            this.manasteel.addItemIngot("ingotManasteel");
            this.manasteel.addCommonItems("ManaSteel");
            for (IToolPart part : TinkerRegistry.getToolParts()) {
                if (!part.canUseMaterial(this.manasteel) || !part.canBeCasted() && !part.canBeCrafted()) continue;
                BotaniaCompat.addManaInfusionRecipe(part.getItemstackWithMaterial(this.manasteel), part.getItemstackWithMaterial(TinkerRegistry.getMaterial((String)TinkersReforgedConfig.SettingGeneral.mods.manasteel.material)), TinkersReforgedConfig.SettingGeneral.mods.manasteel.cost);
            }
            OreDictionary.registerOre((String)"blockManasteel", (ItemStack)new ItemStack(ForgeUtils.getItem(Reference.botania, "storage"), 1, 0));
        }
        if (TinkersReforgedConfig.SettingMaterials.materials.livingwood) {
            this.livingwood.addItem(ForgeUtils.getBlock(Reference.botania, "livingwood"), 1);
            this.livingwood.setRepresentativeItem(ForgeUtils.getBlock(Reference.botania, "livingwood"));
            this.livingwood.setCraftable(true);
        }
        if (TinkersReforgedConfig.SettingMaterials.materials.livingrock) {
            this.livingrock.addItem(ForgeUtils.getBlock(Reference.botania, "livingrock"), 1);
            this.livingrock.setRepresentativeItem(ForgeUtils.getBlock(Reference.botania, "livingrock"));
            this.livingrock.setCraftable(true);
        }
        if (TinkersReforgedConfig.SettingMaterials.materials.dreamwood) {
            this.dreamwood.setCraftable(true);
            this.dreamwood.addItem(ForgeUtils.getBlock(Reference.botania, "dreamwood"), 1);
            this.dreamwood.setRepresentativeItem(ForgeUtils.getBlock(Reference.botania, "dreamwood"));
        }
    }
}

