/*
 * Decompiled with CFR 0.152.
 */
package mrthomas20121.tinkers_reforged.modules;

import mrthomas20121.tinkers_reforged.Reference;
import mrthomas20121.tinkers_reforged.ReforgedTraits;
import mrthomas20121.tinkers_reforged.compat.MekanismCompat;
import mrthomas20121.tinkers_reforged.config.TinkersReforgedConfig;
import mrthomas20121.tinkers_reforged.library.MaterialGen;
import mrthomas20121.tinkers_reforged.library.ModuleBase;
import net.minecraft.util.ResourceLocation;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.materials.BowMaterialStats;
import slimeknights.tconstruct.library.materials.ExtraMaterialStats;
import slimeknights.tconstruct.library.materials.HandleMaterialStats;
import slimeknights.tconstruct.library.materials.HeadMaterialStats;
import slimeknights.tconstruct.library.materials.IMaterialStats;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.tools.IToolPart;
import slimeknights.tconstruct.library.traits.ITrait;
import slimeknights.tconstruct.tools.TinkerMaterials;
import slimeknights.tconstruct.tools.TinkerTraits;

public class MaterialsMekanism
extends ModuleBase {
    private final MaterialGen osmium = new MaterialGen("osmium", 8359602, "Osmium", 700);
    private final Material refined_obsidian = new Material("ref_refined_obsidian", 4601699);
    private final Material refined_glowstone = new Material("ref_refined_glowstone", 15386665);

    public MaterialsMekanism() {
        super(new ResourceLocation(Reference.mekanism, "module"));
    }

    @Override
    public boolean canLoad() {
        return TinkersReforgedConfig.SettingMaterials.modules.mekanism;
    }

    @Override
    public void preInit() {
        if (TinkersReforgedConfig.SettingMaterials.materials.osmium) {
            this.osmium.preInit();
            this.osmium.getMaterial().addTrait((ITrait)TinkerTraits.established, "head");
            this.osmium.getMaterial().addTrait((ITrait)TinkerTraits.dense);
            TinkerRegistry.addMaterial((Material)this.osmium.getMaterial());
            TinkerRegistry.addMaterialStats((Material)this.osmium.getMaterial(), (IMaterialStats)new HeadMaterialStats(410, 5.5f, 5.5f, 2), (IMaterialStats[])new IMaterialStats[]{new HandleMaterialStats(1.2f, 80), new ExtraMaterialStats(50), new BowMaterialStats(2.9f, 7.0f, 5.1f)});
        }
        if (TinkersReforgedConfig.SettingMaterials.materials.refined_obsidian) {
            this.refined_obsidian.addTrait((ITrait)ReforgedTraits.soft, "head");
            this.refined_obsidian.addTrait((ITrait)TinkerTraits.duritos);
            TinkerRegistry.addMaterial((Material)this.refined_obsidian);
            TinkerRegistry.addMaterialStats((Material)this.refined_obsidian, (IMaterialStats)new HeadMaterialStats(550, 6.5f, 6.5f, 3), (IMaterialStats[])new IMaterialStats[]{new HandleMaterialStats(1.2f, 100), new ExtraMaterialStats(50), new BowMaterialStats(3.2f, 5.0f, 6.1f)});
        }
        if (TinkersReforgedConfig.SettingMaterials.materials.refined_glowstone) {
            this.refined_glowstone.addTrait((ITrait)ReforgedTraits.overHealing, "head");
            this.refined_glowstone.addTrait((ITrait)ReforgedTraits.blessedSyringe);
            TinkerRegistry.addMaterial((Material)this.refined_glowstone);
            TinkerRegistry.addMaterialStats((Material)this.refined_glowstone, (IMaterialStats)new HeadMaterialStats(550, 6.5f, 6.5f, 3), (IMaterialStats[])new IMaterialStats[]{new HandleMaterialStats(1.2f, 100), new ExtraMaterialStats(50), new BowMaterialStats(3.2f, 5.0f, 6.1f)});
        }
    }

    @Override
    public void init() {
        if (TinkersReforgedConfig.SettingMaterials.materials.osmium) {
            this.osmium.init();
        }
        if (TinkersReforgedConfig.SettingMaterials.materials.refined_obsidian) {
            this.refined_obsidian.addCommonItems("RefinedObsidian");
            this.refined_obsidian.setRepresentativeItem("ingotRefinedObsidian");
            for (IToolPart part : TinkerRegistry.getToolParts()) {
                if (!part.canUseMaterial(this.refined_obsidian) || !part.canBeCasted() && !part.canBeCrafted()) continue;
                MekanismCompat.addInfusionRecipe("DIAMOND", 10, part.getItemstackWithMaterial(TinkerMaterials.obsidian), part.getItemstackWithMaterial(this.refined_obsidian));
            }
        }
        if (TinkersReforgedConfig.SettingMaterials.materials.refined_glowstone) {
            this.refined_glowstone.setRepresentativeItem("ingotRefinedGlowstone");
            this.refined_glowstone.addCommonItems("RefinedGlowstone");
            for (IToolPart part : TinkerRegistry.getToolParts()) {
                if (!part.canUseMaterial(this.refined_glowstone) || !part.canBeCasted() && !part.canBeCrafted()) continue;
                MekanismCompat.addOsmiumCompressorRecipe(part.getItemstackWithMaterial(TinkerRegistry.getMaterial((String)"ref_glowstone")), part.getItemstackWithMaterial(this.refined_glowstone));
            }
        }
    }
}

