/*
 * Decompiled with CFR 0.152.
 */
package mrthomas20121.tinkers_reforged.proxy;

import mrthomas20121.tinkers_reforged.TinkersReforged;
import mrthomas20121.tinkers_reforged.config.TinkersReforgedConfig;
import mrthomas20121.tinkers_reforged.library.book.ModifiersTransformer;
import mrthomas20121.tinkers_reforged.library.book.ToolsTransformer;
import mrthomas20121.tinkers_reforged.proxy.CommonProxy;
import mrthomas20121.tinkers_reforged.tools.Tools;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import slimeknights.mantle.client.book.BookTransformer;
import slimeknights.tconstruct.common.ModelRegisterUtil;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.TinkerRegistryClient;
import slimeknights.tconstruct.library.book.TinkerBook;
import slimeknights.tconstruct.library.client.ToolBuildGuiInfo;
import slimeknights.tconstruct.library.modifiers.IModifier;
import slimeknights.tconstruct.library.tinkering.TinkersItem;
import slimeknights.tconstruct.library.tools.ToolCore;

@Mod.EventBusSubscriber(value={Side.CLIENT}, modid="tinkers_reforged")
public class ClientProxy
extends CommonProxy {
    @Override
    public void preInit(FMLPreInitializationEvent e) {
        super.preInit(e);
    }

    @Override
    public void init(FMLInitializationEvent e) {
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        TinkerRegistry.getAllMaterials().forEach(material -> {
            if (material.getIdentifier().contains("ref_")) {
                material.setRenderInfo(material.materialTextColor);
            }
        });
    }

    @Override
    public <T extends Item> void registerToolPartModel(T part) {
        ModelRegisterUtil.registerPartModel(part);
    }

    @Override
    public void registerModifierModel(IModifier mod, ResourceLocation rl) {
        ModelRegisterUtil.registerModifierModel((IModifier)mod, (ResourceLocation)rl);
    }

    @Override
    public void registerToolCrafting() {
        if (Tools.gladius != null) {
            ToolBuildGuiInfo gladiusGui = ToolBuildGuiInfo.default3Part((TinkersItem)Tools.gladius);
            TinkerRegistryClient.addToolBuilding((ToolBuildGuiInfo)gladiusGui);
        }
        if (Tools.swordLight != null) {
            ToolBuildGuiInfo lightsword_gui = ToolBuildGuiInfo.default3Part((TinkersItem)Tools.swordLight);
            TinkerRegistryClient.addToolBuilding((ToolBuildGuiInfo)lightsword_gui);
        }
        if (Tools.knife != null) {
            ToolBuildGuiInfo runedKnifeGui = ToolBuildGuiInfo.default3Part((TinkersItem)Tools.knife);
            TinkerRegistryClient.addToolBuilding((ToolBuildGuiInfo)runedKnifeGui);
        }
        if (Tools.club != null) {
            ToolBuildGuiInfo clubGui = new ToolBuildGuiInfo((TinkersItem)Tools.club);
            clubGui.addSlotPosition(12, 62);
            clubGui.addSlotPosition(30, 44);
            TinkerRegistryClient.addToolBuilding((ToolBuildGuiInfo)clubGui);
        }
        if (Tools.greatsword != null) {
            ToolBuildGuiInfo greatSwordGui = ToolBuildGuiInfo.default3Part((TinkersItem)Tools.greatsword);
            TinkerRegistryClient.addToolBuilding((ToolBuildGuiInfo)greatSwordGui);
        }
        if (Tools.khopesh != null) {
            ToolBuildGuiInfo khopeshGui = ToolBuildGuiInfo.default3Part((TinkersItem)Tools.khopesh);
            TinkerRegistryClient.addToolBuilding((ToolBuildGuiInfo)khopeshGui);
        }
    }

    @Override
    public void registerBookData() {
        TinkerBook.INSTANCE.addTransformer((BookTransformer)new ModifiersTransformer());
        if (TinkersReforgedConfig.SettingTools.enableTools) {
            TinkerBook.INSTANCE.addTransformer((BookTransformer)new ToolsTransformer());
        }
    }

    @Override
    public void registerToolModel(ToolCore tc) {
        ModelRegisterUtil.registerToolModel((ToolCore)tc);
    }

    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent event) {
        for (Item item : TinkersReforged.manager.getItems()) {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName(), "normal"));
        }
        for (Block block : TinkersReforged.manager.getBlocks()) {
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)block), (int)0, (ModelResourceLocation)new ModelResourceLocation(block.getRegistryName(), "normal"));
        }
        Tools.getTinkerModifiers().forEach(modifier -> TinkersReforged.proxy.registerModifierModel((IModifier)modifier, new ResourceLocation("tinkers_reforged", "models/item/modifiers/" + modifier.getIdentifier())));
        TinkersReforged.manager.getModifiers().forEach(modifier -> TinkersReforged.proxy.registerModifierModel((IModifier)modifier, new ResourceLocation("tinkers_reforged", "models/item/modifiers/" + modifier.getIdentifier())));
    }
}

