/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.vintagefix.stitcher.packing2d;

import java.util.ArrayList;
import java.util.List;
import org.embeddedt.vintagefix.stitcher.Rect2D;
import org.embeddedt.vintagefix.stitcher.packing2d.Packer;
import org.embeddedt.vintagefix.stitcher.packing2d.StripLevel;

class PackerFFDH<T extends Rect2D>
extends Packer<T> {
    private final List<StripLevel> levels = new ArrayList<StripLevel>(1);
    private int top = 0;

    public PackerFFDH(int stripWidth, List<T> rectangles) {
        super(stripWidth, rectangles);
    }

    @Override
    public List<T> pack() {
        this.sortByNonIncreasingHeight(this.rectangles);
        for (Rect2D r : this.rectangles) {
            boolean fitsOnALevel = false;
            for (int i = 0; i < this.levels.size(); ++i) {
                StripLevel level = this.levels.get(i);
                fitsOnALevel = level.checkFitRectangle(r);
                if (!fitsOnALevel) continue;
                StripLevel newStrip = level.fitRectangle(r);
                if (newStrip == null) break;
                this.levels.add(0, newStrip);
                break;
            }
            if (fitsOnALevel) continue;
            StripLevel level = new StripLevel(this.stripWidth, this.top);
            level.fitRectangle(r);
            this.levels.add(level);
            this.top += r.height;
        }
        return this.rectangles;
    }
}

