/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.domumornamentum.block.decorative;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import com.ldtteam.domumornamentum.block.AbstractBlock;
import com.ldtteam.domumornamentum.block.ICachedItemGroupBlock;
import com.ldtteam.domumornamentum.block.IMateriallyTexturedBlock;
import com.ldtteam.domumornamentum.block.IMateriallyTexturedBlockComponent;
import com.ldtteam.domumornamentum.block.components.SimpleRetexturableComponent;
import com.ldtteam.domumornamentum.block.types.PillarShapeType;
import com.ldtteam.domumornamentum.client.model.data.MaterialTextureData;
import com.ldtteam.domumornamentum.entity.block.MateriallyTexturedBlockEntity;
import com.ldtteam.domumornamentum.recipe.ModRecipeSerializers;
import com.ldtteam.domumornamentum.tag.ModTags;
import com.ldtteam.domumornamentum.util.BlockUtils;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PillarBlock
extends AbstractBlock<PillarBlock>
implements IMateriallyTexturedBlock,
ICachedItemGroupBlock,
EntityBlock {
    public static final List<IMateriallyTexturedBlockComponent> COMPONENTS = ImmutableList.builder().add((Object)new SimpleRetexturableComponent(new ResourceLocation("block/oak_planks"), ModTags.PILLAR_MATERIALS, Blocks.f_50705_)).build();
    private final List<ItemStack> fillItemGroupCache = Lists.newArrayList();
    private static final VoxelShape PILLAR = Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    private static final float BLOCK_HARDNESS = 3.0f;
    private static final float RESISTANCE = 1.0f;
    private static final EnumProperty<PillarShapeType> column = EnumProperty.m_61587_((String)"column", PillarShapeType.class);

    public PillarBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60913_(3.0f, 1.0f));
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(column, (Comparable)((Object)PillarShapeType.FULL_PILLAR)));
    }

    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return PILLAR;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{column});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Level level = context.m_43725_();
        BlockPos blockPos = context.m_8083_();
        BlockPos blockAbove = blockPos.m_7494_();
        BlockPos blockBelow = blockPos.m_7495_();
        BlockState stateAbove = level.m_8055_(blockAbove);
        BlockState stateBelow = level.m_8055_(blockBelow);
        Boolean base = this.isMatchingPillar(stateBelow);
        Boolean capital = this.isMatchingPillar(stateAbove);
        if (base.booleanValue()) {
            this.updateBelow(level, blockBelow, stateBelow);
        }
        if (capital.booleanValue()) {
            this.updateAbove(level, blockAbove, stateAbove);
        }
        return this.updateShape(this.m_49966_(), base, capital);
    }

    public boolean onDestroyedByPlayer(BlockState state, Level world, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        Comparable column_property = state.m_61143_(column);
        if (column_property == PillarShapeType.PILLAR_COLUMN) {
            if (this.isMatchingPillar(world.m_8055_(pos.m_7494_())) && world.m_8055_(pos.m_7494_()).m_61143_(column) == PillarShapeType.PILLAR_COLUMN) {
                world.m_46597_(pos.m_7494_(), (BlockState)state.m_61124_(column, (Comparable)((Object)PillarShapeType.PILLAR_BASE)));
            } else if (this.isMatchingPillar(world.m_8055_(pos.m_7494_()))) {
                world.m_46597_(pos.m_7494_(), (BlockState)state.m_61124_(column, (Comparable)((Object)PillarShapeType.FULL_PILLAR)));
            }
            if (this.isMatchingPillar(world.m_8055_(pos.m_7495_())) && world.m_8055_(pos.m_7495_()).m_61143_(column) == PillarShapeType.PILLAR_COLUMN) {
                world.m_46597_(pos.m_7495_(), (BlockState)state.m_61124_(column, (Comparable)((Object)PillarShapeType.PILLAR_CAPITAL)));
            } else if (this.isMatchingPillar(world.m_8055_(pos.m_7495_()))) {
                world.m_46597_(pos.m_7495_(), (BlockState)state.m_61124_(column, (Comparable)((Object)PillarShapeType.FULL_PILLAR)));
            }
        }
        if (this.isMatchingPillar(world.m_8055_(pos.m_7494_())) && column_property == PillarShapeType.PILLAR_BASE) {
            if (world.m_8055_(pos.m_7494_()).m_61143_(column) == PillarShapeType.PILLAR_COLUMN) {
                world.m_46597_(pos.m_7494_(), (BlockState)state.m_61124_(column, (Comparable)((Object)PillarShapeType.PILLAR_BASE)));
            } else {
                world.m_46597_(pos.m_7494_(), (BlockState)state.m_61124_(column, (Comparable)((Object)PillarShapeType.FULL_PILLAR)));
            }
        }
        if (this.isMatchingPillar(world.m_8055_(pos.m_7495_())) && column_property == PillarShapeType.PILLAR_CAPITAL) {
            if (world.m_8055_(pos.m_7495_()).m_61143_(column) == PillarShapeType.PILLAR_COLUMN) {
                world.m_46597_(pos.m_7495_(), (BlockState)state.m_61124_(column, (Comparable)((Object)PillarShapeType.PILLAR_CAPITAL)));
            } else {
                world.m_46597_(pos.m_7495_(), (BlockState)state.m_61124_(column, (Comparable)((Object)PillarShapeType.FULL_PILLAR)));
            }
        }
        return super.onDestroyedByPlayer(state, world, pos, player, willHarvest, fluid);
    }

    private void updateBelow(Level level, BlockPos blockPos, BlockState state) {
        BlockPos checkBelow = blockPos.m_7495_();
        if (this.isMatchingPillar(level.m_8055_(checkBelow))) {
            level.m_46597_(blockPos, (BlockState)state.m_61124_(column, (Comparable)((Object)PillarShapeType.PILLAR_COLUMN)));
        } else {
            level.m_46597_(blockPos, (BlockState)state.m_61124_(column, (Comparable)((Object)PillarShapeType.PILLAR_BASE)));
        }
    }

    private void updateAbove(Level level, BlockPos blockPos, BlockState state) {
        BlockPos checkAbove = blockPos.m_7494_();
        if (this.isMatchingPillar(level.m_8055_(checkAbove))) {
            level.m_46597_(blockPos, (BlockState)state.m_61124_(column, (Comparable)((Object)PillarShapeType.PILLAR_COLUMN)));
        } else {
            level.m_46597_(blockPos, (BlockState)state.m_61124_(column, (Comparable)((Object)PillarShapeType.PILLAR_CAPITAL)));
        }
    }

    private BlockState updateShape(BlockState blockState, Boolean base, Boolean capital) {
        if (this.isMatchingPillar(blockState)) {
            if (base.booleanValue() && capital.booleanValue()) {
                return (BlockState)blockState.m_61124_(column, (Comparable)((Object)PillarShapeType.PILLAR_COLUMN));
            }
            if (!base.booleanValue() && capital.booleanValue()) {
                return (BlockState)blockState.m_61124_(column, (Comparable)((Object)PillarShapeType.PILLAR_BASE));
            }
            if (base.booleanValue() && !capital.booleanValue()) {
                return (BlockState)blockState.m_61124_(column, (Comparable)((Object)PillarShapeType.PILLAR_CAPITAL));
            }
            blockState.m_61124_(column, (Comparable)((Object)PillarShapeType.FULL_PILLAR));
        }
        return blockState;
    }

    private boolean isMatchingPillar(@NotNull BlockState state) {
        return state.m_60734_() == this;
    }

    @NotNull
    public List<IMateriallyTexturedBlockComponent> getComponents() {
        return COMPONENTS;
    }

    public void m_49811_(@NotNull CreativeModeTab group, @NotNull NonNullList<ItemStack> items) {
        if (!this.fillItemGroupCache.isEmpty()) {
            items.addAll(this.fillItemGroupCache);
            return;
        }
        try {
            ItemStack result = new ItemStack((ItemLike)this);
            this.fillItemGroupCache.add(result);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        items.addAll(this.fillItemGroupCache);
    }

    public void m_6402_(@NotNull Level worldIn, @NotNull BlockPos pos, @NotNull BlockState state, @Nullable LivingEntity placer, @NotNull ItemStack stack) {
        super.m_6402_(worldIn, pos, state, placer, stack);
        CompoundTag textureData = stack.m_41698_("textureData");
        BlockEntity tileEntity = worldIn.m_7702_(pos);
        if (tileEntity instanceof MateriallyTexturedBlockEntity) {
            ((MateriallyTexturedBlockEntity)tileEntity).updateTextureDataWith(MaterialTextureData.deserializeFromNBT(textureData));
        }
    }

    @Nullable
    public BlockEntity m_142194_(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        return new MateriallyTexturedBlockEntity(blockPos, blockState);
    }

    @Override
    public void resetCache() {
        this.fillItemGroupCache.clear();
    }

    @NotNull
    public List<ItemStack> m_7381_(@NotNull BlockState state, @NotNull LootContext.Builder builder) {
        return BlockUtils.getMaterializedItemStack(builder);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        return BlockUtils.getMaterializedItemStack((Entity)player, world, pos);
    }

    @Override
    @NotNull
    public Block getBlock() {
        return this;
    }

    @Override
    @NotNull
    public Collection<FinishedRecipe> getValidCutterRecipes() {
        return Lists.newArrayList((Object[])new FinishedRecipe[]{new FinishedRecipe(){

            public void m_7917_(@NotNull JsonObject json) {
                json.addProperty("count", (Number)(COMPONENTS.size() * 3));
            }

            @NotNull
            public ResourceLocation m_6445_() {
                return Objects.requireNonNull(PillarBlock.this.getRegistryName(PillarBlock.this.getBlock()));
            }

            @NotNull
            public RecipeSerializer<?> m_6637_() {
                return (RecipeSerializer)ModRecipeSerializers.ARCHITECTS_CUTTER.get();
            }

            @Nullable
            public JsonObject m_5860_() {
                return null;
            }

            @Nullable
            public ResourceLocation m_6448_() {
                return null;
            }
        }});
    }
}

