/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.domumornamentum.client.model.baked;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import com.ldtteam.domumornamentum.client.model.baked.RetexturedBakedModelBuilder;
import com.ldtteam.domumornamentum.client.model.baked.SpecificRenderTypeBakedModelWrapper;
import com.ldtteam.domumornamentum.client.model.data.MaterialTextureData;
import com.ldtteam.domumornamentum.client.model.properties.ModProperties;
import com.ldtteam.domumornamentum.util.MaterialTextureDataUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.ChunkRenderTypeSet;
import net.minecraftforge.client.model.data.ModelData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MateriallyTexturedBakedModel
implements BakedModel {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final RandomSource RANDOM = RandomSource.m_216327_();
    private static final ChunkRenderTypeSet SOLID_ONLY = ChunkRenderTypeSet.of((RenderType[])new RenderType[]{RenderType.m_110451_()});
    private final Cache<BlockModelCacheKey, BakedModel> cache = CacheBuilder.newBuilder().expireAfterAccess(2L, TimeUnit.MINUTES).concurrencyLevel(4).maximumSize(10000L).build();
    private final Cache<ItemModelCacheKey, BakedModel> itemCache = CacheBuilder.newBuilder().expireAfterAccess(2L, TimeUnit.MINUTES).concurrencyLevel(4).maximumSize(10000L).build();
    private final BakedModel innerModel;

    public MateriallyTexturedBakedModel(BakedModel innerModel) {
        this.innerModel = innerModel;
    }

    @NotNull
    public List<BakedQuad> m_213637_(@Nullable BlockState state, @Nullable Direction side, @NotNull RandomSource rand) {
        return this.innerModel.m_213637_(state, side, rand);
    }

    @NotNull
    public ChunkRenderTypeSet getRenderTypes(@NotNull BlockState state, @NotNull RandomSource rand, @NotNull ModelData data) {
        if (!data.has(ModProperties.MATERIAL_TEXTURE_PROPERTY)) {
            return ChunkRenderTypeSet.none();
        }
        MaterialTextureData textureData = (MaterialTextureData)data.get(ModProperties.MATERIAL_TEXTURE_PROPERTY);
        if (textureData == null) {
            return ChunkRenderTypeSet.none();
        }
        return ChunkRenderTypeSet.union((ChunkRenderTypeSet[])((ChunkRenderTypeSet[])Stream.concat(textureData.getTexturedComponents().values().stream().map(block -> Minecraft.m_91087_().m_91289_().m_110910_(block.m_49966_()).getRenderTypes(block.m_49966_(), rand, ModelData.EMPTY)), Stream.of(SOLID_ONLY)).toArray(ChunkRenderTypeSet[]::new)));
    }

    @NotNull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @NotNull RandomSource rand, @NotNull ModelData data, @Nullable RenderType renderType) {
        BakedModel remappedModel = this.getBakedInnerModelFor(data, state, renderType);
        return remappedModel.getQuads(state, side, rand, data, renderType);
    }

    public boolean m_7541_() {
        return this.innerModel.m_7541_();
    }

    public boolean m_7539_() {
        return this.innerModel.m_7539_();
    }

    public boolean m_7547_() {
        return this.innerModel.m_7547_();
    }

    public boolean m_7521_() {
        return this.innerModel.m_7521_();
    }

    @NotNull
    public TextureAtlasSprite m_6160_() {
        return this.innerModel.m_6160_();
    }

    @NotNull
    public TextureAtlasSprite getParticleIcon(@NotNull ModelData modelData) {
        if (!modelData.has(ModProperties.MATERIAL_TEXTURE_PROPERTY)) {
            return this.m_6160_();
        }
        MaterialTextureData textureData = (MaterialTextureData)modelData.get(ModProperties.MATERIAL_TEXTURE_PROPERTY);
        if (textureData == null) {
            return this.m_6160_();
        }
        ResourceLocation particleTextureName = this.m_6160_().m_118413_();
        if (!textureData.getTexturedComponents().containsKey(particleTextureName)) {
            return this.m_6160_();
        }
        return Minecraft.m_91087_().m_91289_().m_110910_(textureData.getTexturedComponents().get(particleTextureName).m_49966_()).getParticleIcon(modelData);
    }

    @NotNull
    public ItemTransforms m_7442_() {
        return this.innerModel.m_7442_();
    }

    @NotNull
    public ItemOverrides m_7343_() {
        return ItemOverrides.f_111734_;
    }

    @NotNull
    public List<RenderType> getRenderTypes(ItemStack itemStack, boolean fabulous) {
        Item item = itemStack.m_41720_();
        if (!(item instanceof BlockItem)) {
            return Collections.emptyList();
        }
        BlockItem blockItem = (BlockItem)item;
        MaterialTextureData textureData = MaterialTextureData.deserializeFromNBT(itemStack.m_41698_("textureData"));
        if (textureData.isEmpty()) {
            return Collections.emptyList();
        }
        return Lists.newArrayList(this.getRenderTypes(blockItem, textureData));
    }

    private Collection<RenderType> getRenderTypes(BlockItem blockItem, MaterialTextureData textureData) {
        List renderTypes = this.getRenderTypes(blockItem.m_40614_().m_49966_(), RANDOM, ModelData.builder().with(ModProperties.MATERIAL_TEXTURE_PROPERTY, (Object)textureData).build()).asList();
        HashSet<RenderType> renderTypesWithAdditionalComponents = new HashSet<RenderType>(renderTypes);
        renderTypesWithAdditionalComponents.add(RenderType.m_110451_());
        return renderTypesWithAdditionalComponents;
    }

    @NotNull
    public List<BakedModel> getRenderPasses(ItemStack itemStack, boolean fabulous) {
        Collection<RenderType> renderTypes;
        Item item = itemStack.m_41720_();
        if (!(item instanceof BlockItem)) {
            return Collections.emptyList();
        }
        BlockItem blockItem = (BlockItem)item;
        MaterialTextureData textureData = MaterialTextureData.deserializeFromNBT(itemStack.m_41698_("textureData"));
        if (textureData.isEmpty()) {
            textureData = MaterialTextureDataUtil.generateRandomTextureDataFrom(itemStack);
        }
        if ((renderTypes = this.getRenderTypes(blockItem, textureData)).isEmpty()) {
            return Collections.emptyList();
        }
        MaterialTextureData finalTextureData = textureData;
        ArrayList<BakedModel> models = new ArrayList<BakedModel>();
        renderTypes.stream().map(type -> MateriallyTexturedBakedModel.getRenderType(type, fabulous)).distinct().map(type -> new SpecificRenderTypeBakedModelWrapper((RenderType)type, this.getBakedInnerModelFor(itemStack, finalTextureData, blockItem.m_40614_().m_49966_(), (RenderType)type))).forEach(models::add);
        return models;
    }

    private BakedModel getBakedInnerModelFor(ModelData modelData, BlockState sourceState, RenderType renderType) {
        if (!modelData.has(ModProperties.MATERIAL_TEXTURE_PROPERTY)) {
            return this.getBakedInnerModelFor(MaterialTextureData.EMPTY, sourceState, renderType);
        }
        return this.getBakedInnerModelFor((MaterialTextureData)modelData.get(ModProperties.MATERIAL_TEXTURE_PROPERTY), sourceState, renderType);
    }

    private BakedModel getBakedInnerModelFor(MaterialTextureData modelData, BlockState sourceState, RenderType renderType) {
        try {
            BlockModelCacheKey key = new BlockModelCacheKey(modelData, renderType);
            return (BakedModel)this.cache.get((Object)key, () -> {
                RetexturedBakedModelBuilder builder = RetexturedBakedModelBuilder.createFor(sourceState, renderType, false, this.innerModel);
                modelData.getTexturedComponents().forEach(builder::with);
                return builder.build();
            });
        }
        catch (Exception exception) {
            LOGGER.error(String.format("Failed to build baked materially textured model for: %s", modelData), (Throwable)exception);
            return Minecraft.m_91087_().m_91304_().m_119409_();
        }
    }

    private BakedModel getBakedInnerModelFor(ItemStack stack, MaterialTextureData textureData, BlockState blockState, RenderType renderType) {
        try {
            ItemModelCacheKey key = new ItemModelCacheKey(textureData, renderType, stack.serializeNBT());
            return (BakedModel)this.itemCache.get((Object)key, () -> {
                RetexturedBakedModelBuilder builder = RetexturedBakedModelBuilder.createFor(blockState, renderType, true, this.innerModel.m_7343_().m_173464_(this.innerModel, stack, null, null, 0));
                textureData.getTexturedComponents().forEach(builder::with);
                return builder.build();
            });
        }
        catch (Exception exception) {
            LOGGER.error(String.format("Failed to build baked materially textured model for: %s for item: %s", textureData, stack), (Throwable)exception);
            return Minecraft.m_91087_().m_91304_().m_119409_();
        }
    }

    private ChunkRenderTypeSet createAdaptedSetForEntity(ChunkRenderTypeSet renderTypes, boolean fabulous) {
        return ChunkRenderTypeSet.of((Collection)renderTypes.asList().stream().map(renderType -> MateriallyTexturedBakedModel.getRenderType(renderType, fabulous)).collect(Collectors.toSet()));
    }

    public static RenderType getRenderType(RenderType renderType, boolean fabulous) {
        if (renderType == RenderType.m_110466_()) {
            if (!Minecraft.m_91085_()) {
                return Sheets.m_110792_();
            }
            return fabulous ? Sheets.m_110792_() : Sheets.m_110791_();
        }
        return Sheets.m_110790_();
    }

    public static RenderType getFabulousRenderType(RenderType renderType) {
        if (renderType == RenderType.m_110466_()) {
            return Sheets.m_110792_();
        }
        return Sheets.m_110790_();
    }

    public static RenderType getNoneFabulousRenderType(RenderType renderType) {
        if (renderType == RenderType.m_110466_()) {
            return !Minecraft.m_91085_() ? Sheets.m_110792_() : Sheets.m_110791_();
        }
        return Sheets.m_110790_();
    }

    private record BlockModelCacheKey(MaterialTextureData data, RenderType renderType) {
    }

    private record ItemModelCacheKey(MaterialTextureData data, RenderType renderType, CompoundTag tag) {
    }
}

