/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.domumornamentum.datagen.shingle.normal;

import com.google.gson.JsonElement;
import com.ldtteam.datagenerators.IJsonSerializable;
import com.ldtteam.datagenerators.blockstate.BlockstateJson;
import com.ldtteam.datagenerators.blockstate.BlockstateModelJson;
import com.ldtteam.datagenerators.blockstate.BlockstateVariantJson;
import com.ldtteam.domumornamentum.block.ModBlocks;
import com.ldtteam.domumornamentum.block.decorative.ShingleBlock;
import com.ldtteam.domumornamentum.util.DataGeneratorConstants;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Locale;
import net.minecraft.core.Direction;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.StairsShape;
import org.jetbrains.annotations.NotNull;

public class ShinglesBlockStateProvider
implements DataProvider {
    private final DataGenerator generator;

    public ShinglesBlockStateProvider(DataGenerator generator) {
        this.generator = generator;
    }

    public void m_213708_(@NotNull CachedOutput cache) throws IOException {
        this.createBlockstateFile(cache, ModBlocks.getInstance().getShingle());
    }

    private void createBlockstateFile(CachedOutput cache, ShingleBlock shingle) throws IOException {
        if (shingle.getRegistryName() == null) {
            return;
        }
        HashMap<CallSite, BlockstateVariantJson> variants = new HashMap<CallSite, BlockstateVariantJson>();
        for (Direction facingValue : StairBlock.f_56841_.m_6908_()) {
            for (StairsShape shapeValue : StairBlock.f_56843_.m_6908_()) {
                for (Half halfValue : StairBlock.f_56842_.m_6908_()) {
                    String variantKey = "facing=" + facingValue + ",shape=" + shapeValue + ",half=" + halfValue;
                    int y = this.getYFromFacing(facingValue);
                    y += this.getYFromShape(shapeValue);
                    int x = halfValue == Half.TOP ? 180 : 0;
                    String modelLocation = "domum_ornamentum:block/shingle/" + ShingleBlock.getTypeFromShape(shapeValue).name().toLowerCase(Locale.ROOT);
                    BlockstateModelJson model = new BlockstateModelJson(modelLocation, x, y += this.getYFromHalf(halfValue, shapeValue));
                    BlockstateVariantJson variant = new BlockstateVariantJson(model);
                    variants.put((CallSite)((Object)variantKey), variant);
                }
            }
        }
        BlockstateJson blockstate = new BlockstateJson(variants);
        Path blockstateFolder = this.generator.m_123916_().resolve("assets/domum_ornamentum/blockstates/");
        Path blockstatePath = blockstateFolder.resolve(shingle.getRegistryName().m_135815_() + ".json");
        DataProvider.m_236072_((CachedOutput)cache, (JsonElement)DataGeneratorConstants.serialize((IJsonSerializable)blockstate), (Path)blockstatePath);
    }

    @NotNull
    public String m_6055_() {
        return "Shingles BlockStates Provider";
    }

    private int getYFromHalf(Half half, StairsShape shape) {
        if (half == Half.TOP) {
            if (shape == StairsShape.STRAIGHT) {
                return 180;
            }
            return 270;
        }
        return 180;
    }

    private int getYFromShape(StairsShape shape) {
        return switch (shape) {
            default -> 0;
            case StairsShape.OUTER_LEFT, StairsShape.INNER_LEFT -> -90;
        };
    }

    private int getYFromFacing(Direction facing) {
        return switch (facing) {
            default -> 180;
            case Direction.SOUTH -> 270;
            case Direction.WEST -> 0;
            case Direction.NORTH -> 90;
        };
    }
}

