/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create;

import com.simibubi.create.AllTags;
import com.simibubi.create.Create;
import com.simibubi.create.content.contraptions.fluids.VirtualFluid;
import com.simibubi.create.content.contraptions.fluids.potion.PotionFluid;
import com.simibubi.create.content.palettes.AllPaletteStoneTypes;
import com.tterrag.registrate.builders.FluidBuilder;
import com.tterrag.registrate.util.entry.FluidEntry;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.fluids.FluidInteractionRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fluids.ForgeFlowingFluid;

public class AllFluids {
    public static final FluidEntry<PotionFluid> POTION = Create.REGISTRATE.virtualFluid("potion", PotionFluid.PotionFluidType::new, PotionFluid::new).lang("Potion").register();
    public static final FluidEntry<VirtualFluid> TEA = Create.REGISTRATE.virtualFluid("tea").lang("Builder's Tea").tag(new TagKey[]{AllTags.forgeFluidTag("tea")}).register();
    public static final FluidEntry<ForgeFlowingFluid.Flowing> HONEY = ((FluidBuilder)Create.REGISTRATE.standardFluid("honey", NoColorFluidAttributes::new).lang("Honey").properties(b -> b.viscosity(2000).density(1400)).fluidProperties(p -> p.levelDecreasePerBlock(2).tickRate(25).slopeFindDistance(3).explosionResistance(100.0f)).tag(new TagKey[]{AllTags.AllFluidTags.HONEY.tag}).source(ForgeFlowingFluid.Source::new).bucket().tag(new TagKey[]{AllTags.forgeItemTag("buckets/honey")}).build()).register();
    public static final FluidEntry<ForgeFlowingFluid.Flowing> CHOCOLATE = Create.REGISTRATE.standardFluid("chocolate", NoColorFluidAttributes::new).lang("Chocolate").tag(new TagKey[]{AllTags.forgeFluidTag("chocolate")}).properties(b -> b.viscosity(1500).density(1400)).fluidProperties(p -> p.levelDecreasePerBlock(2).tickRate(25).slopeFindDistance(3).explosionResistance(100.0f)).register();

    public static void register() {
    }

    public static void registerFluidInteractions() {
        FluidInteractionRegistry.addInteraction((FluidType)((FluidType)ForgeMod.LAVA_TYPE.get()), (FluidInteractionRegistry.InteractionInformation)new FluidInteractionRegistry.InteractionInformation(((ForgeFlowingFluid.Flowing)HONEY.get()).getFluidType(), fluidState -> {
            if (fluidState.m_76170_()) {
                return Blocks.f_50080_.m_49966_();
            }
            return ((Block)AllPaletteStoneTypes.LIMESTONE.getBaseBlock().get()).m_49966_();
        }));
        FluidInteractionRegistry.addInteraction((FluidType)((FluidType)ForgeMod.LAVA_TYPE.get()), (FluidInteractionRegistry.InteractionInformation)new FluidInteractionRegistry.InteractionInformation(((ForgeFlowingFluid.Flowing)CHOCOLATE.get()).getFluidType(), fluidState -> {
            if (fluidState.m_76170_()) {
                return Blocks.f_50080_.m_49966_();
            }
            return ((Block)AllPaletteStoneTypes.SCORIA.getBaseBlock().get()).m_49966_();
        }));
    }

    @Nullable
    public static BlockState getLavaInteraction(FluidState fluidState) {
        Fluid fluid = fluidState.m_76152_();
        if (fluid.m_6212_((Fluid)HONEY.get())) {
            return ((Block)AllPaletteStoneTypes.LIMESTONE.getBaseBlock().get()).m_49966_();
        }
        if (fluid.m_6212_((Fluid)CHOCOLATE.get())) {
            return ((Block)AllPaletteStoneTypes.SCORIA.getBaseBlock().get()).m_49966_();
        }
        return null;
    }

    private static class NoColorFluidAttributes
    extends TintedFluidType {
        public NoColorFluidAttributes(FluidType.Properties properties, ResourceLocation stillTexture, ResourceLocation flowingTexture) {
            super(properties, stillTexture, flowingTexture);
        }

        @Override
        protected int getTintColor(FluidStack stack) {
            return -1;
        }

        @Override
        public int getTintColor(FluidState state, BlockAndTintGetter world, BlockPos pos) {
            return 0xFFFFFF;
        }
    }

    public static abstract class TintedFluidType
    extends FluidType {
        protected static final int NO_TINT = -1;
        private ResourceLocation stillTexture;
        private ResourceLocation flowingTexture;

        public TintedFluidType(FluidType.Properties properties, ResourceLocation stillTexture, ResourceLocation flowingTexture) {
            super(properties);
            this.stillTexture = stillTexture;
            this.flowingTexture = flowingTexture;
        }

        public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
            consumer.accept(new IClientFluidTypeExtensions(){

                public ResourceLocation getStillTexture() {
                    return stillTexture;
                }

                public ResourceLocation getFlowingTexture() {
                    return flowingTexture;
                }

                public int getTintColor(FluidStack stack) {
                    return this.getTintColor(stack);
                }

                public int getTintColor(FluidState state, BlockAndTintGetter getter, BlockPos pos) {
                    return this.getTintColor(state, getter, pos);
                }
            });
        }

        protected abstract int getTintColor(FluidStack var1);

        protected abstract int getTintColor(FluidState var1, BlockAndTintGetter var2, BlockPos var3);
    }
}

