/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.fan;

import com.simibubi.create.content.contraptions.components.fan.AirCurrent;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.config.CKinetics;
import javax.annotation.Nullable;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;

@MethodsReturnNonnullByDefault
public interface IAirCurrentSource {
    @Nullable
    public AirCurrent getAirCurrent();

    @Nullable
    public Level getAirCurrentWorld();

    public BlockPos getAirCurrentPos();

    public float getSpeed();

    public Direction getAirflowOriginSide();

    @Nullable
    public Direction getAirFlowDirection();

    default public float getMaxDistance() {
        float speed = Math.abs(this.getSpeed());
        CKinetics config = AllConfigs.SERVER.kinetics;
        float distanceFactor = Math.min(speed / (float)((Integer)config.fanRotationArgmax.get()).intValue(), 1.0f);
        float pushDistance = Mth.m_14179_((float)distanceFactor, (float)3.0f, (float)((Integer)config.fanPushDistance.get()).intValue());
        float pullDistance = Mth.m_14179_((float)distanceFactor, (float)3.0f, (float)((Integer)config.fanPullDistance.get()).intValue());
        return this.getSpeed() > 0.0f ? pushDistance : pullDistance;
    }

    public boolean isSourceRemoved();
}

